/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry;

import com.azure.containers.containerregistry.ContainerRegistryClientBuilder;
import com.azure.containers.containerregistry.implementation.ArtifactManifestPropertiesHelper;
import com.azure.containers.containerregistry.implementation.ArtifactTagPropertiesHelper;
import com.azure.containers.containerregistry.implementation.AzureContainerRegistryImpl;
import com.azure.containers.containerregistry.implementation.ContainerRegistriesImpl;
import com.azure.containers.containerregistry.implementation.UtilsImpl;
import com.azure.containers.containerregistry.implementation.models.AcrErrorsException;
import com.azure.containers.containerregistry.implementation.models.ArtifactManifestPropertiesInternal;
import com.azure.containers.containerregistry.implementation.models.ArtifactTagPropertiesInternal;
import com.azure.containers.containerregistry.implementation.models.ManifestWriteableProperties;
import com.azure.containers.containerregistry.implementation.models.TagAttributesBase;
import com.azure.containers.containerregistry.implementation.models.TagWriteableProperties;
import com.azure.containers.containerregistry.models.ArtifactManifestProperties;
import com.azure.containers.containerregistry.models.ArtifactTagOrder;
import com.azure.containers.containerregistry.models.ArtifactTagProperties;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import java.util.Objects;

@ServiceClient(builder=ContainerRegistryClientBuilder.class)
public final class RegistryArtifact {
    private static final ClientLogger LOGGER = new ClientLogger(RegistryArtifact.class);
    private final String fullyQualifiedReference;
    private final String endpoint;
    private final String repositoryName;
    private final String tagOrDigest;
    private final ContainerRegistriesImpl serviceClient;
    private String digest;

    RegistryArtifact(String repositoryName, String tagOrDigest, HttpPipeline httpPipeline, String endpoint, String version) {
        Objects.requireNonNull(repositoryName, "'repositoryName' cannot be null.");
        if (repositoryName.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'repositoryName' can't be empty"));
        }
        Objects.requireNonNull(tagOrDigest, "'tagOrDigest' cannot be null.");
        if (tagOrDigest.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'digest' can't be empty"));
        }
        this.serviceClient = new AzureContainerRegistryImpl(httpPipeline, endpoint, version).getContainerRegistries();
        this.fullyQualifiedReference = UtilsImpl.formatFullyQualifiedReference(endpoint, repositoryName, tagOrDigest);
        this.endpoint = endpoint;
        this.repositoryName = repositoryName;
        this.tagOrDigest = tagOrDigest;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(Context context) {
        String res = this.getDigest();
        try {
            Response<Void> response = this.serviceClient.deleteManifestWithResponse(this.getRepositoryName(), res, context);
            return UtilsImpl.deleteResponseToSuccess(response);
        }
        catch (AcrErrorsException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)UtilsImpl.mapAcrErrorsException(exception)));
        }
    }

    private String getDigest() {
        if (this.digest == null) {
            this.digest = UtilsImpl.isDigest(this.tagOrDigest) ? this.tagOrDigest : this.getTagProperties(this.tagOrDigest).getDigest();
        }
        return this.digest;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTagWithResponse(String tag, Context context) {
        Objects.requireNonNull(tag, "'tag' cannot be null.");
        if (tag.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'tag' cannot be empty."));
        }
        try {
            Response<Void> response = this.serviceClient.deleteTagWithResponse(this.getRepositoryName(), tag, context);
            return UtilsImpl.deleteResponseToSuccess(response);
        }
        catch (AcrErrorsException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)UtilsImpl.mapAcrErrorsException(exception)));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTag(String tag) {
        this.deleteTagWithResponse(tag, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ArtifactManifestProperties> getManifestPropertiesWithResponse(Context context) {
        String res = this.getDigest();
        try {
            Response<ArtifactManifestPropertiesInternal> internalResponse = this.serviceClient.getManifestPropertiesWithResponse(this.getRepositoryName(), res, context);
            return new SimpleResponse(internalResponse, (Object)ArtifactManifestPropertiesHelper.create((ArtifactManifestPropertiesInternal)internalResponse.getValue()));
        }
        catch (AcrErrorsException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)UtilsImpl.mapAcrErrorsException(exception)));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ArtifactManifestProperties getManifestProperties() {
        return (ArtifactManifestProperties)this.getManifestPropertiesWithResponse(Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ArtifactTagProperties> getTagPropertiesWithResponse(String tag, Context context) {
        Objects.requireNonNull(tag, "'tag' cannot be null.");
        if (tag.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'tag' cannot be empty."));
        }
        try {
            Response<ArtifactTagPropertiesInternal> internalResponse = this.serviceClient.getTagPropertiesWithResponse(this.getRepositoryName(), tag, context);
            return new SimpleResponse(internalResponse, (Object)ArtifactTagPropertiesHelper.create((ArtifactTagPropertiesInternal)internalResponse.getValue()));
        }
        catch (AcrErrorsException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)UtilsImpl.mapAcrErrorsException(exception)));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ArtifactTagProperties getTagProperties(String tag) {
        return (ArtifactTagProperties)this.getTagPropertiesWithResponse(tag, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ArtifactTagProperties> listTagProperties() {
        return this.listTagProperties(ArtifactTagOrder.NONE, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ArtifactTagProperties> listTagProperties(ArtifactTagOrder order) {
        return this.listTagProperties(order, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ArtifactTagProperties> listTagProperties(ArtifactTagOrder order, Context context) {
        return this.listTagPropertiesSync(order, context);
    }

    private PagedResponse<ArtifactTagProperties> listTagPropertiesNextSinglePageSync(String nextLink, Context context) {
        try {
            PagedResponse<TagAttributesBase> res = this.serviceClient.getTagsNextSinglePage(nextLink, context);
            return UtilsImpl.getPagedResponseWithContinuationToken(res, baseValues -> UtilsImpl.getTagProperties(baseValues, this.getRepositoryName()));
        }
        catch (AcrErrorsException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)UtilsImpl.mapAcrErrorsException(exception)));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ArtifactTagProperties> updateTagPropertiesWithResponse(String tag, ArtifactTagProperties tagProperties, Context context) {
        Objects.requireNonNull(tag, "'tag' cannot be null.");
        Objects.requireNonNull(tagProperties, "'tagProperties' cannot be null.");
        if (tag.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'tag' cannot be empty."));
        }
        TagWriteableProperties writeableProperties = new TagWriteableProperties().setDeleteEnabled(tagProperties.isDeleteEnabled()).setListEnabled(tagProperties.isListEnabled()).setReadEnabled(tagProperties.isReadEnabled()).setWriteEnabled(tagProperties.isWriteEnabled());
        try {
            Response<ArtifactTagPropertiesInternal> internalResponse = this.serviceClient.updateTagAttributesWithResponse(this.getRepositoryName(), tag, writeableProperties, context);
            return new SimpleResponse(internalResponse, (Object)ArtifactTagPropertiesHelper.create((ArtifactTagPropertiesInternal)internalResponse.getValue()));
        }
        catch (AcrErrorsException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)UtilsImpl.mapAcrErrorsException(exception)));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ArtifactTagProperties updateTagProperties(String tag, ArtifactTagProperties tagProperties) {
        return (ArtifactTagProperties)this.updateTagPropertiesWithResponse(tag, tagProperties, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ArtifactManifestProperties> updateManifestPropertiesWithResponse(ArtifactManifestProperties manifestProperties, Context context) {
        Objects.requireNonNull(manifestProperties, "'manifestProperties' cannot be null.");
        ManifestWriteableProperties writeableProperties = new ManifestWriteableProperties().setDeleteEnabled(manifestProperties.isDeleteEnabled()).setListEnabled(manifestProperties.isListEnabled()).setWriteEnabled(manifestProperties.isWriteEnabled()).setReadEnabled(manifestProperties.isReadEnabled());
        String res = this.getDigest();
        try {
            Response<ArtifactManifestPropertiesInternal> internalResponse = this.serviceClient.updateManifestPropertiesWithResponse(this.getRepositoryName(), res, writeableProperties, context);
            return new SimpleResponse(internalResponse, (Object)ArtifactManifestPropertiesHelper.create((ArtifactManifestPropertiesInternal)internalResponse.getValue()));
        }
        catch (AcrErrorsException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)UtilsImpl.mapAcrErrorsException(exception)));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ArtifactManifestProperties updateManifestProperties(ArtifactManifestProperties manifestProperties) {
        return (ArtifactManifestProperties)this.updateManifestPropertiesWithResponse(manifestProperties, Context.NONE).getValue();
    }

    public String getRegistryEndpoint() {
        return this.endpoint;
    }

    public String getFullyQualifiedReference() {
        return this.fullyQualifiedReference;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    private PagedIterable<ArtifactTagProperties> listTagPropertiesSync(ArtifactTagOrder order, Context context) {
        return new PagedIterable(pageSize -> this.listTagPropertiesSinglePageSync((Integer)pageSize, order, context), (token, pageSize) -> this.listTagPropertiesNextSinglePageSync((String)token, context));
    }

    private PagedResponse<ArtifactTagProperties> listTagPropertiesSinglePageSync(Integer pageSize, ArtifactTagOrder order, Context context) {
        if (pageSize != null && pageSize < 0) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'pageSize' cannot be negative."));
        }
        String orderString = order.equals((Object)ArtifactTagOrder.NONE) ? null : order.toString();
        String res = this.getDigest();
        try {
            PagedResponse<TagAttributesBase> response = this.serviceClient.getTagsSinglePage(this.getRepositoryName(), null, pageSize, orderString, res, context);
            return UtilsImpl.getPagedResponseWithContinuationToken(response, baseValues -> UtilsImpl.getTagProperties(baseValues, this.getRepositoryName()));
        }
        catch (AcrErrorsException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)UtilsImpl.mapAcrErrorsException(exception)));
        }
    }
}

