/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry;

import com.azure.containers.containerregistry.ContainerRegistryClientBuilder;
import com.azure.containers.containerregistry.implementation.ArtifactManifestPropertiesHelper;
import com.azure.containers.containerregistry.implementation.ArtifactTagPropertiesHelper;
import com.azure.containers.containerregistry.implementation.AzureContainerRegistryImpl;
import com.azure.containers.containerregistry.implementation.ContainerRegistriesImpl;
import com.azure.containers.containerregistry.implementation.UtilsImpl;
import com.azure.containers.containerregistry.implementation.models.AcrErrorsException;
import com.azure.containers.containerregistry.implementation.models.ArtifactManifestPropertiesInternal;
import com.azure.containers.containerregistry.implementation.models.ArtifactTagPropertiesInternal;
import com.azure.containers.containerregistry.implementation.models.ManifestWriteableProperties;
import com.azure.containers.containerregistry.implementation.models.TagWriteableProperties;
import com.azure.containers.containerregistry.models.ArtifactManifestProperties;
import com.azure.containers.containerregistry.models.ArtifactTagOrder;
import com.azure.containers.containerregistry.models.ArtifactTagProperties;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.util.Objects;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ContainerRegistryClientBuilder.class, isAsync=true)
public final class RegistryArtifactAsync {
    private static final ClientLogger LOGGER = new ClientLogger(RegistryArtifactAsync.class);
    private final String fullyQualifiedReference;
    private final String endpoint;
    private final String repositoryName;
    private final ContainerRegistriesImpl serviceClient;
    private final Mono<String> digestMono;

    RegistryArtifactAsync(String repositoryName, String tagOrDigest, HttpPipeline httpPipeline, String endpoint, String version) {
        Objects.requireNonNull(repositoryName, "'repositoryName' cannot be null.");
        if (repositoryName.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'repositoryName' can't be empty"));
        }
        Objects.requireNonNull(tagOrDigest, "'tagOrDigest' cannot be null.");
        if (tagOrDigest.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'digest' can't be empty"));
        }
        this.serviceClient = new AzureContainerRegistryImpl(httpPipeline, endpoint, version).getContainerRegistries();
        this.fullyQualifiedReference = UtilsImpl.formatFullyQualifiedReference(endpoint, repositoryName, tagOrDigest);
        this.endpoint = endpoint;
        this.repositoryName = repositoryName;
        this.digestMono = UtilsImpl.isDigest(tagOrDigest) ? Mono.just((Object)tagOrDigest) : Mono.defer(() -> this.getTagProperties(tagOrDigest).map(a -> a.getDigest()).cache());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponse() {
        return FluxUtil.withContext(context -> this.deleteWithResponse((Context)context));
    }

    private Mono<Response<Void>> deleteWithResponse(Context context) {
        return this.digestMono.flatMap(res -> this.serviceClient.deleteManifestWithResponseAsync(this.getRepositoryName(), (String)res, context)).map(UtilsImpl::deleteResponseToSuccess).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> delete() {
        return this.deleteWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTagWithResponse(String tag) {
        return FluxUtil.withContext(context -> this.deleteTagWithResponse(tag, (Context)context));
    }

    private Mono<Response<Void>> deleteTagWithResponse(String tag, Context context) {
        if (tag == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'tag' cannot be null"));
        }
        if (tag.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'tag' cannot be empty."));
        }
        return this.serviceClient.deleteTagWithResponseAsync(this.getRepositoryName(), tag, context).map(UtilsImpl::deleteResponseToSuccess).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTag(String tag) {
        return this.deleteTagWithResponse(tag).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ArtifactManifestProperties>> getManifestPropertiesWithResponse() {
        return FluxUtil.withContext(context -> this.getManifestPropertiesWithResponse((Context)context));
    }

    private Mono<Response<ArtifactManifestProperties>> getManifestPropertiesWithResponse(Context context) {
        return this.digestMono.flatMap(res -> this.serviceClient.getManifestPropertiesWithResponseAsync(this.getRepositoryName(), (String)res, context)).map(internalResponse -> new SimpleResponse(internalResponse, (Object)ArtifactManifestPropertiesHelper.create((ArtifactManifestPropertiesInternal)internalResponse.getValue()))).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ArtifactManifestProperties> getManifestProperties() {
        return this.getManifestPropertiesWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ArtifactTagProperties>> getTagPropertiesWithResponse(String tag) {
        return FluxUtil.withContext(context -> this.getTagPropertiesWithResponse(tag, (Context)context));
    }

    private Mono<Response<ArtifactTagProperties>> getTagPropertiesWithResponse(String tag, Context context) {
        if (tag == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'tag' cannot be null."));
        }
        if (tag.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'tag' cannot be empty."));
        }
        return this.serviceClient.getTagPropertiesWithResponseAsync(this.getRepositoryName(), tag, context).map(internalResponse -> new SimpleResponse(internalResponse, (Object)ArtifactTagPropertiesHelper.create((ArtifactTagPropertiesInternal)internalResponse.getValue()))).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ArtifactTagProperties> getTagProperties(String tag) {
        return this.getTagPropertiesWithResponse(tag).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ArtifactTagProperties> listTagProperties() {
        return this.listTagProperties(ArtifactTagOrder.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ArtifactTagProperties> listTagProperties(ArtifactTagOrder order) {
        return new PagedFlux(pageSize -> FluxUtil.withContext(context -> this.listTagPropertiesSinglePageAsync((Integer)pageSize, order, (Context)context)), (token, pageSize) -> FluxUtil.withContext(context -> this.listTagPropertiesNextSinglePageAsync((String)token, (Context)context)));
    }

    private Mono<PagedResponse<ArtifactTagProperties>> listTagPropertiesSinglePageAsync(Integer pageSize, ArtifactTagOrder order, Context context) {
        if (pageSize != null && pageSize < 0) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'pageSize' cannot be negative."));
        }
        String orderString = order.equals((Object)ArtifactTagOrder.NONE) ? null : order.toString();
        return this.digestMono.flatMap(digest -> this.serviceClient.getTagsSinglePageAsync(this.getRepositoryName(), null, pageSize, orderString, (String)digest, context)).map(digest -> UtilsImpl.getPagedResponseWithContinuationToken(digest, baseValues -> UtilsImpl.getTagProperties(baseValues, this.getRepositoryName()))).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
    }

    private Mono<PagedResponse<ArtifactTagProperties>> listTagPropertiesNextSinglePageAsync(String nextLink, Context context) {
        return this.serviceClient.getTagsNextSinglePageAsync(nextLink, context).map(res -> UtilsImpl.getPagedResponseWithContinuationToken(res, baseValues -> UtilsImpl.getTagProperties(baseValues, this.getRepositoryName()))).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ArtifactTagProperties>> updateTagPropertiesWithResponse(String tag, ArtifactTagProperties tagProperties) {
        return FluxUtil.withContext(context -> this.updateTagPropertiesWithResponse(tag, tagProperties, (Context)context));
    }

    private Mono<Response<ArtifactTagProperties>> updateTagPropertiesWithResponse(String tag, ArtifactTagProperties tagProperties, Context context) {
        if (tag == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'tag' cannot be null."));
        }
        if (tag.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'tag' cannot be empty."));
        }
        if (tagProperties == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'tagProperties' cannot be null."));
        }
        TagWriteableProperties writeableProperties = new TagWriteableProperties().setDeleteEnabled(tagProperties.isDeleteEnabled()).setListEnabled(tagProperties.isListEnabled()).setReadEnabled(tagProperties.isReadEnabled()).setWriteEnabled(tagProperties.isWriteEnabled());
        return this.serviceClient.updateTagAttributesWithResponseAsync(this.getRepositoryName(), tag, writeableProperties, context).map(internalResponse -> new SimpleResponse(internalResponse, (Object)ArtifactTagPropertiesHelper.create((ArtifactTagPropertiesInternal)internalResponse.getValue()))).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ArtifactTagProperties> updateTagProperties(String tag, ArtifactTagProperties tagProperties) {
        return this.updateTagPropertiesWithResponse(tag, tagProperties).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ArtifactManifestProperties>> updateManifestPropertiesWithResponse(ArtifactManifestProperties manifestProperties) {
        return FluxUtil.withContext(context -> this.updateManifestPropertiesWithResponse(manifestProperties, (Context)context));
    }

    private Mono<Response<ArtifactManifestProperties>> updateManifestPropertiesWithResponse(ArtifactManifestProperties manifestProperties, Context context) {
        if (manifestProperties == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'value' cannot be null."));
        }
        ManifestWriteableProperties writeableProperties = new ManifestWriteableProperties().setDeleteEnabled(manifestProperties.isDeleteEnabled()).setListEnabled(manifestProperties.isListEnabled()).setWriteEnabled(manifestProperties.isWriteEnabled()).setReadEnabled(manifestProperties.isReadEnabled());
        return this.digestMono.flatMap(digest -> this.serviceClient.updateManifestPropertiesWithResponseAsync(this.getRepositoryName(), (String)digest, writeableProperties, context)).map(internalResponse -> new SimpleResponse(internalResponse, (Object)ArtifactManifestPropertiesHelper.create((ArtifactManifestPropertiesInternal)internalResponse.getValue()))).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ArtifactManifestProperties> updateManifestProperties(ArtifactManifestProperties manifestProperties) {
        return this.updateManifestPropertiesWithResponse(manifestProperties).flatMap(FluxUtil::toMono);
    }

    public String getRegistryEndpoint() {
        return this.endpoint;
    }

    public String getFullyQualifiedReference() {
        return this.fullyQualifiedReference;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }
}

