/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation.models;

import com.azure.containers.containerregistry.implementation.models.ManifestAttributesBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class AcrManifests
implements JsonSerializable<AcrManifests> {
    private String registryLoginServer;
    private String repository;
    private List<ManifestAttributesBase> manifests;
    private String link;

    public String getRegistryLoginServer() {
        return this.registryLoginServer;
    }

    public AcrManifests setRegistryLoginServer(String registryLoginServer) {
        this.registryLoginServer = registryLoginServer;
        return this;
    }

    public String getRepository() {
        return this.repository;
    }

    public AcrManifests setRepository(String repository) {
        this.repository = repository;
        return this;
    }

    public List<ManifestAttributesBase> getManifests() {
        return this.manifests;
    }

    public AcrManifests setManifests(List<ManifestAttributesBase> manifests) {
        this.manifests = manifests;
        return this;
    }

    public String getLink() {
        return this.link;
    }

    public AcrManifests setLink(String link) {
        this.link = link;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("registry", this.registryLoginServer);
        jsonWriter.writeStringField("imageName", this.repository);
        jsonWriter.writeArrayField("manifests", this.manifests, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("link", this.link);
        return jsonWriter.writeEndObject();
    }

    public static AcrManifests fromJson(JsonReader jsonReader) throws IOException {
        return (AcrManifests)jsonReader.readObject(reader -> {
            AcrManifests deserializedAcrManifests = new AcrManifests();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("registry".equals(fieldName)) {
                    deserializedAcrManifests.registryLoginServer = reader.getString();
                    continue;
                }
                if ("imageName".equals(fieldName)) {
                    deserializedAcrManifests.repository = reader.getString();
                    continue;
                }
                if ("manifests".equals(fieldName)) {
                    List manifests;
                    deserializedAcrManifests.manifests = manifests = reader.readArray(reader1 -> ManifestAttributesBase.fromJson(reader1));
                    continue;
                }
                if ("link".equals(fieldName)) {
                    deserializedAcrManifests.link = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcrManifests;
        });
    }
}

