/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.models;

import com.azure.containers.containerregistry.models.ArtifactArchitecture;
import com.azure.containers.containerregistry.models.ArtifactOperatingSystem;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class ArtifactManifestPlatform
implements JsonSerializable<ArtifactManifestPlatform> {
    private String digest;
    private ArtifactArchitecture architecture;
    private ArtifactOperatingSystem operatingSystem;

    public String getDigest() {
        return this.digest;
    }

    public ArtifactArchitecture getArchitecture() {
        return this.architecture;
    }

    public ArtifactOperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("digest", this.digest);
        jsonWriter.writeStringField("architecture", Objects.toString((Object)this.architecture, null));
        jsonWriter.writeStringField("os", Objects.toString((Object)this.operatingSystem, null));
        return jsonWriter.writeEndObject();
    }

    public static ArtifactManifestPlatform fromJson(JsonReader jsonReader) throws IOException {
        return (ArtifactManifestPlatform)jsonReader.readObject(reader -> {
            ArtifactManifestPlatform deserializedArtifactManifestPlatform = new ArtifactManifestPlatform();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("digest".equals(fieldName)) {
                    deserializedArtifactManifestPlatform.digest = reader.getString();
                    continue;
                }
                if ("architecture".equals(fieldName)) {
                    deserializedArtifactManifestPlatform.architecture = ArtifactArchitecture.fromString(reader.getString());
                    continue;
                }
                if ("os".equals(fieldName)) {
                    deserializedArtifactManifestPlatform.operatingSystem = ArtifactOperatingSystem.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedArtifactManifestPlatform;
        });
    }
}

