// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.containers.containerregistry.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;

/** The ContainerRegistryBlobsGetUploadStatusHeaders model. */
@Fluent
public final class ContainerRegistryBlobsGetUploadStatusHeaders {
    /*
     * The Docker-Upload-UUID property.
     */
    private String dockerUploadUUID;

    /*
     * The Range property.
     */
    private String range;

    private static final HttpHeaderName DOCKER_UPLOAD_UUID = HttpHeaderName.fromString("Docker-Upload-UUID");

    // HttpHeaders containing the raw property values.
    /**
     * Creates an instance of ContainerRegistryBlobsGetUploadStatusHeaders class.
     *
     * @param rawHeaders The raw HttpHeaders that will be used to create the property values.
     */
    public ContainerRegistryBlobsGetUploadStatusHeaders(HttpHeaders rawHeaders) {
        this.dockerUploadUUID = rawHeaders.getValue(DOCKER_UPLOAD_UUID);
        this.range = rawHeaders.getValue(HttpHeaderName.RANGE);
    }

    /**
     * Get the dockerUploadUUID property: The Docker-Upload-UUID property.
     *
     * @return the dockerUploadUUID value.
     */
    public String getDockerUploadUUID() {
        return this.dockerUploadUUID;
    }

    /**
     * Set the dockerUploadUUID property: The Docker-Upload-UUID property.
     *
     * @param dockerUploadUUID the dockerUploadUUID value to set.
     * @return the ContainerRegistryBlobsGetUploadStatusHeaders object itself.
     */
    public ContainerRegistryBlobsGetUploadStatusHeaders setDockerUploadUUID(String dockerUploadUUID) {
        this.dockerUploadUUID = dockerUploadUUID;
        return this;
    }

    /**
     * Get the range property: The Range property.
     *
     * @return the range value.
     */
    public String getRange() {
        return this.range;
    }

    /**
     * Set the range property: The Range property.
     *
     * @param range the range value to set.
     * @return the ContainerRegistryBlobsGetUploadStatusHeaders object itself.
     */
    public ContainerRegistryBlobsGetUploadStatusHeaders setRange(String range) {
        this.range = range;
        return this;
    }
}
