/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation;

import com.azure.containers.containerregistry.implementation.AzureContainerRegistryImpl;
import com.azure.containers.containerregistry.implementation.models.AcrErrorsException;
import com.azure.containers.containerregistry.implementation.models.AcrManifests;
import com.azure.containers.containerregistry.implementation.models.ArtifactManifestPropertiesInternal;
import com.azure.containers.containerregistry.implementation.models.ArtifactTagPropertiesInternal;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistriesCreateManifestHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistriesGetManifestsHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistriesGetManifestsNextHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistriesGetRepositoriesHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistriesGetRepositoriesNextHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistriesGetTagsHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistriesGetTagsNextHeaders;
import com.azure.containers.containerregistry.implementation.models.DeleteRepositoryResult;
import com.azure.containers.containerregistry.implementation.models.ManifestAttributesBase;
import com.azure.containers.containerregistry.implementation.models.ManifestWriteableProperties;
import com.azure.containers.containerregistry.implementation.models.Repositories;
import com.azure.containers.containerregistry.implementation.models.RepositoryWriteableProperties;
import com.azure.containers.containerregistry.implementation.models.TagAttributesBase;
import com.azure.containers.containerregistry.implementation.models.TagList;
import com.azure.containers.containerregistry.implementation.models.TagWriteableProperties;
import com.azure.containers.containerregistry.models.ContainerRepositoryProperties;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ContainerRegistriesImpl {
    private final ContainerRegistriesService service;
    private final AzureContainerRegistryImpl client;

    ContainerRegistriesImpl(AzureContainerRegistryImpl client) {
        this.service = (ContainerRegistriesService)RestProxy.create(ContainerRegistriesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> checkDockerV2SupportWithResponseAsync() {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkDockerV2Support(this.client.getUrl(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> checkDockerV2SupportWithResponseAsync(Context context) {
        String accept = "application/json";
        return this.service.checkDockerV2Support(this.client.getUrl(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> checkDockerV2SupportAsync() {
        return this.checkDockerV2SupportWithResponseAsync().flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> checkDockerV2SupportAsync(Context context) {
        return this.checkDockerV2SupportWithResponseAsync(context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> checkDockerV2SupportWithResponse(Context context) {
        String accept = "application/json";
        return this.service.checkDockerV2SupportSync(this.client.getUrl(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void checkDockerV2Support() {
        this.checkDockerV2SupportWithResponse(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getManifestWithResponseAsync(String name, String reference, String accept) {
        return FluxUtil.withContext(context -> this.service.getManifest(this.client.getUrl(), name, reference, accept, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getManifestWithResponseAsync(String name, String reference, String accept, Context context) {
        return this.service.getManifest(this.client.getUrl(), name, reference, accept, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> getManifestAsync(String name, String reference, String accept) {
        return this.getManifestWithResponseAsync(name, reference, accept).flatMap(res -> Mono.justOrEmpty((Object)((BinaryData)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> getManifestAsync(String name, String reference, String accept, Context context) {
        return this.getManifestWithResponseAsync(name, reference, accept, context).flatMap(res -> Mono.justOrEmpty((Object)((BinaryData)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getManifestWithResponse(String name, String reference, String accept, Context context) {
        return this.service.getManifestSync(this.client.getUrl(), name, reference, accept, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData getManifest(String name, String reference, String accept) {
        return (BinaryData)this.getManifestWithResponse(name, reference, accept, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistriesCreateManifestHeaders, Void>> createManifestWithResponseAsync(String name, String reference, Flux<ByteBuffer> payload, long contentLength, String contentType) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createManifest(this.client.getUrl(), name, reference, contentType, payload, contentLength, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistriesCreateManifestHeaders, Void>> createManifestWithResponseAsync(String name, String reference, Flux<ByteBuffer> payload, long contentLength, String contentType, Context context) {
        String accept = "application/json";
        return this.service.createManifest(this.client.getUrl(), name, reference, contentType, payload, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createManifestAsync(String name, String reference, Flux<ByteBuffer> payload, long contentLength, String contentType) {
        return this.createManifestWithResponseAsync(name, reference, payload, contentLength, contentType).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createManifestAsync(String name, String reference, Flux<ByteBuffer> payload, long contentLength, String contentType, Context context) {
        return this.createManifestWithResponseAsync(name, reference, payload, contentLength, contentType, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistriesCreateManifestHeaders, Void>> createManifestWithResponseAsync(String name, String reference, BinaryData payload, long contentLength, String contentType) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createManifest(this.client.getUrl(), name, reference, contentType, payload, contentLength, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistriesCreateManifestHeaders, Void>> createManifestWithResponseAsync(String name, String reference, BinaryData payload, long contentLength, String contentType, Context context) {
        String accept = "application/json";
        return this.service.createManifest(this.client.getUrl(), name, reference, contentType, payload, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createManifestAsync(String name, String reference, BinaryData payload, long contentLength, String contentType) {
        return this.createManifestWithResponseAsync(name, reference, payload, contentLength, contentType).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createManifestAsync(String name, String reference, BinaryData payload, long contentLength, String contentType, Context context) {
        return this.createManifestWithResponseAsync(name, reference, payload, contentLength, contentType, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ContainerRegistriesCreateManifestHeaders, Void> createManifestWithResponse(String name, String reference, BinaryData payload, long contentLength, String contentType, Context context) {
        String accept = "application/json";
        return this.service.createManifestSync(this.client.getUrl(), name, reference, contentType, payload, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createManifest(String name, String reference, BinaryData payload, long contentLength, String contentType) {
        this.createManifestWithResponse(name, reference, payload, contentLength, contentType, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteManifestWithResponseAsync(String name, String reference) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteManifest(this.client.getUrl(), name, reference, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteManifestWithResponseAsync(String name, String reference, Context context) {
        String accept = "application/json";
        return this.service.deleteManifest(this.client.getUrl(), name, reference, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteManifestAsync(String name, String reference) {
        return this.deleteManifestWithResponseAsync(name, reference).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteManifestAsync(String name, String reference, Context context) {
        return this.deleteManifestWithResponseAsync(name, reference, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteManifestWithResponse(String name, String reference, Context context) {
        String accept = "application/json";
        return this.service.deleteManifestSync(this.client.getUrl(), name, reference, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteManifest(String name, String reference) {
        this.deleteManifestWithResponse(name, reference, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<String>> getRepositoriesSinglePageAsync(String last, Integer n, Context context) {
        String accept = "application/json";
        return this.service.getRepositories(this.client.getUrl(), last, n, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((Repositories)res.getValue()).getRepositories(), ((Repositories)res.getValue()).getLink(), (Object)((ContainerRegistriesGetRepositoriesHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> getRepositoriesAsync(String last, Integer n, Context context) {
        return new PagedFlux(() -> this.getRepositoriesSinglePageAsync(last, n, context), nextLink -> this.getRepositoriesNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<String> getRepositoriesSinglePage(String last, Integer n, Context context) {
        String accept = "application/json";
        ResponseBase<ContainerRegistriesGetRepositoriesHeaders, Repositories> res = this.service.getRepositoriesSync(this.client.getUrl(), last, n, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((Repositories)res.getValue()).getRepositories(), ((Repositories)res.getValue()).getLink(), (Object)((ContainerRegistriesGetRepositoriesHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> getRepositories(String last, Integer n, Context context) {
        return new PagedIterable(() -> this.getRepositoriesSinglePage(last, n, context), nextLink -> this.getRepositoriesNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ContainerRepositoryProperties>> getPropertiesWithResponseAsync(String name) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getProperties(this.client.getUrl(), name, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ContainerRepositoryProperties>> getPropertiesWithResponseAsync(String name, Context context) {
        String accept = "application/json";
        return this.service.getProperties(this.client.getUrl(), name, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainerRepositoryProperties> getPropertiesAsync(String name) {
        return this.getPropertiesWithResponseAsync(name).flatMap(res -> Mono.justOrEmpty((Object)((ContainerRepositoryProperties)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainerRepositoryProperties> getPropertiesAsync(String name, Context context) {
        return this.getPropertiesWithResponseAsync(name, context).flatMap(res -> Mono.justOrEmpty((Object)((ContainerRepositoryProperties)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ContainerRepositoryProperties> getPropertiesWithResponse(String name, Context context) {
        String accept = "application/json";
        return this.service.getPropertiesSync(this.client.getUrl(), name, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ContainerRepositoryProperties getProperties(String name) {
        return (ContainerRepositoryProperties)this.getPropertiesWithResponse(name, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeleteRepositoryResult>> deleteRepositoryWithResponseAsync(String name) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteRepository(this.client.getUrl(), name, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeleteRepositoryResult>> deleteRepositoryWithResponseAsync(String name, Context context) {
        String accept = "application/json";
        return this.service.deleteRepository(this.client.getUrl(), name, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeleteRepositoryResult> deleteRepositoryAsync(String name) {
        return this.deleteRepositoryWithResponseAsync(name).flatMap(res -> Mono.justOrEmpty((Object)((DeleteRepositoryResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeleteRepositoryResult> deleteRepositoryAsync(String name, Context context) {
        return this.deleteRepositoryWithResponseAsync(name, context).flatMap(res -> Mono.justOrEmpty((Object)((DeleteRepositoryResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeleteRepositoryResult> deleteRepositoryWithResponse(String name, Context context) {
        String accept = "application/json";
        return this.service.deleteRepositorySync(this.client.getUrl(), name, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeleteRepositoryResult deleteRepository(String name) {
        return (DeleteRepositoryResult)this.deleteRepositoryWithResponse(name, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ContainerRepositoryProperties>> updatePropertiesWithResponseAsync(String name, RepositoryWriteableProperties value) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateProperties(this.client.getUrl(), name, this.client.getApiVersion(), value, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ContainerRepositoryProperties>> updatePropertiesWithResponseAsync(String name, RepositoryWriteableProperties value, Context context) {
        String accept = "application/json";
        return this.service.updateProperties(this.client.getUrl(), name, this.client.getApiVersion(), value, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainerRepositoryProperties> updatePropertiesAsync(String name, RepositoryWriteableProperties value) {
        return this.updatePropertiesWithResponseAsync(name, value).flatMap(res -> Mono.justOrEmpty((Object)((ContainerRepositoryProperties)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainerRepositoryProperties> updatePropertiesAsync(String name, RepositoryWriteableProperties value, Context context) {
        return this.updatePropertiesWithResponseAsync(name, value, context).flatMap(res -> Mono.justOrEmpty((Object)((ContainerRepositoryProperties)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ContainerRepositoryProperties> updatePropertiesWithResponse(String name, RepositoryWriteableProperties value, Context context) {
        String accept = "application/json";
        return this.service.updatePropertiesSync(this.client.getUrl(), name, this.client.getApiVersion(), value, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ContainerRepositoryProperties updateProperties(String name, RepositoryWriteableProperties value) {
        return (ContainerRepositoryProperties)this.updatePropertiesWithResponse(name, value, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<TagAttributesBase>> getTagsSinglePageAsync(String name, String last, Integer n, String orderBy, String digest, Context context) {
        String accept = "application/json";
        return this.service.getTags(this.client.getUrl(), name, last, n, orderBy, digest, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TagList)res.getValue()).getTagAttributeBases(), ((TagList)res.getValue()).getLink(), (Object)((ContainerRegistriesGetTagsHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TagAttributesBase> getTagsAsync(String name, String last, Integer n, String orderBy, String digest, Context context) {
        return new PagedFlux(() -> this.getTagsSinglePageAsync(name, last, n, orderBy, digest, context), nextLink -> this.getTagsNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<TagAttributesBase> getTagsSinglePage(String name, String last, Integer n, String orderBy, String digest, Context context) {
        String accept = "application/json";
        ResponseBase<ContainerRegistriesGetTagsHeaders, TagList> res = this.service.getTagsSync(this.client.getUrl(), name, last, n, orderBy, digest, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TagList)res.getValue()).getTagAttributeBases(), ((TagList)res.getValue()).getLink(), (Object)((ContainerRegistriesGetTagsHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TagAttributesBase> getTags(String name, String last, Integer n, String orderBy, String digest, Context context) {
        return new PagedIterable(() -> this.getTagsSinglePage(name, last, n, orderBy, digest, context), nextLink -> this.getTagsNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ArtifactTagPropertiesInternal>> getTagPropertiesWithResponseAsync(String name, String reference) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getTagProperties(this.client.getUrl(), name, reference, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ArtifactTagPropertiesInternal>> getTagPropertiesWithResponseAsync(String name, String reference, Context context) {
        String accept = "application/json";
        return this.service.getTagProperties(this.client.getUrl(), name, reference, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ArtifactTagPropertiesInternal> getTagPropertiesAsync(String name, String reference) {
        return this.getTagPropertiesWithResponseAsync(name, reference).flatMap(res -> Mono.justOrEmpty((Object)((ArtifactTagPropertiesInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ArtifactTagPropertiesInternal> getTagPropertiesAsync(String name, String reference, Context context) {
        return this.getTagPropertiesWithResponseAsync(name, reference, context).flatMap(res -> Mono.justOrEmpty((Object)((ArtifactTagPropertiesInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ArtifactTagPropertiesInternal> getTagPropertiesWithResponse(String name, String reference, Context context) {
        String accept = "application/json";
        return this.service.getTagPropertiesSync(this.client.getUrl(), name, reference, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ArtifactTagPropertiesInternal getTagProperties(String name, String reference) {
        return (ArtifactTagPropertiesInternal)this.getTagPropertiesWithResponse(name, reference, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ArtifactTagPropertiesInternal>> updateTagAttributesWithResponseAsync(String name, String reference, TagWriteableProperties value) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateTagAttributes(this.client.getUrl(), name, reference, this.client.getApiVersion(), value, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ArtifactTagPropertiesInternal>> updateTagAttributesWithResponseAsync(String name, String reference, TagWriteableProperties value, Context context) {
        String accept = "application/json";
        return this.service.updateTagAttributes(this.client.getUrl(), name, reference, this.client.getApiVersion(), value, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ArtifactTagPropertiesInternal> updateTagAttributesAsync(String name, String reference, TagWriteableProperties value) {
        return this.updateTagAttributesWithResponseAsync(name, reference, value).flatMap(res -> Mono.justOrEmpty((Object)((ArtifactTagPropertiesInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ArtifactTagPropertiesInternal> updateTagAttributesAsync(String name, String reference, TagWriteableProperties value, Context context) {
        return this.updateTagAttributesWithResponseAsync(name, reference, value, context).flatMap(res -> Mono.justOrEmpty((Object)((ArtifactTagPropertiesInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ArtifactTagPropertiesInternal> updateTagAttributesWithResponse(String name, String reference, TagWriteableProperties value, Context context) {
        String accept = "application/json";
        return this.service.updateTagAttributesSync(this.client.getUrl(), name, reference, this.client.getApiVersion(), value, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ArtifactTagPropertiesInternal updateTagAttributes(String name, String reference, TagWriteableProperties value) {
        return (ArtifactTagPropertiesInternal)this.updateTagAttributesWithResponse(name, reference, value, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTagWithResponseAsync(String name, String reference) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteTag(this.client.getUrl(), name, reference, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTagWithResponseAsync(String name, String reference, Context context) {
        String accept = "application/json";
        return this.service.deleteTag(this.client.getUrl(), name, reference, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTagAsync(String name, String reference) {
        return this.deleteTagWithResponseAsync(name, reference).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTagAsync(String name, String reference, Context context) {
        return this.deleteTagWithResponseAsync(name, reference, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTagWithResponse(String name, String reference, Context context) {
        String accept = "application/json";
        return this.service.deleteTagSync(this.client.getUrl(), name, reference, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTag(String name, String reference) {
        this.deleteTagWithResponse(name, reference, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ManifestAttributesBase>> getManifestsSinglePageAsync(String name, String last, Integer n, String orderBy, Context context) {
        String accept = "application/json";
        return this.service.getManifests(this.client.getUrl(), name, last, n, orderBy, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AcrManifests)res.getValue()).getManifests(), ((AcrManifests)res.getValue()).getLink(), (Object)((ContainerRegistriesGetManifestsHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ManifestAttributesBase> getManifestsAsync(String name, String last, Integer n, String orderBy, Context context) {
        return new PagedFlux(() -> this.getManifestsSinglePageAsync(name, last, n, orderBy, context), nextLink -> this.getManifestsNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<ManifestAttributesBase> getManifestsSinglePage(String name, String last, Integer n, String orderBy, Context context) {
        String accept = "application/json";
        ResponseBase<ContainerRegistriesGetManifestsHeaders, AcrManifests> res = this.service.getManifestsSync(this.client.getUrl(), name, last, n, orderBy, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AcrManifests)res.getValue()).getManifests(), ((AcrManifests)res.getValue()).getLink(), (Object)((ContainerRegistriesGetManifestsHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManifestAttributesBase> getManifests(String name, String last, Integer n, String orderBy, Context context) {
        return new PagedIterable(() -> this.getManifestsSinglePage(name, last, n, orderBy, context), nextLink -> this.getManifestsNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ArtifactManifestPropertiesInternal>> getManifestPropertiesWithResponseAsync(String name, String digest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getManifestProperties(this.client.getUrl(), name, digest, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ArtifactManifestPropertiesInternal>> getManifestPropertiesWithResponseAsync(String name, String digest, Context context) {
        String accept = "application/json";
        return this.service.getManifestProperties(this.client.getUrl(), name, digest, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ArtifactManifestPropertiesInternal> getManifestPropertiesAsync(String name, String digest) {
        return this.getManifestPropertiesWithResponseAsync(name, digest).flatMap(res -> Mono.justOrEmpty((Object)((ArtifactManifestPropertiesInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ArtifactManifestPropertiesInternal> getManifestPropertiesAsync(String name, String digest, Context context) {
        return this.getManifestPropertiesWithResponseAsync(name, digest, context).flatMap(res -> Mono.justOrEmpty((Object)((ArtifactManifestPropertiesInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ArtifactManifestPropertiesInternal> getManifestPropertiesWithResponse(String name, String digest, Context context) {
        String accept = "application/json";
        return this.service.getManifestPropertiesSync(this.client.getUrl(), name, digest, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ArtifactManifestPropertiesInternal getManifestProperties(String name, String digest) {
        return (ArtifactManifestPropertiesInternal)this.getManifestPropertiesWithResponse(name, digest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ArtifactManifestPropertiesInternal>> updateManifestPropertiesWithResponseAsync(String name, String digest, ManifestWriteableProperties value) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateManifestProperties(this.client.getUrl(), name, digest, this.client.getApiVersion(), value, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ArtifactManifestPropertiesInternal>> updateManifestPropertiesWithResponseAsync(String name, String digest, ManifestWriteableProperties value, Context context) {
        String accept = "application/json";
        return this.service.updateManifestProperties(this.client.getUrl(), name, digest, this.client.getApiVersion(), value, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ArtifactManifestPropertiesInternal> updateManifestPropertiesAsync(String name, String digest, ManifestWriteableProperties value) {
        return this.updateManifestPropertiesWithResponseAsync(name, digest, value).flatMap(res -> Mono.justOrEmpty((Object)((ArtifactManifestPropertiesInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ArtifactManifestPropertiesInternal> updateManifestPropertiesAsync(String name, String digest, ManifestWriteableProperties value, Context context) {
        return this.updateManifestPropertiesWithResponseAsync(name, digest, value, context).flatMap(res -> Mono.justOrEmpty((Object)((ArtifactManifestPropertiesInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ArtifactManifestPropertiesInternal> updateManifestPropertiesWithResponse(String name, String digest, ManifestWriteableProperties value, Context context) {
        String accept = "application/json";
        return this.service.updateManifestPropertiesSync(this.client.getUrl(), name, digest, this.client.getApiVersion(), value, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ArtifactManifestPropertiesInternal updateManifestProperties(String name, String digest, ManifestWriteableProperties value) {
        return (ArtifactManifestPropertiesInternal)this.updateManifestPropertiesWithResponse(name, digest, value, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<String>> getRepositoriesNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getRepositoriesNext(nextLink, this.client.getUrl(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((Repositories)res.getValue()).getRepositories(), ((Repositories)res.getValue()).getLink(), (Object)((ContainerRegistriesGetRepositoriesNextHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<String> getRepositoriesNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        ResponseBase<ContainerRegistriesGetRepositoriesNextHeaders, Repositories> res = this.service.getRepositoriesNextSync(nextLink, this.client.getUrl(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((Repositories)res.getValue()).getRepositories(), ((Repositories)res.getValue()).getLink(), (Object)((ContainerRegistriesGetRepositoriesNextHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<TagAttributesBase>> getTagsNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getTagsNext(nextLink, this.client.getUrl(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TagList)res.getValue()).getTagAttributeBases(), ((TagList)res.getValue()).getLink(), (Object)((ContainerRegistriesGetTagsNextHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<TagAttributesBase> getTagsNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        ResponseBase<ContainerRegistriesGetTagsNextHeaders, TagList> res = this.service.getTagsNextSync(nextLink, this.client.getUrl(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TagList)res.getValue()).getTagAttributeBases(), ((TagList)res.getValue()).getLink(), (Object)((ContainerRegistriesGetTagsNextHeaders)res.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ManifestAttributesBase>> getManifestsNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getManifestsNext(nextLink, this.client.getUrl(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AcrManifests)res.getValue()).getManifests(), ((AcrManifests)res.getValue()).getLink(), (Object)((ContainerRegistriesGetManifestsNextHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<ManifestAttributesBase> getManifestsNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        ResponseBase<ContainerRegistriesGetManifestsNextHeaders, AcrManifests> res = this.service.getManifestsNextSync(nextLink, this.client.getUrl(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AcrManifests)res.getValue()).getManifests(), ((AcrManifests)res.getValue()).getLink(), (Object)((ContainerRegistriesGetManifestsNextHeaders)res.getDeserializedHeaders()));
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureContainerRegist")
    public static interface ContainerRegistriesService {
        @Get(value="/v2/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<Response<Void>> checkDockerV2Support(@HostParam(value="url") String var1, @HeaderParam(value="Accept") String var2, Context var3);

        @Get(value="/v2/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Response<Void> checkDockerV2SupportSync(@HostParam(value="url") String var1, @HeaderParam(value="Accept") String var2, Context var3);

        @Get(value="/v2/{name}/manifests/{reference}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<Response<BinaryData>> getManifest(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="reference") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/v2/{name}/manifests/{reference}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Response<BinaryData> getManifestSync(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="reference") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Put(value="/v2/{name}/manifests/{reference}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<ResponseBase<ContainerRegistriesCreateManifestHeaders, Void>> createManifest(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="reference") String var3, @HeaderParam(value="Content-Type") String var4, @BodyParam(value="application/vnd.docker.distribution.manifest.v2+json") Flux<ByteBuffer> var5, @HeaderParam(value="Content-Length") long var6, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/v2/{name}/manifests/{reference}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<ResponseBase<ContainerRegistriesCreateManifestHeaders, Void>> createManifest(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="reference") String var3, @HeaderParam(value="Content-Type") String var4, @BodyParam(value="application/vnd.docker.distribution.manifest.v2+json") BinaryData var5, @HeaderParam(value="Content-Length") long var6, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/v2/{name}/manifests/{reference}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public ResponseBase<ContainerRegistriesCreateManifestHeaders, Void> createManifestSync(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="reference") String var3, @HeaderParam(value="Content-Type") String var4, @BodyParam(value="application/vnd.docker.distribution.manifest.v2+json") BinaryData var5, @HeaderParam(value="Content-Length") long var6, @HeaderParam(value="Accept") String var8, Context var9);

        @Delete(value="/v2/{name}/manifests/{reference}")
        @ExpectedResponses(value={202, 404})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<Response<Void>> deleteManifest(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="reference") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/v2/{name}/manifests/{reference}")
        @ExpectedResponses(value={202, 404})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Response<Void> deleteManifestSync(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="reference") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/acr/v1/_catalog")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<ResponseBase<ContainerRegistriesGetRepositoriesHeaders, Repositories>> getRepositories(@HostParam(value="url") String var1, @QueryParam(value="last") String var2, @QueryParam(value="n") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/acr/v1/_catalog")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public ResponseBase<ContainerRegistriesGetRepositoriesHeaders, Repositories> getRepositoriesSync(@HostParam(value="url") String var1, @QueryParam(value="last") String var2, @QueryParam(value="n") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/acr/v1/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<Response<ContainerRepositoryProperties>> getProperties(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/acr/v1/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Response<ContainerRepositoryProperties> getPropertiesSync(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/acr/v1/{name}")
        @ExpectedResponses(value={202, 404})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<Response<DeleteRepositoryResult>> deleteRepository(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/acr/v1/{name}")
        @ExpectedResponses(value={202, 404})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Response<DeleteRepositoryResult> deleteRepositorySync(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Patch(value="/acr/v1/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<Response<ContainerRepositoryProperties>> updateProperties(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") RepositoryWriteableProperties var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Patch(value="/acr/v1/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Response<ContainerRepositoryProperties> updatePropertiesSync(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") RepositoryWriteableProperties var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/acr/v1/{name}/_tags")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<ResponseBase<ContainerRegistriesGetTagsHeaders, TagList>> getTags(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @QueryParam(value="last") String var3, @QueryParam(value="n") Integer var4, @QueryParam(value="orderby") String var5, @QueryParam(value="digest") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/acr/v1/{name}/_tags")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public ResponseBase<ContainerRegistriesGetTagsHeaders, TagList> getTagsSync(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @QueryParam(value="last") String var3, @QueryParam(value="n") Integer var4, @QueryParam(value="orderby") String var5, @QueryParam(value="digest") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/acr/v1/{name}/_tags/{reference}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<Response<ArtifactTagPropertiesInternal>> getTagProperties(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="reference") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/acr/v1/{name}/_tags/{reference}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Response<ArtifactTagPropertiesInternal> getTagPropertiesSync(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="reference") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Patch(value="/acr/v1/{name}/_tags/{reference}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<Response<ArtifactTagPropertiesInternal>> updateTagAttributes(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="reference") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") TagWriteableProperties var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Patch(value="/acr/v1/{name}/_tags/{reference}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Response<ArtifactTagPropertiesInternal> updateTagAttributesSync(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="reference") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") TagWriteableProperties var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Delete(value="/acr/v1/{name}/_tags/{reference}")
        @ExpectedResponses(value={202, 404})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<Response<Void>> deleteTag(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="reference") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/acr/v1/{name}/_tags/{reference}")
        @ExpectedResponses(value={202, 404})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Response<Void> deleteTagSync(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="reference") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/acr/v1/{name}/_manifests")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<ResponseBase<ContainerRegistriesGetManifestsHeaders, AcrManifests>> getManifests(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @QueryParam(value="last") String var3, @QueryParam(value="n") Integer var4, @QueryParam(value="orderby") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/acr/v1/{name}/_manifests")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public ResponseBase<ContainerRegistriesGetManifestsHeaders, AcrManifests> getManifestsSync(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @QueryParam(value="last") String var3, @QueryParam(value="n") Integer var4, @QueryParam(value="orderby") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/acr/v1/{name}/_manifests/{digest}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<Response<ArtifactManifestPropertiesInternal>> getManifestProperties(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="digest") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/acr/v1/{name}/_manifests/{digest}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Response<ArtifactManifestPropertiesInternal> getManifestPropertiesSync(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="digest") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Patch(value="/acr/v1/{name}/_manifests/{digest}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<Response<ArtifactManifestPropertiesInternal>> updateManifestProperties(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="digest") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") ManifestWriteableProperties var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Patch(value="/acr/v1/{name}/_manifests/{digest}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Response<ArtifactManifestPropertiesInternal> updateManifestPropertiesSync(@HostParam(value="url") String var1, @PathParam(value="name") String var2, @PathParam(value="digest") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") ManifestWriteableProperties var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<ResponseBase<ContainerRegistriesGetRepositoriesNextHeaders, Repositories>> getRepositoriesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public ResponseBase<ContainerRegistriesGetRepositoriesNextHeaders, Repositories> getRepositoriesNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<ResponseBase<ContainerRegistriesGetTagsNextHeaders, TagList>> getTagsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public ResponseBase<ContainerRegistriesGetTagsNextHeaders, TagList> getTagsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public Mono<ResponseBase<ContainerRegistriesGetManifestsNextHeaders, AcrManifests>> getManifestsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AcrErrorsException.class)
        public ResponseBase<ContainerRegistriesGetManifestsNextHeaders, AcrManifests> getManifestsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

