// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.containers.containerregistry.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/** JSON web key parameter. */
@Fluent
public final class JWKHeader implements JsonSerializable<JWKHeader> {
    /*
     * crv value
     */
    private String crv;

    /*
     * kid value
     */
    private String kid;

    /*
     * kty value
     */
    private String kty;

    /*
     * x value
     */
    private String x;

    /*
     * y value
     */
    private String y;

    /** Creates an instance of JWKHeader class. */
    public JWKHeader() {
    }

    /**
     * Get the crv property: crv value.
     *
     * @return the crv value.
     */
    public String getCrv() {
        return this.crv;
    }

    /**
     * Set the crv property: crv value.
     *
     * @param crv the crv value to set.
     * @return the JWKHeader object itself.
     */
    public JWKHeader setCrv(String crv) {
        this.crv = crv;
        return this;
    }

    /**
     * Get the kid property: kid value.
     *
     * @return the kid value.
     */
    public String getKid() {
        return this.kid;
    }

    /**
     * Set the kid property: kid value.
     *
     * @param kid the kid value to set.
     * @return the JWKHeader object itself.
     */
    public JWKHeader setKid(String kid) {
        this.kid = kid;
        return this;
    }

    /**
     * Get the kty property: kty value.
     *
     * @return the kty value.
     */
    public String getKty() {
        return this.kty;
    }

    /**
     * Set the kty property: kty value.
     *
     * @param kty the kty value to set.
     * @return the JWKHeader object itself.
     */
    public JWKHeader setKty(String kty) {
        this.kty = kty;
        return this;
    }

    /**
     * Get the x property: x value.
     *
     * @return the x value.
     */
    public String getX() {
        return this.x;
    }

    /**
     * Set the x property: x value.
     *
     * @param x the x value to set.
     * @return the JWKHeader object itself.
     */
    public JWKHeader setX(String x) {
        this.x = x;
        return this;
    }

    /**
     * Get the y property: y value.
     *
     * @return the y value.
     */
    public String getY() {
        return this.y;
    }

    /**
     * Set the y property: y value.
     *
     * @param y the y value to set.
     * @return the JWKHeader object itself.
     */
    public JWKHeader setY(String y) {
        this.y = y;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("crv", this.crv);
        jsonWriter.writeStringField("kid", this.kid);
        jsonWriter.writeStringField("kty", this.kty);
        jsonWriter.writeStringField("x", this.x);
        jsonWriter.writeStringField("y", this.y);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of JWKHeader from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of JWKHeader if the JsonReader was pointing to an instance of it, or null if it was pointing
     *     to JSON null.
     * @throws IOException If an error occurs while reading the JWKHeader.
     */
    public static JWKHeader fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JWKHeader deserializedJWKHeader = new JWKHeader();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("crv".equals(fieldName)) {
                    deserializedJWKHeader.crv = reader.getString();
                } else if ("kid".equals(fieldName)) {
                    deserializedJWKHeader.kid = reader.getString();
                } else if ("kty".equals(fieldName)) {
                    deserializedJWKHeader.kty = reader.getString();
                } else if ("x".equals(fieldName)) {
                    deserializedJWKHeader.x = reader.getString();
                } else if ("y".equals(fieldName)) {
                    deserializedJWKHeader.y = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedJWKHeader;
        });
    }
}
