// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.containers.containerregistry.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/** Result of the request to list tags of the image. */
@Fluent
public final class RepositoryTags implements JsonSerializable<RepositoryTags> {
    /*
     * Name of the image
     */
    private String name;

    /*
     * List of tags
     */
    private List<String> tags;

    /** Creates an instance of RepositoryTags class. */
    public RepositoryTags() {
    }

    /**
     * Get the name property: Name of the image.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: Name of the image.
     *
     * @param name the name value to set.
     * @return the RepositoryTags object itself.
     */
    public RepositoryTags setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the tags property: List of tags.
     *
     * @return the tags value.
     */
    public List<String> getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: List of tags.
     *
     * @param tags the tags value to set.
     * @return the RepositoryTags object itself.
     */
    public RepositoryTags setTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RepositoryTags from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RepositoryTags if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IOException If an error occurs while reading the RepositoryTags.
     */
    public static RepositoryTags fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RepositoryTags deserializedRepositoryTags = new RepositoryTags();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedRepositoryTags.name = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    List<String> tags = reader.readArray(reader1 -> reader1.getString());
                    deserializedRepositoryTags.tags = tags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRepositoryTags;
        });
    }
}
