// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.containers.containerregistry.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/** Returns the requested Docker multi-arch-manifest file. */
@Fluent
public final class ManifestList extends Manifest {
    /*
     * Media type for this Manifest
     */
    private String mediaType;

    /*
     * List of V2 image layer information
     */
    private List<ManifestListAttributes> manifests;

    /** Creates an instance of ManifestList class. */
    public ManifestList() {
    }

    /**
     * Get the mediaType property: Media type for this Manifest.
     *
     * @return the mediaType value.
     */
    public String getMediaType() {
        return this.mediaType;
    }

    /**
     * Set the mediaType property: Media type for this Manifest.
     *
     * @param mediaType the mediaType value to set.
     * @return the ManifestList object itself.
     */
    public ManifestList setMediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    /**
     * Get the manifests property: List of V2 image layer information.
     *
     * @return the manifests value.
     */
    public List<ManifestListAttributes> getManifests() {
        return this.manifests;
    }

    /**
     * Set the manifests property: List of V2 image layer information.
     *
     * @param manifests the manifests value to set.
     * @return the ManifestList object itself.
     */
    public ManifestList setManifests(List<ManifestListAttributes> manifests) {
        this.manifests = manifests;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ManifestList setSchemaVersion(Integer schemaVersion) {
        super.setSchemaVersion(schemaVersion);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("schemaVersion", getSchemaVersion());
        jsonWriter.writeStringField("mediaType", this.mediaType);
        jsonWriter.writeArrayField("manifests", this.manifests, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManifestList from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManifestList if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManifestList.
     */
    public static ManifestList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManifestList deserializedManifestList = new ManifestList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("schemaVersion".equals(fieldName)) {
                    deserializedManifestList.setSchemaVersion(reader.getNullable(JsonReader::getInt));
                } else if ("mediaType".equals(fieldName)) {
                    deserializedManifestList.mediaType = reader.getString();
                } else if ("manifests".equals(fieldName)) {
                    List<ManifestListAttributes> manifests
                        = reader.readArray(reader1 -> ManifestListAttributes.fromJson(reader1));
                    deserializedManifestList.manifests = manifests;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManifestList;
        });
    }
}
