/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry;

import com.azure.containers.containerregistry.ContainerRegistryContentClientBuilder;
import com.azure.containers.containerregistry.implementation.AzureContainerRegistryImpl;
import com.azure.containers.containerregistry.implementation.ConstructorAccessors;
import com.azure.containers.containerregistry.implementation.ContainerRegistriesImpl;
import com.azure.containers.containerregistry.implementation.ContainerRegistryBlobsImpl;
import com.azure.containers.containerregistry.implementation.UtilsImpl;
import com.azure.containers.containerregistry.implementation.models.AcrErrorsException;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistriesCreateManifestHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsGetChunkHeaders;
import com.azure.containers.containerregistry.models.GetManifestResult;
import com.azure.containers.containerregistry.models.ManifestMediaType;
import com.azure.containers.containerregistry.models.OciImageManifest;
import com.azure.containers.containerregistry.models.SetManifestOptions;
import com.azure.containers.containerregistry.models.SetManifestResult;
import com.azure.containers.containerregistry.models.UploadRegistryBlobResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRange;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.Tracer;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ContainerRegistryContentClientBuilder.class, isAsync=true)
public final class ContainerRegistryContentAsyncClient {
    private final ContainerRegistryBlobsImpl blobsImpl;
    private final ContainerRegistriesImpl registriesImpl;
    private final String endpoint;
    private final String repositoryName;
    private final Tracer tracer;
    private static final ClientLogger LOGGER = new ClientLogger(ContainerRegistryContentAsyncClient.class);

    ContainerRegistryContentAsyncClient(String repositoryName, HttpPipeline httpPipeline, String endpoint, String version, Tracer tracer) {
        this.repositoryName = repositoryName;
        this.endpoint = endpoint;
        AzureContainerRegistryImpl registryImplClient = new AzureContainerRegistryImpl(httpPipeline, endpoint, version);
        this.blobsImpl = registryImplClient.getContainerRegistryBlobs();
        this.registriesImpl = registryImplClient.getContainerRegistries();
        this.tracer = tracer;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SetManifestResult> setManifest(OciImageManifest manifest, String tag) {
        if (manifest == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'manifest' can't be null."));
        }
        return FluxUtil.withContext(context -> this.setManifestWithResponse(BinaryData.fromObject((Object)manifest), tag, ManifestMediaType.OCI_IMAGE_MANIFEST, (Context)context)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SetManifestResult>> setManifestWithResponse(SetManifestOptions options) {
        if (options == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'options' can't be null."));
        }
        return FluxUtil.withContext(context -> this.setManifestWithResponse(options.getManifest(), options.getTag(), options.getManifestMediaType(), (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UploadRegistryBlobResult> uploadBlob(BinaryData content) {
        if (content == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'content' can't be null."));
        }
        return FluxUtil.withContext(context -> this.runWithTracing("ContainerRegistryContentAsyncClient.uploadBlob", span -> this.uploadBlob((Flux<ByteBuffer>)content.toFluxByteBuffer(), (Context)span), (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GetManifestResult> getManifest(String tagOrDigest) {
        return FluxUtil.withContext(context -> this.getManifestWithResponse(tagOrDigest, (Context)context)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<GetManifestResult>> getManifestWithResponse(String tagOrDigest) {
        return FluxUtil.withContext(context -> this.getManifestWithResponse(tagOrDigest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> downloadStream(String digest) {
        return FluxUtil.withContext(context -> this.runWithTracing("ContainerRegistryContentAsyncClient.downloadBlob", span -> this.downloadBlobInternal(digest, (Context)span), (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteBlob(String digest) {
        return this.deleteBlobWithResponse(digest).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteBlobWithResponse(String digest) {
        return FluxUtil.withContext(context -> this.deleteBlobWithResponse(digest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteManifest(String digest) {
        return this.deleteManifestWithResponse(digest).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteManifestWithResponse(String digest) {
        return FluxUtil.withContext(context -> this.deleteManifestWithResponse(digest, (Context)context));
    }

    private Mono<Response<SetManifestResult>> setManifestWithResponse(BinaryData manifestData, String tagOrDigest, ManifestMediaType manifestMediaType, Context context) {
        ByteBuffer data = manifestData.toByteBuffer();
        if (tagOrDigest == null) {
            tagOrDigest = UtilsImpl.computeDigest(data);
        }
        return this.registriesImpl.createManifestWithResponseAsync(this.repositoryName, tagOrDigest, BinaryData.fromByteBuffer((ByteBuffer)data), (long)data.remaining(), manifestMediaType.toString(), context).map(response -> new ResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)ConstructorAccessors.createSetManifestResult(((ContainerRegistriesCreateManifestHeaders)response.getDeserializedHeaders()).getDockerContentDigest()), (Object)((ContainerRegistriesCreateManifestHeaders)response.getDeserializedHeaders()))).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
    }

    private Mono<Response<GetManifestResult>> getManifestWithResponse(String tagOrDigest, Context context) {
        if (tagOrDigest == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'tagOrDigest' can't be null."));
        }
        return this.registriesImpl.getManifestWithResponseAsync(this.repositoryName, tagOrDigest, UtilsImpl.SUPPORTED_MANIFEST_TYPES, context).map(response -> UtilsImpl.toGetManifestResponse(tagOrDigest, (Response<BinaryData>)response)).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
    }

    private Mono<Response<Void>> deleteManifestWithResponse(String digest, Context context) {
        return this.registriesImpl.deleteManifestWithResponseAsync(this.repositoryName, digest, context).map(UtilsImpl::deleteResponseToSuccess).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
    }

    private static Flux<ByteBuffer> chunkSource(Flux<ByteBuffer> data, MessageDigest sha256, AtomicLong length) {
        return data.flatMapSequential(buffer -> {
            length.addAndGet(buffer.remaining());
            if (buffer.remaining() <= 0x400000) {
                sha256.update(buffer.asReadOnlyBuffer());
                return Flux.just((Object)buffer);
            }
            int numSplits = (int)Math.ceil((double)buffer.remaining() / 4194304.0);
            return Flux.range((int)0, (int)numSplits).map(i -> {
                ByteBuffer duplicate = buffer.duplicate().asReadOnlyBuffer();
                duplicate.position(i * 0x400000);
                duplicate.limit(Math.min(duplicate.limit(), (i + 1) * 0x400000));
                sha256.update(duplicate.asReadOnlyBuffer());
                return duplicate;
            });
        }, 1, 1);
    }

    private Mono<BinaryData> downloadBlobInternal(String digest, Context context) {
        if (digest == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'digest' can't be null."));
        }
        Flux content = this.blobsImpl.getChunkWithResponseAsync(this.repositoryName, digest, new HttpRange(0L, Long.valueOf(0x400000L)).toString(), context).flatMapMany(firstResponse -> this.getAllChunks((ResponseBase<ContainerRegistryBlobsGetChunkHeaders, BinaryData>)firstResponse, digest, context)).flatMapSequential(chunk -> ((BinaryData)chunk.getValue()).toFluxByteBuffer(), 1);
        MessageDigest sha256 = UtilsImpl.createSha256();
        content = content.doOnNext(buffer -> sha256.update(buffer.asReadOnlyBuffer())).doOnComplete(() -> UtilsImpl.validateDigest(sha256, digest)).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
        return BinaryData.fromFlux((Flux)content, null, (boolean)false);
    }

    private Flux<ResponseBase<ContainerRegistryBlobsGetChunkHeaders, BinaryData>> getAllChunks(ResponseBase<ContainerRegistryBlobsGetChunkHeaders, BinaryData> firstResponse, String digest, Context context) {
        long contentLength;
        long blobSize = UtilsImpl.getBlobSize(firstResponse.getHeaders());
        ArrayList<Object> others = new ArrayList<Object>();
        others.add(Mono.just(firstResponse));
        for (long p = contentLength = UtilsImpl.getContentLength(firstResponse.getHeaders().get(HttpHeaderName.CONTENT_LENGTH)); p < blobSize; p += 0x400000L) {
            HttpRange range = new HttpRange(p, Long.valueOf(0x400000L));
            others.add(this.blobsImpl.getChunkWithResponseAsync(this.repositoryName, digest, range.toString(), context));
        }
        return Flux.concat(others);
    }

    private Mono<Response<Void>> deleteBlobWithResponse(String digest, Context context) {
        if (digest == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'digest' can't be null."));
        }
        return this.blobsImpl.deleteBlobWithResponseAsync(this.repositoryName, digest, context).map(UtilsImpl::deleteResponseToSuccess).onErrorResume(ex -> ex instanceof HttpResponseException && ((HttpResponseException)((Object)ex)).getResponse().getStatusCode() == 404, ex -> {
            HttpResponse response = ((HttpResponseException)((Object)ex)).getResponse();
            return Mono.just((Object)new SimpleResponse(response.getRequest(), 202, response.getHeaders(), null));
        }).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
    }

    private Mono<String> upload(Flux<ByteBuffer> data, String location, Context context) {
        AtomicReference<String> locationRef = new AtomicReference<String>(location);
        return data.flatMapSequential(chunk -> {
            BinaryData chunkData = BinaryData.fromByteBuffer((ByteBuffer)chunk);
            return this.blobsImpl.uploadChunkWithResponseAsync((String)locationRef.get(), chunkData, (long)chunkData.getLength(), context).map(response -> UtilsImpl.getLocation(response));
        }, 1, 1).doOnNext(locationRef::set).last();
    }

    private Mono<UploadRegistryBlobResult> uploadBlob(Flux<ByteBuffer> content, Context context) {
        if (content == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'content' can't be null."));
        }
        AtomicLong streamLength = new AtomicLong(0L);
        MessageDigest sha256 = UtilsImpl.createSha256();
        Flux<ByteBuffer> chunks = ContainerRegistryContentAsyncClient.chunkSource(content, sha256, streamLength);
        return this.blobsImpl.startUploadWithResponseAsync(this.repositoryName, context).flatMap(response -> this.upload(chunks, UtilsImpl.getLocation(response), context)).flatMap(location -> this.blobsImpl.completeUploadWithResponseAsync("sha256:" + CoreUtils.bytesToHexString((byte[])sha256.digest()), (String)location, (BinaryData)null, (Long)0L, context)).map(response -> ConstructorAccessors.createUploadRegistryBlobResult(response.getHeaders().getValue(UtilsImpl.DOCKER_DIGEST_HEADER_NAME), streamLength.get())).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
    }

    private <T> Mono<T> runWithTracing(String spanName, Function<Context, Mono<T>> operation, Context context) {
        Context span = this.tracer.start(spanName, context);
        return operation.apply(span).doOnEach(signal -> {
            if (signal.isOnComplete() || signal.isOnError()) {
                this.tracer.end(null, signal.getThrowable(), span);
            }
        });
    }
}

