/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation;

import com.azure.containers.containerregistry.ContainerRegistryServiceVersion;
import com.azure.containers.containerregistry.implementation.ArtifactManifestPropertiesHelper;
import com.azure.containers.containerregistry.implementation.ArtifactTagPropertiesHelper;
import com.azure.containers.containerregistry.implementation.AzureContainerRegistryImpl;
import com.azure.containers.containerregistry.implementation.ConstructorAccessors;
import com.azure.containers.containerregistry.implementation.authentication.ContainerRegistryCredentialsPolicy;
import com.azure.containers.containerregistry.implementation.authentication.ContainerRegistryTokenService;
import com.azure.containers.containerregistry.implementation.models.AcrErrorInfo;
import com.azure.containers.containerregistry.implementation.models.AcrErrorsException;
import com.azure.containers.containerregistry.implementation.models.ArtifactManifestPropertiesInternal;
import com.azure.containers.containerregistry.implementation.models.ArtifactTagPropertiesInternal;
import com.azure.containers.containerregistry.implementation.models.ManifestAttributesBase;
import com.azure.containers.containerregistry.implementation.models.TagAttributesBase;
import com.azure.containers.containerregistry.models.ArtifactManifestProperties;
import com.azure.containers.containerregistry.models.ArtifactTagProperties;
import com.azure.containers.containerregistry.models.ContainerRegistryAudience;
import com.azure.containers.containerregistry.models.GetManifestResult;
import com.azure.containers.containerregistry.models.ManifestMediaType;
import com.azure.core.credential.TokenCredential;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceExistsException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.exception.ServiceResponseException;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RedirectPolicy;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.models.ResponseError;
import com.azure.core.util.BinaryData;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.TracingOptions;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.Tracer;
import com.azure.core.util.tracing.TracerProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public final class UtilsImpl {
    private static final ClientLogger LOGGER = new ClientLogger(UtilsImpl.class);
    private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-containers-containerregistry.properties");
    private static final String CLIENT_NAME = PROPERTIES.getOrDefault("name", "UnknownName");
    private static final String CLIENT_VERSION = PROPERTIES.getOrDefault("version", "UnknownVersion");
    private static final ContainerRegistryAudience ACR_ACCESS_TOKEN_AUDIENCE = ContainerRegistryAudience.fromString("https://containerregistry.azure.net");
    private static final int HTTP_STATUS_CODE_NOT_FOUND = 404;
    private static final int HTTP_STATUS_CODE_ACCEPTED = 202;
    public static final HttpHeaderName DOCKER_DIGEST_HEADER_NAME = HttpHeaderName.fromString((String)"docker-content-digest");
    public static final String SUPPORTED_MANIFEST_TYPES = "*/*," + (Object)((Object)ManifestMediaType.OCI_IMAGE_MANIFEST) + "," + (Object)((Object)ManifestMediaType.DOCKER_MANIFEST) + ",application/vnd.oci.image.index.v1+json,application/vnd.docker.distribution.manifest.list.v2+json,application/vnd.cncf.oras.artifact.manifest.v1+json";
    private static final String CONTAINER_REGISTRY_TRACING_NAMESPACE_VALUE = "Microsoft.ContainerRegistry";
    public static final int CHUNK_SIZE = 0x400000;
    public static final int MAX_MANIFEST_SIZE = 0x400000;
    public static final String UPLOAD_BLOB_SPAN_NAME = "ContainerRegistryContentAsyncClient.uploadBlob";
    public static final String DOWNLOAD_BLOB_SPAN_NAME = "ContainerRegistryContentAsyncClient.downloadBlob";

    private UtilsImpl() {
    }

    public static HttpPipeline buildClientPipeline(ClientOptions clientOptions, HttpLogOptions logOptions, Configuration configuration, RetryPolicy retryPolicy, RetryOptions retryOptions, TokenCredential credential, ContainerRegistryAudience audience, List<HttpPipelinePolicy> perCallPolicies, List<HttpPipelinePolicy> perRetryPolicies, HttpClient httpClient, String endpoint, ContainerRegistryServiceVersion serviceVersion, Tracer tracer) {
        if (credential == null) {
            LOGGER.verbose("Credentials are null, enabling anonymous access");
        }
        if (audience == null) {
            LOGGER.info("Audience is not specified, defaulting to ACR access token scope.");
            audience = ACR_ACCESS_TOKEN_AUDIENCE;
        }
        if (serviceVersion == null) {
            serviceVersion = ContainerRegistryServiceVersion.getLatest();
        }
        HttpPipeline credentialsPipeline = UtilsImpl.buildPipeline(clientOptions, logOptions, configuration, retryPolicy, retryOptions, null, null, perCallPolicies, perRetryPolicies, httpClient, tracer);
        return UtilsImpl.buildPipeline(clientOptions, logOptions, configuration, retryPolicy, retryOptions, UtilsImpl.buildCredentialsPolicy(credentialsPipeline, credential, audience, endpoint, serviceVersion), new RedirectPolicy(), perCallPolicies, perRetryPolicies, httpClient, tracer);
    }

    private static ContainerRegistryCredentialsPolicy buildCredentialsPolicy(HttpPipeline credentialPipeline, TokenCredential credential, ContainerRegistryAudience audience, String endpoint, ContainerRegistryServiceVersion serviceVersion) {
        AzureContainerRegistryImpl acrClient = new AzureContainerRegistryImpl(credentialPipeline, endpoint, serviceVersion.getVersion());
        ContainerRegistryTokenService tokenService = new ContainerRegistryTokenService(credential, audience, acrClient);
        return new ContainerRegistryCredentialsPolicy(tokenService, (Object)((Object)audience) + "/.default");
    }

    private static HttpPipeline buildPipeline(ClientOptions clientOptions, HttpLogOptions logOptions, Configuration configuration, RetryPolicy retryPolicy, RetryOptions retryOptions, ContainerRegistryCredentialsPolicy credentialPolicy, RedirectPolicy redirectPolicy, List<HttpPipelinePolicy> perCallPolicies, List<HttpPipelinePolicy> perRetryPolicies, HttpClient httpClient, Tracer tracer) {
        ArrayList<Object> policies = new ArrayList<Object>();
        policies.add(new UserAgentPolicy(CoreUtils.getApplicationId((ClientOptions)clientOptions, (HttpLogOptions)logOptions), CLIENT_NAME, CLIENT_VERSION, configuration));
        policies.add(new RequestIdPolicy());
        policies.addAll(perCallPolicies);
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)retryPolicy, (RetryOptions)retryOptions));
        policies.add(new CookiePolicy());
        policies.add(new AddDatePolicy());
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        if (credentialPolicy != null) {
            policies.add((Object)credentialPolicy);
        }
        if (redirectPolicy != null) {
            policies.add(redirectPolicy);
        }
        policies.addAll(perRetryPolicies);
        policies.add(new HttpLoggingPolicy(logOptions));
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(httpClient).clientOptions(clientOptions).tracer(tracer).build();
    }

    public static Tracer createTracer(ClientOptions clientOptions) {
        TracingOptions tracingOptions = clientOptions == null ? null : clientOptions.getTracingOptions();
        return TracerProvider.getDefaultProvider().createTracer(CLIENT_NAME, CLIENT_VERSION, CONTAINER_REGISTRY_TRACING_NAMESPACE_VALUE, tracingOptions);
    }

    public static String computeDigest(ByteBuffer buffer) {
        MessageDigest md = UtilsImpl.createSha256();
        md.update(buffer.asReadOnlyBuffer());
        return "sha256:" + CoreUtils.bytesToHexString((byte[])md.digest());
    }

    public static MessageDigest createSha256() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    public static void validateDigest(MessageDigest messageDigest, String requestedDigest) {
        String sha256 = CoreUtils.bytesToHexString((byte[])messageDigest.digest());
        if (UtilsImpl.isDigest(requestedDigest) && !requestedDigest.endsWith(sha256)) {
            throw LOGGER.atError().addKeyValue("requestedDigest", requestedDigest).addKeyValue("actualDigest", () -> "sha256:" + sha256).log((RuntimeException)new ServiceResponseException("The digest in the response does not match the expected digest."));
        }
    }

    public static Response<GetManifestResult> toGetManifestResponse(String tagOrDigest, Response<BinaryData> rawResponse) {
        UtilsImpl.checkManifestSize(rawResponse.getHeaders());
        String digest = rawResponse.getHeaders().getValue(DOCKER_DIGEST_HEADER_NAME);
        String responseSha256 = UtilsImpl.computeDigest(((BinaryData)rawResponse.getValue()).toByteBuffer());
        if (!Objects.equals(responseSha256, digest) || UtilsImpl.isDigest(tagOrDigest) && !Objects.equals(responseSha256, tagOrDigest)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new ServiceResponseException("The digest in the response does not match the expected digest."));
        }
        String contentType = rawResponse.getHeaders().getValue(HttpHeaderName.CONTENT_TYPE);
        ManifestMediaType responseMediaType = contentType != null ? ManifestMediaType.fromString(contentType) : null;
        return new SimpleResponse(rawResponse.getRequest(), rawResponse.getStatusCode(), rawResponse.getHeaders(), (Object)ConstructorAccessors.createGetManifestResult(digest, responseMediaType, (BinaryData)rawResponse.getValue()));
    }

    private static long checkManifestSize(HttpHeaders headers) {
        String contentLengthString = headers.getValue(HttpHeaderName.CONTENT_LENGTH);
        if (CoreUtils.isNullOrEmpty((CharSequence)contentLengthString)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new ServiceResponseException("Response does not include `Content-Length` header"));
        }
        try {
            long contentLength = Long.parseLong(contentLengthString);
            if (contentLength > 0x400000L) {
                throw LOGGER.atError().addKeyValue("contentLength", contentLengthString).log((RuntimeException)new ServiceResponseException("Manifest size is bigger than 4MB"));
            }
            return contentLength;
        }
        catch (NullPointerException | NumberFormatException e) {
            throw LOGGER.atError().addKeyValue("contentLength", contentLengthString).log((RuntimeException)new ServiceResponseException("Could not parse `Content-Length` header"));
        }
    }

    public static <T> Response<Void> deleteResponseToSuccess(Response<T> responseT) {
        if (responseT.getStatusCode() != 404) {
            return UtilsImpl.getAcceptedDeleteResponse(responseT, responseT.getStatusCode());
        }
        return UtilsImpl.getAcceptedDeleteResponse(responseT, 202);
    }

    private static <T> Response<Void> getAcceptedDeleteResponse(Response<T> responseT, int statusCode) {
        return new SimpleResponse(responseT.getRequest(), statusCode, responseT.getHeaders(), null);
    }

    public static HttpResponseException mapAcrErrorsException(AcrErrorsException acrException) {
        HttpResponse errorHttpResponse = acrException.getResponse();
        if (acrException.getValue() != null && !CoreUtils.isNullOrEmpty(acrException.getValue().getErrors())) {
            AcrErrorInfo first = acrException.getValue().getErrors().get(0);
            ResponseError error = new ResponseError(first.getCode(), first.getMessage());
            switch (errorHttpResponse.getStatusCode()) {
                case 401: {
                    throw new ClientAuthenticationException(acrException.getMessage(), acrException.getResponse(), (Object)error);
                }
                case 404: {
                    return new ResourceNotFoundException(acrException.getMessage(), acrException.getResponse(), (Object)error);
                }
                case 409: {
                    return new ResourceExistsException(acrException.getMessage(), acrException.getResponse(), (Object)error);
                }
                case 412: {
                    return new ResourceModifiedException(acrException.getMessage(), acrException.getResponse(), (Object)error);
                }
            }
            return new HttpResponseException(acrException.getMessage(), acrException.getResponse(), (Object)error);
        }
        return acrException;
    }

    public static <T> PagedResponse<T> getPagedResponseWithContinuationToken(PagedResponse<T> listResponse) {
        return UtilsImpl.getPagedResponseWithContinuationToken(listResponse, values -> values);
    }

    public static <T, R> PagedResponse<T> getPagedResponseWithContinuationToken(PagedResponse<R> listResponse, Function<List<R>, List<T>> mapperFunction) {
        Objects.requireNonNull(mapperFunction);
        String continuationLink = UtilsImpl.getContinuationLink(listResponse.getHeaders());
        List<T> values = mapperFunction.apply(listResponse.getValue());
        return new PagedResponseBase(listResponse.getRequest(), listResponse.getStatusCode(), listResponse.getHeaders(), values, continuationLink, null);
    }

    private static String getContinuationLink(HttpHeaders headers) {
        String continuationLinkHeader = headers.getValue(HttpHeaderName.LINK);
        if (!CoreUtils.isNullOrEmpty((CharSequence)continuationLinkHeader) && continuationLinkHeader.charAt(0) == '<') {
            int endIndex = continuationLinkHeader.indexOf(">;");
            if (endIndex < 2) {
                LOGGER.warning("unexpected 'Link' header value - '{}'", new Object[]{continuationLinkHeader});
            }
            return continuationLinkHeader.substring(1, endIndex);
        }
        return null;
    }

    public static List<ArtifactManifestProperties> mapManifestsProperties(List<ManifestAttributesBase> baseArtifacts, String repositoryName, String registryLoginServer) {
        if (baseArtifacts == null) {
            return null;
        }
        ArrayList<ArtifactManifestProperties> artifactManifestProperties = new ArrayList<ArtifactManifestProperties>(baseArtifacts.size());
        for (ManifestAttributesBase base : baseArtifacts) {
            ArtifactManifestPropertiesInternal internal = new ArtifactManifestPropertiesInternal().setRegistryLoginServer(registryLoginServer).setRepositoryName(repositoryName).setDigest(base.getDigest()).setSizeInBytes(base.getSizeInBytes()).setCreatedOn(base.getCreatedOn()).setLastUpdatedOn(base.getLastUpdatedOn()).setArchitecture(base.getArchitecture()).setOperatingSystem(base.getOperatingSystem()).setRelatedArtifacts(base.getRelatedArtifacts()).setTags(base.getTags()).setDeleteEnabled(base.isDeleteEnabled()).setWriteEnabled(base.isWriteEnabled()).setListEnabled(base.isListEnabled()).setReadEnabled(base.isReadEnabled());
            artifactManifestProperties.add(ArtifactManifestPropertiesHelper.create(internal));
        }
        return artifactManifestProperties;
    }

    public static List<ArtifactTagProperties> getTagProperties(List<TagAttributesBase> baseValues, String repositoryName) {
        Objects.requireNonNull(baseValues);
        ArrayList<ArtifactTagProperties> artifactTagProperties = new ArrayList<ArtifactTagProperties>(baseValues.size());
        for (TagAttributesBase base : baseValues) {
            ArtifactTagPropertiesInternal internal = new ArtifactTagPropertiesInternal().setRepositoryName(repositoryName).setName(base.getName()).setDigest(base.getDigest()).setCreatedOn(base.getCreatedOn()).setLastUpdatedOn(base.getLastUpdatedOn()).setDeleteEnabled(base.isDeleteEnabled()).setWriteEnabled(base.isWriteEnabled()).setListEnabled(base.isListEnabled()).setReadEnabled(base.isReadEnabled());
            artifactTagProperties.add(ArtifactTagPropertiesHelper.create(internal));
        }
        return artifactTagProperties;
    }

    public static void validateResponseHeaderDigest(String requestedDigest, HttpHeaders headers) {
        String responseHeaderDigest = headers.getValue(DOCKER_DIGEST_HEADER_NAME);
        if (!requestedDigest.equals(responseHeaderDigest)) {
            throw LOGGER.atError().addKeyValue("requestedDigest", requestedDigest).addKeyValue("responseDigest", responseHeaderDigest).log((RuntimeException)new ServiceResponseException("The digest in the response header does not match the expected digest."));
        }
    }

    public static <H, T> String getLocation(ResponseBase<H, T> response) {
        String locationHeader = response.getHeaders().getValue(HttpHeaderName.LOCATION);
        if (locationHeader != null && locationHeader.startsWith("/")) {
            return locationHeader.substring(1);
        }
        return locationHeader;
    }

    public static long getBlobSize(HttpHeaders headers) {
        long size;
        HttpHeader contentRangeHeader = headers.get(HttpHeaderName.CONTENT_RANGE);
        if (contentRangeHeader != null && (size = CoreUtils.extractSizeFromContentRange((String)contentRangeHeader.getValue())) > 0L) {
            return size;
        }
        throw LOGGER.atError().addKeyValue("contentRange", (Object)contentRangeHeader).log((RuntimeException)new ServiceResponseException("Missing or invalid content-range header in response"));
    }

    public static long getContentLength(HttpHeader contentLengthHeader) {
        if (contentLengthHeader != null && contentLengthHeader.getValue() != null) {
            return Long.parseLong(contentLengthHeader.getValue());
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new ServiceResponseException("Content-Length header in missing in the response"));
    }

    public static boolean isDigest(String tagOrDigest) {
        return tagOrDigest.length() == 71 && tagOrDigest.startsWith("sha256:");
    }

    public static String formatFullyQualifiedReference(String endpoint, String repositoryName, String tagOrDigest) {
        try {
            URL endpointUrl = new URL(endpoint);
            return endpointUrl.getHost() + "/" + repositoryName + (UtilsImpl.isDigest(tagOrDigest) ? "@" : ":") + tagOrDigest;
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL", ex));
        }
    }
}

