/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation.models;

import com.azure.containers.containerregistry.models.ArtifactArchitecture;
import com.azure.containers.containerregistry.models.ArtifactManifestPlatform;
import com.azure.containers.containerregistry.models.ArtifactOperatingSystem;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

public class ManifestAttributesBase
implements JsonSerializable<ManifestAttributesBase> {
    private String digest;
    private Long sizeInBytes;
    private OffsetDateTime createdOn;
    private OffsetDateTime lastUpdatedOn;
    private ArtifactArchitecture architecture;
    private ArtifactOperatingSystem operatingSystem;
    private List<ArtifactManifestPlatform> relatedArtifacts;
    private List<String> tags;
    private Boolean deleteEnabled;
    private Boolean writeEnabled;
    private Boolean listEnabled;
    private Boolean readEnabled;

    public String getDigest() {
        return this.digest;
    }

    public ManifestAttributesBase setDigest(String digest) {
        this.digest = digest;
        return this;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public ManifestAttributesBase setSizeInBytes(Long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
        return this;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public ManifestAttributesBase setCreatedOn(OffsetDateTime createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    public OffsetDateTime getLastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public ManifestAttributesBase setLastUpdatedOn(OffsetDateTime lastUpdatedOn) {
        this.lastUpdatedOn = lastUpdatedOn;
        return this;
    }

    public ArtifactArchitecture getArchitecture() {
        return this.architecture;
    }

    public ManifestAttributesBase setArchitecture(ArtifactArchitecture architecture) {
        this.architecture = architecture;
        return this;
    }

    public ArtifactOperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public ManifestAttributesBase setOperatingSystem(ArtifactOperatingSystem operatingSystem) {
        this.operatingSystem = operatingSystem;
        return this;
    }

    public List<ArtifactManifestPlatform> getRelatedArtifacts() {
        return this.relatedArtifacts;
    }

    public ManifestAttributesBase setRelatedArtifacts(List<ArtifactManifestPlatform> relatedArtifacts) {
        this.relatedArtifacts = relatedArtifacts;
        return this;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public ManifestAttributesBase setTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public Boolean isDeleteEnabled() {
        return this.deleteEnabled;
    }

    public ManifestAttributesBase setDeleteEnabled(Boolean deleteEnabled) {
        this.deleteEnabled = deleteEnabled;
        return this;
    }

    public Boolean isWriteEnabled() {
        return this.writeEnabled;
    }

    public ManifestAttributesBase setWriteEnabled(Boolean writeEnabled) {
        this.writeEnabled = writeEnabled;
        return this;
    }

    public Boolean isListEnabled() {
        return this.listEnabled;
    }

    public ManifestAttributesBase setListEnabled(Boolean listEnabled) {
        this.listEnabled = listEnabled;
        return this;
    }

    public Boolean isReadEnabled() {
        return this.readEnabled;
    }

    public ManifestAttributesBase setReadEnabled(Boolean readEnabled) {
        this.readEnabled = readEnabled;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("digest", this.digest);
        jsonWriter.writeStringField("createdTime", Objects.toString(this.createdOn, null));
        jsonWriter.writeStringField("lastUpdateTime", Objects.toString(this.lastUpdatedOn, null));
        jsonWriter.writeNumberField("imageSize", (Number)this.sizeInBytes);
        jsonWriter.writeStringField("architecture", Objects.toString((Object)this.architecture, null));
        jsonWriter.writeStringField("os", Objects.toString((Object)this.operatingSystem, null));
        jsonWriter.writeArrayField("references", this.relatedArtifacts, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("tags", this.tags, (writer, element) -> writer.writeString(element));
        if (this.deleteEnabled != null || this.writeEnabled != null || this.listEnabled != null || this.readEnabled != null) {
            jsonWriter.writeStartObject("changeableAttributes");
            jsonWriter.writeBooleanField("deleteEnabled", this.deleteEnabled);
            jsonWriter.writeBooleanField("writeEnabled", this.writeEnabled);
            jsonWriter.writeBooleanField("listEnabled", this.listEnabled);
            jsonWriter.writeBooleanField("readEnabled", this.readEnabled);
            jsonWriter.writeEndObject();
        }
        return jsonWriter.writeEndObject();
    }

    public static ManifestAttributesBase fromJson(JsonReader jsonReader) throws IOException {
        return (ManifestAttributesBase)jsonReader.readObject(reader -> {
            ManifestAttributesBase deserializedManifestAttributesBase = new ManifestAttributesBase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("digest".equals(fieldName)) {
                    deserializedManifestAttributesBase.digest = reader.getString();
                    continue;
                }
                if ("createdTime".equals(fieldName)) {
                    deserializedManifestAttributesBase.createdOn = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdateTime".equals(fieldName)) {
                    deserializedManifestAttributesBase.lastUpdatedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("imageSize".equals(fieldName)) {
                    deserializedManifestAttributesBase.sizeInBytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("architecture".equals(fieldName)) {
                    deserializedManifestAttributesBase.architecture = ArtifactArchitecture.fromString(reader.getString());
                    continue;
                }
                if ("os".equals(fieldName)) {
                    deserializedManifestAttributesBase.operatingSystem = ArtifactOperatingSystem.fromString(reader.getString());
                    continue;
                }
                if ("references".equals(fieldName)) {
                    List relatedArtifacts;
                    deserializedManifestAttributesBase.relatedArtifacts = relatedArtifacts = reader.readArray(reader1 -> ArtifactManifestPlatform.fromJson(reader1));
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    List tags;
                    deserializedManifestAttributesBase.tags = tags = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("changeableAttributes".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("deleteEnabled".equals(fieldName)) {
                            deserializedManifestAttributesBase.deleteEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        if ("writeEnabled".equals(fieldName)) {
                            deserializedManifestAttributesBase.writeEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        if ("listEnabled".equals(fieldName)) {
                            deserializedManifestAttributesBase.listEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        if ("readEnabled".equals(fieldName)) {
                            deserializedManifestAttributesBase.readEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManifestAttributesBase;
        });
    }
}

