// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.containers.containerregistry.implementation;

import com.azure.containers.containerregistry.implementation.models.AcrErrorsException;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsCheckBlobExistsHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsCheckChunkExistsHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsCompleteUploadHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsDeleteBlobHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsGetBlobHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsGetChunkHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsGetUploadStatusHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsMountBlobHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsStartUploadHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsUploadChunkHeaders;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ContainerRegistryBlobs. */
public final class ContainerRegistryBlobsImpl {
    /** The proxy service used to perform REST calls. */
    private final ContainerRegistryBlobsService service;

    /** The service client containing this operation class. */
    private final AzureContainerRegistryImpl client;

    /**
     * Initializes an instance of ContainerRegistryBlobsImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    ContainerRegistryBlobsImpl(AzureContainerRegistryImpl client) {
        this.service = RestProxy.create(ContainerRegistryBlobsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureContainerRegistryContainerRegistryBlobs to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{url}")
    @ServiceInterface(name = "AzureContainerRegist")
    public interface ContainerRegistryBlobsService {
        @Get("/v2/{name}/blobs/{digest}")
        @ExpectedResponses({ 200, 307 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<ContainerRegistryBlobsGetBlobHeaders, BinaryData>> getBlob(@HostParam("url") String url,
            @PathParam("name") String name, @PathParam("digest") String digest, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/v2/{name}/blobs/{digest}")
        @ExpectedResponses({ 200, 307 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<ContainerRegistryBlobsGetBlobHeaders, BinaryData> getBlobSync(@HostParam("url") String url,
            @PathParam("name") String name, @PathParam("digest") String digest, @HeaderParam("Accept") String accept,
            Context context);

        @Head("/v2/{name}/blobs/{digest}")
        @ExpectedResponses({ 200, 307 })
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<ResponseBase<ContainerRegistryBlobsCheckBlobExistsHeaders, Void>> checkBlobExists(
            @HostParam("url") String url, @PathParam("name") String name, @PathParam("digest") String digest,
            @HeaderParam("Accept") String accept, Context context);

        @Head("/v2/{name}/blobs/{digest}")
        @ExpectedResponses({ 200, 307 })
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        ResponseBase<ContainerRegistryBlobsCheckBlobExistsHeaders, Void> checkBlobExistsSync(
            @HostParam("url") String url, @PathParam("name") String name, @PathParam("digest") String digest,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/v2/{name}/blobs/{digest}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<ContainerRegistryBlobsDeleteBlobHeaders, Void>> deleteBlob(@HostParam("url") String url,
            @PathParam("name") String name, @PathParam("digest") String digest, Context context);

        @Delete("/v2/{name}/blobs/{digest}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<ContainerRegistryBlobsDeleteBlobHeaders, Void> deleteBlobSync(@HostParam("url") String url,
            @PathParam("name") String name, @PathParam("digest") String digest, Context context);

        @Post("/v2/{name}/blobs/uploads/")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<ResponseBase<ContainerRegistryBlobsMountBlobHeaders, Void>> mountBlob(@HostParam("url") String url,
            @PathParam("name") String name, @QueryParam("from") String from, @QueryParam("mount") String mount,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/v2/{name}/blobs/uploads/")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        ResponseBase<ContainerRegistryBlobsMountBlobHeaders, Void> mountBlobSync(@HostParam("url") String url,
            @PathParam("name") String name, @QueryParam("from") String from, @QueryParam("mount") String mount,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{nextBlobUuidLink}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<ResponseBase<ContainerRegistryBlobsGetUploadStatusHeaders, Void>> getUploadStatus(
            @HostParam("url") String url, @PathParam(value = "nextBlobUuidLink", encoded = true) String nextLink,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{nextBlobUuidLink}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        ResponseBase<ContainerRegistryBlobsGetUploadStatusHeaders, Void> getUploadStatusSync(
            @HostParam("url") String url, @PathParam(value = "nextBlobUuidLink", encoded = true) String nextLink,
            @HeaderParam("Accept") String accept, Context context);

        @Patch("/{nextBlobUuidLink}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<ResponseBase<ContainerRegistryBlobsUploadChunkHeaders, Void>> uploadChunk(@HostParam("url") String url,
            @PathParam(value = "nextBlobUuidLink", encoded = true) String nextLink,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> value,
            @HeaderParam("Content-Length") long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Patch("/{nextBlobUuidLink}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<ResponseBase<ContainerRegistryBlobsUploadChunkHeaders, Void>> uploadChunk(@HostParam("url") String url,
            @PathParam(value = "nextBlobUuidLink", encoded = true) String nextLink,
            @BodyParam("application/octet-stream") BinaryData value, @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Accept") String accept, Context context);

        @Patch("/{nextBlobUuidLink}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        ResponseBase<ContainerRegistryBlobsUploadChunkHeaders, Void> uploadChunkSync(@HostParam("url") String url,
            @PathParam(value = "nextBlobUuidLink", encoded = true) String nextLink,
            @BodyParam("application/octet-stream") BinaryData value, @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{nextBlobUuidLink}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<ResponseBase<ContainerRegistryBlobsCompleteUploadHeaders, Void>> completeUpload(
            @HostParam("url") String url, @QueryParam("digest") String digest,
            @PathParam(value = "nextBlobUuidLink", encoded = true) String nextLink,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> value,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Put("/{nextBlobUuidLink}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<ResponseBase<ContainerRegistryBlobsCompleteUploadHeaders, Void>> completeUpload(
            @HostParam("url") String url, @QueryParam("digest") String digest,
            @PathParam(value = "nextBlobUuidLink", encoded = true) String nextLink,
            @BodyParam("application/octet-stream") BinaryData value, @HeaderParam("Content-Length") Long contentLength,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{nextBlobUuidLink}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        ResponseBase<ContainerRegistryBlobsCompleteUploadHeaders, Void> completeUploadSync(@HostParam("url") String url,
            @QueryParam("digest") String digest, @PathParam(value = "nextBlobUuidLink", encoded = true) String nextLink,
            @BodyParam("application/octet-stream") BinaryData value, @HeaderParam("Content-Length") Long contentLength,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/{nextBlobUuidLink}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<Response<Void>> cancelUpload(@HostParam("url") String url,
            @PathParam(value = "nextBlobUuidLink", encoded = true) String nextLink,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/{nextBlobUuidLink}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Response<Void> cancelUploadSync(@HostParam("url") String url,
            @PathParam(value = "nextBlobUuidLink", encoded = true) String nextLink,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/v2/{name}/blobs/uploads/")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<ResponseBase<ContainerRegistryBlobsStartUploadHeaders, Void>> startUpload(@HostParam("url") String url,
            @PathParam("name") String name, @HeaderParam("Accept") String accept, Context context);

        @Post("/v2/{name}/blobs/uploads/")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        ResponseBase<ContainerRegistryBlobsStartUploadHeaders, Void> startUploadSync(@HostParam("url") String url,
            @PathParam("name") String name, @HeaderParam("Accept") String accept, Context context);

        @Get("/v2/{name}/blobs/{digest}")
        @ExpectedResponses({ 206 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<ResponseBase<ContainerRegistryBlobsGetChunkHeaders, BinaryData>> getChunk(@HostParam("url") String url,
            @PathParam("name") String name, @PathParam("digest") String digest, @HeaderParam("Range") String range,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/v2/{name}/blobs/{digest}")
        @ExpectedResponses({ 206 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        ResponseBase<ContainerRegistryBlobsGetChunkHeaders, BinaryData> getChunkSync(@HostParam("url") String url,
            @PathParam("name") String name, @PathParam("digest") String digest, @HeaderParam("Range") String range,
            @HeaderParam("Accept") String accept, Context context);

        @Head("/v2/{name}/blobs/{digest}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<ResponseBase<ContainerRegistryBlobsCheckChunkExistsHeaders, Void>> checkChunkExists(
            @HostParam("url") String url, @PathParam("name") String name, @PathParam("digest") String digest,
            @HeaderParam("Range") String range, @HeaderParam("Accept") String accept, Context context);

        @Head("/v2/{name}/blobs/{digest}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        ResponseBase<ContainerRegistryBlobsCheckChunkExistsHeaders, Void> checkChunkExistsSync(
            @HostParam("url") String url, @PathParam("name") String name, @PathParam("digest") String digest,
            @HeaderParam("Range") String range, @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Retrieve the blob from the registry identified by digest.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsGetBlobHeaders, BinaryData>> getBlobWithResponseAsync(String name,
        String digest) {
        final String accept = "application/octet-stream";
        return FluxUtil.withContext(context -> service.getBlob(this.client.getUrl(), name, digest, accept, context));
    }

    /**
     * Retrieve the blob from the registry identified by digest.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsGetBlobHeaders, BinaryData>> getBlobWithResponseAsync(String name,
        String digest, Context context) {
        final String accept = "application/octet-stream";
        return service.getBlob(this.client.getUrl(), name, digest, accept, context);
    }

    /**
     * Retrieve the blob from the registry identified by digest.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BinaryData> getBlobAsync(String name, String digest) {
        return getBlobWithResponseAsync(name, digest).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieve the blob from the registry identified by digest.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BinaryData> getBlobAsync(String name, String digest, Context context) {
        return getBlobWithResponseAsync(name, digest, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieve the blob from the registry identified by digest.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainerRegistryBlobsGetBlobHeaders, BinaryData> getBlobWithResponse(String name,
        String digest, Context context) {
        final String accept = "application/octet-stream";
        return service.getBlobSync(this.client.getUrl(), name, digest, accept, context);
    }

    /**
     * Retrieve the blob from the registry identified by digest.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BinaryData getBlob(String name, String digest) {
        return getBlobWithResponse(name, digest, Context.NONE).getValue();
    }

    /**
     * Same as GET, except only the headers are returned.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsCheckBlobExistsHeaders, Void>>
        checkBlobExistsWithResponseAsync(String name, String digest) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.checkBlobExists(this.client.getUrl(), name, digest, accept, context));
    }

    /**
     * Same as GET, except only the headers are returned.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsCheckBlobExistsHeaders, Void>>
        checkBlobExistsWithResponseAsync(String name, String digest, Context context) {
        final String accept = "application/json";
        return service.checkBlobExists(this.client.getUrl(), name, digest, accept, context);
    }

    /**
     * Same as GET, except only the headers are returned.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> checkBlobExistsAsync(String name, String digest) {
        return checkBlobExistsWithResponseAsync(name, digest).flatMap(ignored -> Mono.empty());
    }

    /**
     * Same as GET, except only the headers are returned.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> checkBlobExistsAsync(String name, String digest, Context context) {
        return checkBlobExistsWithResponseAsync(name, digest, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Same as GET, except only the headers are returned.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainerRegistryBlobsCheckBlobExistsHeaders, Void> checkBlobExistsWithResponse(String name,
        String digest, Context context) {
        final String accept = "application/json";
        return service.checkBlobExistsSync(this.client.getUrl(), name, digest, accept, context);
    }

    /**
     * Same as GET, except only the headers are returned.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void checkBlobExists(String name, String digest) {
        checkBlobExistsWithResponse(name, digest, Context.NONE);
    }

    /**
     * Removes an already uploaded blob.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsDeleteBlobHeaders, Void>> deleteBlobWithResponseAsync(String name,
        String digest) {
        return FluxUtil.withContext(context -> service.deleteBlob(this.client.getUrl(), name, digest, context));
    }

    /**
     * Removes an already uploaded blob.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsDeleteBlobHeaders, Void>> deleteBlobWithResponseAsync(String name,
        String digest, Context context) {
        return service.deleteBlob(this.client.getUrl(), name, digest, context);
    }

    /**
     * Removes an already uploaded blob.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteBlobAsync(String name, String digest) {
        return deleteBlobWithResponseAsync(name, digest).flatMap(ignored -> Mono.empty());
    }

    /**
     * Removes an already uploaded blob.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteBlobAsync(String name, String digest, Context context) {
        return deleteBlobWithResponseAsync(name, digest, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Removes an already uploaded blob.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainerRegistryBlobsDeleteBlobHeaders, Void> deleteBlobWithResponse(String name,
        String digest, Context context) {
        return service.deleteBlobSync(this.client.getUrl(), name, digest, context);
    }

    /**
     * Removes an already uploaded blob.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteBlob(String name, String digest) {
        deleteBlobWithResponse(name, digest, Context.NONE);
    }

    /**
     * Mount a blob identified by the `mount` parameter from another repository.
     *
     * @param name Name of the image (including the namespace).
     * @param from Name of the source repository.
     * @param mount Digest of blob to mount from the source repository.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsMountBlobHeaders, Void>> mountBlobWithResponseAsync(String name,
        String from, String mount) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.mountBlob(this.client.getUrl(), name, from, mount, accept, context));
    }

    /**
     * Mount a blob identified by the `mount` parameter from another repository.
     *
     * @param name Name of the image (including the namespace).
     * @param from Name of the source repository.
     * @param mount Digest of blob to mount from the source repository.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsMountBlobHeaders, Void>> mountBlobWithResponseAsync(String name,
        String from, String mount, Context context) {
        final String accept = "application/json";
        return service.mountBlob(this.client.getUrl(), name, from, mount, accept, context);
    }

    /**
     * Mount a blob identified by the `mount` parameter from another repository.
     *
     * @param name Name of the image (including the namespace).
     * @param from Name of the source repository.
     * @param mount Digest of blob to mount from the source repository.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> mountBlobAsync(String name, String from, String mount) {
        return mountBlobWithResponseAsync(name, from, mount).flatMap(ignored -> Mono.empty());
    }

    /**
     * Mount a blob identified by the `mount` parameter from another repository.
     *
     * @param name Name of the image (including the namespace).
     * @param from Name of the source repository.
     * @param mount Digest of blob to mount from the source repository.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> mountBlobAsync(String name, String from, String mount, Context context) {
        return mountBlobWithResponseAsync(name, from, mount, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Mount a blob identified by the `mount` parameter from another repository.
     *
     * @param name Name of the image (including the namespace).
     * @param from Name of the source repository.
     * @param mount Digest of blob to mount from the source repository.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainerRegistryBlobsMountBlobHeaders, Void> mountBlobWithResponse(String name, String from,
        String mount, Context context) {
        final String accept = "application/json";
        return service.mountBlobSync(this.client.getUrl(), name, from, mount, accept, context);
    }

    /**
     * Mount a blob identified by the `mount` parameter from another repository.
     *
     * @param name Name of the image (including the namespace).
     * @param from Name of the source repository.
     * @param mount Digest of blob to mount from the source repository.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void mountBlob(String name, String from, String mount) {
        mountBlobWithResponse(name, from, mount, Context.NONE);
    }

    /**
     * Retrieve status of upload identified by uuid. The primary purpose of this endpoint is to resolve the current
     * status of a resumable upload.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsGetUploadStatusHeaders, Void>>
        getUploadStatusWithResponseAsync(String nextLink) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getUploadStatus(this.client.getUrl(), nextLink, accept, context));
    }

    /**
     * Retrieve status of upload identified by uuid. The primary purpose of this endpoint is to resolve the current
     * status of a resumable upload.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsGetUploadStatusHeaders, Void>>
        getUploadStatusWithResponseAsync(String nextLink, Context context) {
        final String accept = "application/json";
        return service.getUploadStatus(this.client.getUrl(), nextLink, accept, context);
    }

    /**
     * Retrieve status of upload identified by uuid. The primary purpose of this endpoint is to resolve the current
     * status of a resumable upload.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> getUploadStatusAsync(String nextLink) {
        return getUploadStatusWithResponseAsync(nextLink).flatMap(ignored -> Mono.empty());
    }

    /**
     * Retrieve status of upload identified by uuid. The primary purpose of this endpoint is to resolve the current
     * status of a resumable upload.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> getUploadStatusAsync(String nextLink, Context context) {
        return getUploadStatusWithResponseAsync(nextLink, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Retrieve status of upload identified by uuid. The primary purpose of this endpoint is to resolve the current
     * status of a resumable upload.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainerRegistryBlobsGetUploadStatusHeaders, Void> getUploadStatusWithResponse(String nextLink,
        Context context) {
        final String accept = "application/json";
        return service.getUploadStatusSync(this.client.getUrl(), nextLink, accept, context);
    }

    /**
     * Retrieve status of upload identified by uuid. The primary purpose of this endpoint is to resolve the current
     * status of a resumable upload.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void getUploadStatus(String nextLink) {
        getUploadStatusWithResponse(nextLink, Context.NONE);
    }

    /**
     * Upload a stream of data without completing the upload.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param value Raw data of blob.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsUploadChunkHeaders, Void>>
        uploadChunkWithResponseAsync(String nextLink, Flux<ByteBuffer> value, long contentLength) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.uploadChunk(this.client.getUrl(), nextLink, value, contentLength, accept, context));
    }

    /**
     * Upload a stream of data without completing the upload.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param value Raw data of blob.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsUploadChunkHeaders, Void>>
        uploadChunkWithResponseAsync(String nextLink, Flux<ByteBuffer> value, long contentLength, Context context) {
        final String accept = "application/json";
        return service.uploadChunk(this.client.getUrl(), nextLink, value, contentLength, accept, context);
    }

    /**
     * Upload a stream of data without completing the upload.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param value Raw data of blob.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> uploadChunkAsync(String nextLink, Flux<ByteBuffer> value, long contentLength) {
        return uploadChunkWithResponseAsync(nextLink, value, contentLength).flatMap(ignored -> Mono.empty());
    }

    /**
     * Upload a stream of data without completing the upload.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param value Raw data of blob.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> uploadChunkAsync(String nextLink, Flux<ByteBuffer> value, long contentLength, Context context) {
        return uploadChunkWithResponseAsync(nextLink, value, contentLength, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Upload a stream of data without completing the upload.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param value Raw data of blob.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsUploadChunkHeaders, Void>>
        uploadChunkWithResponseAsync(String nextLink, BinaryData value, long contentLength) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.uploadChunk(this.client.getUrl(), nextLink, value, contentLength, accept, context));
    }

    /**
     * Upload a stream of data without completing the upload.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param value Raw data of blob.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsUploadChunkHeaders, Void>>
        uploadChunkWithResponseAsync(String nextLink, BinaryData value, long contentLength, Context context) {
        final String accept = "application/json";
        return service.uploadChunk(this.client.getUrl(), nextLink, value, contentLength, accept, context);
    }

    /**
     * Upload a stream of data without completing the upload.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param value Raw data of blob.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> uploadChunkAsync(String nextLink, BinaryData value, long contentLength) {
        return uploadChunkWithResponseAsync(nextLink, value, contentLength).flatMap(ignored -> Mono.empty());
    }

    /**
     * Upload a stream of data without completing the upload.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param value Raw data of blob.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> uploadChunkAsync(String nextLink, BinaryData value, long contentLength, Context context) {
        return uploadChunkWithResponseAsync(nextLink, value, contentLength, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Upload a stream of data without completing the upload.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param value Raw data of blob.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainerRegistryBlobsUploadChunkHeaders, Void> uploadChunkWithResponse(String nextLink,
        BinaryData value, long contentLength, Context context) {
        final String accept = "application/json";
        return service.uploadChunkSync(this.client.getUrl(), nextLink, value, contentLength, accept, context);
    }

    /**
     * Upload a stream of data without completing the upload.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param value Raw data of blob.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void uploadChunk(String nextLink, BinaryData value, long contentLength) {
        uploadChunkWithResponse(nextLink, value, contentLength, Context.NONE);
    }

    /**
     * Complete the upload, providing all the data in the body, if necessary. A request without a body will just
     * complete the upload with previously uploaded content.
     *
     * @param digest Digest of a BLOB.
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param value Optional raw data of blob.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsCompleteUploadHeaders, Void>>
        completeUploadWithResponseAsync(String digest, String nextLink, Flux<ByteBuffer> value, Long contentLength) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.completeUpload(this.client.getUrl(), digest, nextLink, value,
            contentLength, accept, context));
    }

    /**
     * Complete the upload, providing all the data in the body, if necessary. A request without a body will just
     * complete the upload with previously uploaded content.
     *
     * @param digest Digest of a BLOB.
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param value Optional raw data of blob.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsCompleteUploadHeaders, Void>> completeUploadWithResponseAsync(
        String digest, String nextLink, Flux<ByteBuffer> value, Long contentLength, Context context) {
        final String accept = "application/json";
        return service.completeUpload(this.client.getUrl(), digest, nextLink, value, contentLength, accept, context);
    }

    /**
     * Complete the upload, providing all the data in the body, if necessary. A request without a body will just
     * complete the upload with previously uploaded content.
     *
     * @param digest Digest of a BLOB.
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param value Optional raw data of blob.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> completeUploadAsync(String digest, String nextLink, Flux<ByteBuffer> value, Long contentLength) {
        return completeUploadWithResponseAsync(digest, nextLink, value, contentLength).flatMap(ignored -> Mono.empty());
    }

    /**
     * Complete the upload, providing all the data in the body, if necessary. A request without a body will just
     * complete the upload with previously uploaded content.
     *
     * @param digest Digest of a BLOB.
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param value Optional raw data of blob.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> completeUploadAsync(String digest, String nextLink, Flux<ByteBuffer> value, Long contentLength,
        Context context) {
        return completeUploadWithResponseAsync(digest, nextLink, value, contentLength, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Complete the upload, providing all the data in the body, if necessary. A request without a body will just
     * complete the upload with previously uploaded content.
     *
     * @param digest Digest of a BLOB.
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param value Optional raw data of blob.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsCompleteUploadHeaders, Void>>
        completeUploadWithResponseAsync(String digest, String nextLink, BinaryData value, Long contentLength) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.completeUpload(this.client.getUrl(), digest, nextLink, value,
            contentLength, accept, context));
    }

    /**
     * Complete the upload, providing all the data in the body, if necessary. A request without a body will just
     * complete the upload with previously uploaded content.
     *
     * @param digest Digest of a BLOB.
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param value Optional raw data of blob.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsCompleteUploadHeaders, Void>> completeUploadWithResponseAsync(
        String digest, String nextLink, BinaryData value, Long contentLength, Context context) {
        final String accept = "application/json";
        return service.completeUpload(this.client.getUrl(), digest, nextLink, value, contentLength, accept, context);
    }

    /**
     * Complete the upload, providing all the data in the body, if necessary. A request without a body will just
     * complete the upload with previously uploaded content.
     *
     * @param digest Digest of a BLOB.
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param value Optional raw data of blob.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> completeUploadAsync(String digest, String nextLink, BinaryData value, Long contentLength) {
        return completeUploadWithResponseAsync(digest, nextLink, value, contentLength).flatMap(ignored -> Mono.empty());
    }

    /**
     * Complete the upload, providing all the data in the body, if necessary. A request without a body will just
     * complete the upload with previously uploaded content.
     *
     * @param digest Digest of a BLOB.
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param value Optional raw data of blob.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> completeUploadAsync(String digest, String nextLink, BinaryData value, Long contentLength,
        Context context) {
        return completeUploadWithResponseAsync(digest, nextLink, value, contentLength, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Complete the upload, providing all the data in the body, if necessary. A request without a body will just
     * complete the upload with previously uploaded content.
     *
     * @param digest Digest of a BLOB.
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param value Optional raw data of blob.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainerRegistryBlobsCompleteUploadHeaders, Void> completeUploadWithResponse(String digest,
        String nextLink, BinaryData value, Long contentLength, Context context) {
        final String accept = "application/json";
        return service.completeUploadSync(this.client.getUrl(), digest, nextLink, value, contentLength, accept,
            context);
    }

    /**
     * Complete the upload, providing all the data in the body, if necessary. A request without a body will just
     * complete the upload with previously uploaded content.
     *
     * @param digest Digest of a BLOB.
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param value Optional raw data of blob.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void completeUpload(String digest, String nextLink, BinaryData value, Long contentLength) {
        completeUploadWithResponse(digest, nextLink, value, contentLength, Context.NONE);
    }

    /**
     * Cancel outstanding upload processes, releasing associated resources. If this is not called, the unfinished
     * uploads will eventually timeout.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> cancelUploadWithResponseAsync(String nextLink) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.cancelUpload(this.client.getUrl(), nextLink, accept, context));
    }

    /**
     * Cancel outstanding upload processes, releasing associated resources. If this is not called, the unfinished
     * uploads will eventually timeout.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> cancelUploadWithResponseAsync(String nextLink, Context context) {
        final String accept = "application/json";
        return service.cancelUpload(this.client.getUrl(), nextLink, accept, context);
    }

    /**
     * Cancel outstanding upload processes, releasing associated resources. If this is not called, the unfinished
     * uploads will eventually timeout.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> cancelUploadAsync(String nextLink) {
        return cancelUploadWithResponseAsync(nextLink).flatMap(ignored -> Mono.empty());
    }

    /**
     * Cancel outstanding upload processes, releasing associated resources. If this is not called, the unfinished
     * uploads will eventually timeout.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> cancelUploadAsync(String nextLink, Context context) {
        return cancelUploadWithResponseAsync(nextLink, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Cancel outstanding upload processes, releasing associated resources. If this is not called, the unfinished
     * uploads will eventually timeout.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> cancelUploadWithResponse(String nextLink, Context context) {
        final String accept = "application/json";
        return service.cancelUploadSync(this.client.getUrl(), nextLink, accept, context);
    }

    /**
     * Cancel outstanding upload processes, releasing associated resources. If this is not called, the unfinished
     * uploads will eventually timeout.
     *
     * @param nextLink Link acquired from upload start or previous chunk. Note, do not include initial / (must do
     *     substring(1) ).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void cancelUpload(String nextLink) {
        cancelUploadWithResponse(nextLink, Context.NONE);
    }

    /**
     * Initiate a resumable blob upload with an empty request body.
     *
     * @param name Name of the image (including the namespace).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsStartUploadHeaders, Void>>
        startUploadWithResponseAsync(String name) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.startUpload(this.client.getUrl(), name, accept, context));
    }

    /**
     * Initiate a resumable blob upload with an empty request body.
     *
     * @param name Name of the image (including the namespace).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsStartUploadHeaders, Void>> startUploadWithResponseAsync(String name,
        Context context) {
        final String accept = "application/json";
        return service.startUpload(this.client.getUrl(), name, accept, context);
    }

    /**
     * Initiate a resumable blob upload with an empty request body.
     *
     * @param name Name of the image (including the namespace).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> startUploadAsync(String name) {
        return startUploadWithResponseAsync(name).flatMap(ignored -> Mono.empty());
    }

    /**
     * Initiate a resumable blob upload with an empty request body.
     *
     * @param name Name of the image (including the namespace).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> startUploadAsync(String name, Context context) {
        return startUploadWithResponseAsync(name, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Initiate a resumable blob upload with an empty request body.
     *
     * @param name Name of the image (including the namespace).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainerRegistryBlobsStartUploadHeaders, Void> startUploadWithResponse(String name,
        Context context) {
        final String accept = "application/json";
        return service.startUploadSync(this.client.getUrl(), name, accept, context);
    }

    /**
     * Initiate a resumable blob upload with an empty request body.
     *
     * @param name Name of the image (including the namespace).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void startUpload(String name) {
        startUploadWithResponse(name, Context.NONE);
    }

    /**
     * Retrieve the blob from the registry identified by `digest`. This endpoint may also support RFC7233 compliant
     * range requests. Support can be detected by issuing a HEAD request. If the header `Accept-Range: bytes` is
     * returned, range requests can be used to fetch partial content.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param range Format : bytes=&lt;start&gt;-&lt;end&gt;, HTTP Range header specifying blob chunk.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsGetChunkHeaders, BinaryData>> getChunkWithResponseAsync(String name,
        String digest, String range) {
        final String accept = "application/octet-stream";
        return FluxUtil
            .withContext(context -> service.getChunk(this.client.getUrl(), name, digest, range, accept, context));
    }

    /**
     * Retrieve the blob from the registry identified by `digest`. This endpoint may also support RFC7233 compliant
     * range requests. Support can be detected by issuing a HEAD request. If the header `Accept-Range: bytes` is
     * returned, range requests can be used to fetch partial content.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param range Format : bytes=&lt;start&gt;-&lt;end&gt;, HTTP Range header specifying blob chunk.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsGetChunkHeaders, BinaryData>> getChunkWithResponseAsync(String name,
        String digest, String range, Context context) {
        final String accept = "application/octet-stream";
        return service.getChunk(this.client.getUrl(), name, digest, range, accept, context);
    }

    /**
     * Retrieve the blob from the registry identified by `digest`. This endpoint may also support RFC7233 compliant
     * range requests. Support can be detected by issuing a HEAD request. If the header `Accept-Range: bytes` is
     * returned, range requests can be used to fetch partial content.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param range Format : bytes=&lt;start&gt;-&lt;end&gt;, HTTP Range header specifying blob chunk.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BinaryData> getChunkAsync(String name, String digest, String range) {
        return getChunkWithResponseAsync(name, digest, range).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieve the blob from the registry identified by `digest`. This endpoint may also support RFC7233 compliant
     * range requests. Support can be detected by issuing a HEAD request. If the header `Accept-Range: bytes` is
     * returned, range requests can be used to fetch partial content.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param range Format : bytes=&lt;start&gt;-&lt;end&gt;, HTTP Range header specifying blob chunk.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BinaryData> getChunkAsync(String name, String digest, String range, Context context) {
        return getChunkWithResponseAsync(name, digest, range, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieve the blob from the registry identified by `digest`. This endpoint may also support RFC7233 compliant
     * range requests. Support can be detected by issuing a HEAD request. If the header `Accept-Range: bytes` is
     * returned, range requests can be used to fetch partial content.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param range Format : bytes=&lt;start&gt;-&lt;end&gt;, HTTP Range header specifying blob chunk.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainerRegistryBlobsGetChunkHeaders, BinaryData> getChunkWithResponse(String name,
        String digest, String range, Context context) {
        final String accept = "application/octet-stream";
        return service.getChunkSync(this.client.getUrl(), name, digest, range, accept, context);
    }

    /**
     * Retrieve the blob from the registry identified by `digest`. This endpoint may also support RFC7233 compliant
     * range requests. Support can be detected by issuing a HEAD request. If the header `Accept-Range: bytes` is
     * returned, range requests can be used to fetch partial content.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param range Format : bytes=&lt;start&gt;-&lt;end&gt;, HTTP Range header specifying blob chunk.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BinaryData getChunk(String name, String digest, String range) {
        return getChunkWithResponse(name, digest, range, Context.NONE).getValue();
    }

    /**
     * Same as GET, except only the headers are returned.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param range Format : bytes=&lt;start&gt;-&lt;end&gt;, HTTP Range header specifying blob chunk.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsCheckChunkExistsHeaders, Void>>
        checkChunkExistsWithResponseAsync(String name, String digest, String range) {
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.checkChunkExists(this.client.getUrl(), name, digest, range, accept, context));
    }

    /**
     * Same as GET, except only the headers are returned.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param range Format : bytes=&lt;start&gt;-&lt;end&gt;, HTTP Range header specifying blob chunk.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistryBlobsCheckChunkExistsHeaders, Void>>
        checkChunkExistsWithResponseAsync(String name, String digest, String range, Context context) {
        final String accept = "application/json";
        return service.checkChunkExists(this.client.getUrl(), name, digest, range, accept, context);
    }

    /**
     * Same as GET, except only the headers are returned.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param range Format : bytes=&lt;start&gt;-&lt;end&gt;, HTTP Range header specifying blob chunk.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> checkChunkExistsAsync(String name, String digest, String range) {
        return checkChunkExistsWithResponseAsync(name, digest, range).flatMap(ignored -> Mono.empty());
    }

    /**
     * Same as GET, except only the headers are returned.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param range Format : bytes=&lt;start&gt;-&lt;end&gt;, HTTP Range header specifying blob chunk.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> checkChunkExistsAsync(String name, String digest, String range, Context context) {
        return checkChunkExistsWithResponseAsync(name, digest, range, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Same as GET, except only the headers are returned.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param range Format : bytes=&lt;start&gt;-&lt;end&gt;, HTTP Range header specifying blob chunk.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainerRegistryBlobsCheckChunkExistsHeaders, Void> checkChunkExistsWithResponse(String name,
        String digest, String range, Context context) {
        final String accept = "application/json";
        return service.checkChunkExistsSync(this.client.getUrl(), name, digest, range, accept, context);
    }

    /**
     * Same as GET, except only the headers are returned.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param range Format : bytes=&lt;start&gt;-&lt;end&gt;, HTTP Range header specifying blob chunk.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void checkChunkExists(String name, String digest, String range) {
        checkChunkExistsWithResponse(name, digest, range, Context.NONE);
    }
}
