// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.containers.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/** Returns the requested OCI Manifest file. */
@Fluent
public final class OciImageManifest implements JsonSerializable<OciImageManifest> {
    /*
     * V2 image config descriptor
     */
    private OciDescriptor configuration;

    /*
     * List of V2 image layer information
     */
    private List<OciDescriptor> layers;

    /*
     * Additional information provided through arbitrary metadata.
     */
    private OciAnnotations annotations;

    /*
     * Schema version
     */
    private int schemaVersion;

    /** Creates an instance of OciImageManifest class. */
    public OciImageManifest() {
    }

    /**
     * Get the configuration property: V2 image config descriptor.
     *
     * @return the configuration value.
     */
    public OciDescriptor getConfiguration() {
        return this.configuration;
    }

    /**
     * Set the configuration property: V2 image config descriptor.
     *
     * @param configuration the configuration value to set.
     * @return the OciImageManifest object itself.
     */
    public OciImageManifest setConfiguration(OciDescriptor configuration) {
        this.configuration = configuration;
        return this;
    }

    /**
     * Get the layers property: List of V2 image layer information.
     *
     * @return the layers value.
     */
    public List<OciDescriptor> getLayers() {
        return this.layers;
    }

    /**
     * Set the layers property: List of V2 image layer information.
     *
     * @param layers the layers value to set.
     * @return the OciImageManifest object itself.
     */
    public OciImageManifest setLayers(List<OciDescriptor> layers) {
        this.layers = layers;
        return this;
    }

    /**
     * Get the annotations property: Additional information provided through arbitrary metadata.
     *
     * @return the annotations value.
     */
    public OciAnnotations getAnnotations() {
        return this.annotations;
    }

    /**
     * Set the annotations property: Additional information provided through arbitrary metadata.
     *
     * @param annotations the annotations value to set.
     * @return the OciImageManifest object itself.
     */
    public OciImageManifest setAnnotations(OciAnnotations annotations) {
        this.annotations = annotations;
        return this;
    }

    /**
     * Get the schemaVersion property: Schema version.
     *
     * @return the schemaVersion value.
     */
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    /**
     * Set the schemaVersion property: Schema version.
     *
     * @param schemaVersion the schemaVersion value to set.
     * @return the OciImageManifest object itself.
     */
    public OciImageManifest setSchemaVersion(int schemaVersion) {
        this.schemaVersion = schemaVersion;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("schemaVersion", this.schemaVersion);
        jsonWriter.writeJsonField("config", this.configuration);
        jsonWriter.writeArrayField("layers", this.layers, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("annotations", this.annotations);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OciImageManifest from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of OciImageManifest if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OciImageManifest.
     */
    public static OciImageManifest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OciImageManifest deserializedOciImageManifest = new OciImageManifest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("schemaVersion".equals(fieldName)) {
                    deserializedOciImageManifest.schemaVersion = reader.getInt();
                } else if ("config".equals(fieldName)) {
                    deserializedOciImageManifest.configuration = OciDescriptor.fromJson(reader);
                } else if ("layers".equals(fieldName)) {
                    List<OciDescriptor> layers = reader.readArray(reader1 -> OciDescriptor.fromJson(reader1));
                    deserializedOciImageManifest.layers = layers;
                } else if ("annotations".equals(fieldName)) {
                    deserializedOciImageManifest.annotations = OciAnnotations.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOciImageManifest;
        });
    }
}
