/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation.authentication;

import com.azure.containers.containerregistry.implementation.AuthenticationsImpl;
import com.azure.containers.containerregistry.implementation.AzureContainerRegistryImpl;
import com.azure.containers.containerregistry.implementation.authentication.AccessTokenCacheImpl;
import com.azure.containers.containerregistry.implementation.authentication.ContainerRegistryRefreshTokenCredential;
import com.azure.containers.containerregistry.implementation.authentication.ContainerRegistryTokenRequestContext;
import com.azure.containers.containerregistry.implementation.authentication.JsonWebToken;
import com.azure.containers.containerregistry.implementation.models.AcrAccessToken;
import com.azure.containers.containerregistry.implementation.models.TokenGrantType;
import com.azure.containers.containerregistry.models.ContainerRegistryAudience;
import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.exception.ServiceResponseException;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.time.OffsetDateTime;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;

public class ContainerRegistryTokenService
implements TokenCredential {
    private final AccessTokenCacheImpl refreshTokenCache;
    private final AuthenticationsImpl authenticationsImpl;
    private final boolean isAnonymousAccess;
    private static final ClientLogger LOGGER = new ClientLogger(ContainerRegistryTokenService.class);
    private static final Mono<AccessToken> ANONYMOUS_REFRESH_TOKEN = Mono.just((Object)new AccessToken(null, OffsetDateTime.MAX));
    private final AtomicReference<String> lastAccessToken = new AtomicReference();

    public ContainerRegistryTokenService(TokenCredential aadTokenCredential, ContainerRegistryAudience audience, AzureContainerRegistryImpl client) {
        this.authenticationsImpl = client.getAuthentications();
        if (aadTokenCredential != null) {
            this.refreshTokenCache = new AccessTokenCacheImpl(new ContainerRegistryRefreshTokenCredential(this.authenticationsImpl, aadTokenCredential, audience));
            this.isAnonymousAccess = false;
        } else {
            this.refreshTokenCache = null;
            this.isAnonymousAccess = true;
        }
    }

    ContainerRegistryTokenService(AuthenticationsImpl authenticationsImpl, AccessTokenCacheImpl tokenCache) {
        this.authenticationsImpl = authenticationsImpl;
        this.refreshTokenCache = tokenCache;
        this.isAnonymousAccess = false;
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        if (!(request instanceof ContainerRegistryTokenRequestContext)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("tokenRequestContext is not of the type ContainerRegistryTokenRequestContext"));
        }
        ContainerRegistryTokenRequestContext crRequest = (ContainerRegistryTokenRequestContext)request;
        Mono<AccessToken> getRefreshToken = this.isAnonymousAccess ? ANONYMOUS_REFRESH_TOKEN : this.refreshTokenCache.getToken(crRequest, true);
        TokenGrantType grantType = this.isAnonymousAccess ? TokenGrantType.PASSWORD : TokenGrantType.REFRESH_TOKEN;
        return getRefreshToken.flatMap(refreshToken -> this.authenticationsImpl.exchangeAcrRefreshTokenForAcrAccessTokenWithResponseAsync(crRequest.getServiceName(), crRequest.getScope(), refreshToken.getToken(), grantType, Context.NONE)).map(this::toAccessToken);
    }

    public AccessToken getTokenSync(TokenRequestContext tokenRequestContext) {
        TokenGrantType grantType;
        if (!(tokenRequestContext instanceof ContainerRegistryTokenRequestContext)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("tokenRequestContext is not of the type ContainerRegistryTokenRequestContext"));
        }
        ContainerRegistryTokenRequestContext requestContext = (ContainerRegistryTokenRequestContext)tokenRequestContext;
        String refreshTokenString = null;
        TokenGrantType tokenGrantType = grantType = this.isAnonymousAccess ? TokenGrantType.PASSWORD : TokenGrantType.REFRESH_TOKEN;
        if (!this.isAnonymousAccess) {
            AccessToken refreshToken = this.refreshTokenCache.getTokenSync(requestContext, true);
            refreshTokenString = refreshToken.getToken();
        }
        return this.toAccessToken(this.authenticationsImpl.exchangeAcrRefreshTokenForAcrAccessTokenWithResponse(requestContext.getServiceName(), requestContext.getScope(), refreshTokenString, grantType, Context.NONE));
    }

    private AccessToken toAccessToken(Response<AcrAccessToken> response) {
        AcrAccessToken token = (AcrAccessToken)response.getValue();
        if (token != null) {
            String accessTokenStr = token.getAccessToken();
            this.lastAccessToken.set(accessTokenStr);
            return new AccessToken(accessTokenStr, JsonWebToken.retrieveExpiration(accessTokenStr));
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new ServiceResponseException("AcrAccessToken is missing in response."));
    }

    public String getLastToken() {
        return this.lastAccessToken.get();
    }
}

