// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.containers.containerregistry.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/** Sort options for ordering manifests in a collection. */
public final class ArtifactManifestOrder extends ExpandableStringEnum<ArtifactManifestOrder> {
    /** Do not provide an orderby value in the request. */
    public static final ArtifactManifestOrder NONE = fromString("none");

    /** Order manifests by LastUpdatedOn field, from most recently updated to least recently updated. */
    public static final ArtifactManifestOrder LAST_UPDATED_ON_DESCENDING = fromString("timedesc");

    /** Order manifest by LastUpdatedOn field, from least recently updated to most recently updated. */
    public static final ArtifactManifestOrder LAST_UPDATED_ON_ASCENDING = fromString("timeasc");

    /**
     * Creates a new instance of ArtifactManifestOrder value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ArtifactManifestOrder() {}

    /**
     * Creates or finds a ArtifactManifestOrder from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ArtifactManifestOrder.
     */
    public static ArtifactManifestOrder fromString(String name) {
        return fromString(name, ArtifactManifestOrder.class);
    }

    /**
     * Gets known ArtifactManifestOrder values.
     *
     * @return known ArtifactManifestOrder values.
     */
    public static Collection<ArtifactManifestOrder> values() {
        return values(ArtifactManifestOrder.class);
    }
}
