/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.ClaimsBasedSecurityNode;
import com.azure.core.amqp.implementation.CbsAuthorizationType;
import com.azure.core.amqp.implementation.RequestResponseChannel;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Objects;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;
import reactor.core.publisher.Mono;

public class ClaimsBasedSecurityChannel
implements ClaimsBasedSecurityNode {
    static final String PUT_TOKEN_TYPE = "type";
    static final String PUT_TOKEN_AUDIENCE = "name";
    private static final String PUT_TOKEN_OPERATION = "operation";
    private static final String PUT_TOKEN_OPERATION_VALUE = "put-token";
    private final TokenCredential credential;
    private final Mono<RequestResponseChannel> cbsChannelMono;
    private final CbsAuthorizationType authorizationType;
    private final AmqpRetryOptions retryOptions;

    public ClaimsBasedSecurityChannel(Mono<RequestResponseChannel> responseChannelMono, TokenCredential tokenCredential, CbsAuthorizationType authorizationType, AmqpRetryOptions retryOptions) {
        this.authorizationType = Objects.requireNonNull(authorizationType, "'authorizationType' cannot be null.");
        this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
        this.credential = Objects.requireNonNull(tokenCredential, "'tokenCredential' cannot be null.");
        this.cbsChannelMono = Objects.requireNonNull(responseChannelMono, "'responseChannelMono' cannot be null.").cache();
    }

    @Override
    public Mono<OffsetDateTime> authorize(String tokenAudience, String scopes) {
        Message request = Proton.message();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(PUT_TOKEN_OPERATION, PUT_TOKEN_OPERATION_VALUE);
        properties.put(PUT_TOKEN_TYPE, this.authorizationType.getTokenType());
        properties.put(PUT_TOKEN_AUDIENCE, tokenAudience);
        ApplicationProperties applicationProperties = new ApplicationProperties(properties);
        request.setApplicationProperties(applicationProperties);
        return this.credential.getToken(new TokenRequestContext().addScopes(new String[]{scopes})).flatMap(accessToken -> {
            request.setBody((Section)new AmqpValue((Object)accessToken.getToken()));
            return this.cbsChannelMono.flatMap(x -> x.sendWithAck(request)).then(Mono.fromCallable(() -> accessToken.getExpiresAt()));
        });
    }

    @Override
    public void close() {
        RequestResponseChannel channel = (RequestResponseChannel)this.cbsChannelMono.block(this.retryOptions.getTryTimeout());
        if (channel != null) {
            channel.close();
        }
    }
}

