/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpRetryPolicy;
import com.azure.core.amqp.ExponentialAmqpRetryPolicy;
import com.azure.core.amqp.FixedAmqpRetryPolicy;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.TimeoutException;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RetryUtil {
    private RetryUtil() {
    }

    public static AmqpRetryPolicy getRetryPolicy(AmqpRetryOptions options) {
        switch (options.getMode()) {
            case FIXED: {
                return new FixedAmqpRetryPolicy(options);
            }
            case EXPONENTIAL: {
                return new ExponentialAmqpRetryPolicy(options);
            }
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Mode is not supported: %s", new Object[]{options.getMode()}));
    }

    public static <T> Flux<T> withRetry(Flux<T> source, Duration operationTimeout, AmqpRetryPolicy retryPolicy) {
        return Flux.defer(() -> source.timeout(operationTimeout)).retryWhen(errors -> RetryUtil.retry((Flux<Throwable>)errors, retryPolicy));
    }

    public static <T> Mono<T> withRetry(Mono<T> source, Duration operationTimeout, AmqpRetryPolicy retryPolicy) {
        return Mono.defer(() -> source.timeout(operationTimeout)).retryWhen(errors -> RetryUtil.retry((Flux<Throwable>)errors, retryPolicy));
    }

    private static Flux<Long> retry(Flux<Throwable> source, AmqpRetryPolicy retryPolicy) {
        return source.zipWith((Publisher)Flux.range((int)1, (int)(retryPolicy.getMaxRetries() + 1)), (error, attempt) -> {
            if (!(error instanceof TimeoutException) || attempt > retryPolicy.getMaxRetries()) {
                throw Exceptions.propagate((Throwable)error);
            }
            return retryPolicy.calculateRetryDelay((TimeoutException)error, (int)attempt);
        }).flatMap(Mono::delay);
    }
}

