/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.ProcessKind;
import com.azure.core.util.tracing.Tracer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Signal;

public class TracerProvider {
    private final ClientLogger logger = new ClientLogger(TracerProvider.class);
    private final List<Tracer> tracers = new ArrayList<Tracer>();

    public TracerProvider(Iterable<Tracer> tracers) {
        Objects.requireNonNull(tracers, "'tracers' cannot be null.");
        tracers.forEach(e -> this.tracers.add((Tracer)e));
    }

    public boolean isEnabled() {
        return this.tracers.size() > 0;
    }

    public Context startSpan(Context context, ProcessKind processKind) {
        Context local = Objects.requireNonNull(context, "'context' cannot be null.");
        Objects.requireNonNull(processKind, "'processKind' cannot be null.");
        String spanName = this.getSpanName(processKind);
        for (Tracer tracer : this.tracers) {
            local = tracer.start(spanName, local, processKind);
        }
        return local;
    }

    public void endSpan(Context context, Signal<Void> signal) {
        Objects.requireNonNull(context, "'context' cannot be null.");
        Objects.requireNonNull(signal, "'signal' cannot be null.");
        switch (signal.getType()) {
            case ON_COMPLETE: {
                this.end("success", null, context);
                break;
            }
            case ON_ERROR: {
                String errorCondition = "";
                Throwable throwable = null;
                if (signal.hasError() && (throwable = signal.getThrowable()) instanceof AmqpException) {
                    AmqpException exception = (AmqpException)((Object)throwable);
                    errorCondition = exception.getErrorCondition().getErrorCondition();
                }
                this.end(errorCondition, throwable, context);
                break;
            }
        }
    }

    public void addSpanLinks(Context context) {
        Objects.requireNonNull(context, "'context' cannot be null.");
        this.tracers.forEach(tracer -> tracer.addLink(context));
    }

    public Context extractContext(String diagnosticId, Context context) {
        Context local = Objects.requireNonNull(context, "'context' cannot be null.");
        Objects.requireNonNull(diagnosticId, "'diagnosticId' cannot be null.");
        for (Tracer tracer : this.tracers) {
            local = tracer.extractContext(diagnosticId, local);
        }
        return local;
    }

    private void end(String statusMessage, Throwable throwable, Context context) {
        for (Tracer tracer : this.tracers) {
            tracer.end(statusMessage, throwable, context);
        }
    }

    private String getSpanName(ProcessKind processKind) {
        String spanName = "Azure.eventhubs.";
        switch (processKind) {
            case SEND: {
                spanName = spanName + "send";
                break;
            }
            case MESSAGE: {
                spanName = spanName + "message";
                break;
            }
            case PROCESS: {
                spanName = spanName + "process";
                break;
            }
            default: {
                this.logger.warning("Unknown processKind type: {}", new Object[]{processKind});
            }
        }
        return spanName;
    }
}

