/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import com.azure.core.amqp.exception.AmqpErrorContext;
import com.azure.core.amqp.implementation.ClientConstants;
import com.azure.core.amqp.implementation.ExceptionUtil;
import com.azure.core.amqp.implementation.handler.Handler;
import com.azure.core.util.logging.ClientLogger;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.apache.qpid.proton.reactor.Handshaker;

public class ConnectionHandler
extends Handler {
    static final Symbol PRODUCT = Symbol.valueOf((String)"product");
    static final Symbol VERSION = Symbol.valueOf((String)"version");
    static final Symbol PLATFORM = Symbol.valueOf((String)"platform");
    static final Symbol FRAMEWORK = Symbol.valueOf((String)"framework");
    static final Symbol USER_AGENT = Symbol.valueOf((String)"user-agent");
    static final int MAX_USER_AGENT_LENGTH = 128;
    static final int AMQPS_PORT = 5671;
    static final int MAX_FRAME_SIZE = 65536;
    private final Map<String, Object> connectionProperties;
    protected final ClientLogger logger;

    public ConnectionHandler(String connectionId, String hostname) {
        this(connectionId, hostname, new ClientLogger(ConnectionHandler.class));
    }

    protected ConnectionHandler(String connectionId, String hostname, ClientLogger logger) {
        super(connectionId, hostname);
        this.add((org.apache.qpid.proton.engine.Handler)new Handshaker());
        this.logger = logger;
        this.connectionProperties = new HashMap<String, Object>();
        this.connectionProperties.put(PRODUCT.toString(), "azsdk-java-eventhubs");
        this.connectionProperties.put(VERSION.toString(), "5.0.0-beta.6");
        this.connectionProperties.put(PLATFORM.toString(), ClientConstants.PLATFORM_INFO);
        this.connectionProperties.put(FRAMEWORK.toString(), ClientConstants.FRAMEWORK_INFO);
        String userAgent = ClientConstants.USER_AGENT.length() <= 128 ? ClientConstants.USER_AGENT : ClientConstants.USER_AGENT.substring(0, 128);
        this.connectionProperties.put(USER_AGENT.toString(), userAgent);
    }

    public Map<String, Object> getConnectionProperties() {
        return this.connectionProperties;
    }

    public int getProtocolPort() {
        return 5671;
    }

    public int getMaxFrameSize() {
        return 65536;
    }

    protected void addTransportLayers(Event event, TransportInternal transport) {
        SslDomain domain = ConnectionHandler.createSslDomain(SslDomain.Mode.CLIENT);
        transport.ssl(domain);
    }

    public void onConnectionInit(Event event) {
        this.logger.info("onConnectionInit hostname[{}], connectionId[{}]", new Object[]{this.getHostname(), this.getConnectionId()});
        Connection connection = event.getConnection();
        String hostName = this.getHostname() + ":" + this.getProtocolPort();
        connection.setHostname(hostName);
        connection.setContainer(this.getConnectionId());
        HashMap properties = new HashMap();
        this.connectionProperties.forEach((key, value) -> properties.put(Symbol.getSymbol((String)key), value));
        connection.setProperties(properties);
        connection.open();
    }

    public void onConnectionBound(Event event) {
        this.logger.info("onConnectionBound hostname[{}], connectionId[{}]", new Object[]{this.getHostname(), this.getConnectionId()});
        Transport transport = event.getTransport();
        this.addTransportLayers(event, (TransportInternal)transport);
        Connection connection = event.getConnection();
        if (connection != null) {
            this.onNext(connection.getRemoteState());
        }
    }

    public void onConnectionUnbound(Event event) {
        Connection connection = event.getConnection();
        this.logger.info("onConnectionUnbound hostname[{}], connectionId[{}], state[{}], remoteState[{}]", new Object[]{connection.getHostname(), this.getConnectionId(), connection.getLocalState(), connection.getRemoteState()});
        if (connection.getRemoteState() != EndpointState.UNINITIALIZED) {
            connection.free();
        }
        this.onNext(connection.getRemoteState());
    }

    public void onTransportError(Event event) {
        Connection connection = event.getConnection();
        Transport transport = event.getTransport();
        ErrorCondition condition = transport.getCondition();
        this.logger.warning("onTransportError hostname[{}], connectionId[{}], error[{}]", new Object[]{connection != null ? connection.getHostname() : "n/a", this.getConnectionId(), condition != null ? condition.getDescription() : "n/a"});
        if (connection != null) {
            this.notifyErrorContext(connection, condition);
            this.onNext(connection.getRemoteState());
        }
        transport.unbind();
    }

    public void onTransportClosed(Event event) {
        Connection connection = event.getConnection();
        Transport transport = event.getTransport();
        ErrorCondition condition = transport.getCondition();
        this.logger.info("onTransportClosed hostname[{}], connectionId[{}], error[{}]", new Object[]{connection != null ? connection.getHostname() : "n/a", this.getConnectionId(), condition != null ? condition.getDescription() : "n/a"});
        if (connection != null) {
            this.notifyErrorContext(connection, condition);
            this.onNext(connection.getRemoteState());
        }
    }

    public void onConnectionLocalOpen(Event event) {
        Connection connection = event.getConnection();
        ErrorCondition error = connection.getCondition();
        this.logErrorCondition("onConnectionLocalOpen", connection, error);
    }

    public void onConnectionRemoteOpen(Event event) {
        Connection connection = event.getConnection();
        this.logger.info("onConnectionRemoteOpen hostname[{}], connectionId[{}], remoteContainer[{}]", new Object[]{connection.getHostname(), this.getConnectionId(), connection.getRemoteContainer()});
        this.onNext(connection.getRemoteState());
    }

    public void onConnectionLocalClose(Event event) {
        Transport transport;
        Connection connection = event.getConnection();
        ErrorCondition error = connection.getCondition();
        this.logErrorCondition("onConnectionLocalClose", connection, error);
        if (connection.getRemoteState() == EndpointState.CLOSED && (transport = connection.getTransport()) != null) {
            transport.unbind();
        }
        this.onNext(connection.getRemoteState());
    }

    public void onConnectionRemoteClose(Event event) {
        Connection connection = event.getConnection();
        ErrorCondition error = connection.getRemoteCondition();
        this.logErrorCondition("onConnectionRemoteClose", connection, error);
        this.onNext(connection.getRemoteState());
        this.notifyErrorContext(connection, error);
    }

    public void onConnectionFinal(Event event) {
        Connection connection = event.getConnection();
        ErrorCondition error = connection.getCondition();
        this.logErrorCondition("onConnectionFinal", connection, error);
        this.onNext(connection.getRemoteState());
        this.close();
    }

    public AmqpErrorContext getErrorContext() {
        return new AmqpErrorContext(this.getHostname());
    }

    private static SslDomain createSslDomain(SslDomain.Mode mode) {
        SslDomain domain = Proton.sslDomain();
        domain.init(mode);
        domain.setPeerAuthentication(SslDomain.VerifyMode.ANONYMOUS_PEER);
        return domain;
    }

    private void notifyErrorContext(Connection connection, ErrorCondition condition) {
        if (connection == null || connection.getRemoteState() == EndpointState.CLOSED) {
            return;
        }
        if (condition == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("notifyErrorContext does not have an ErrorCondition."));
        }
        Exception exception = ExceptionUtil.toException(condition.getCondition().toString(), condition.getDescription(), this.getErrorContext());
        this.onNext(exception);
    }

    private void logErrorCondition(String eventName, Connection connection, ErrorCondition error) {
        this.logger.info("{} hostname[{}], connectionId[{}], errorCondition[{}], errorDescription[{}]", new Object[]{eventName, connection.getHostname(), this.getConnectionId(), error != null ? error.getCondition() : "n/a", error != null ? error.getDescription() : "n/a"});
    }
}

