/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import com.azure.core.amqp.implementation.handler.ConnectionHandler;
import com.azure.core.util.logging.ClientLogger;
import com.microsoft.azure.proton.transport.ws.impl.WebSocketImpl;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.apache.qpid.proton.engine.impl.TransportLayer;

public class WebSocketsConnectionHandler
extends ConnectionHandler {
    static final int HTTPS_PORT = 443;
    static final int MAX_FRAME_SIZE = 4096;
    private static final String SOCKET_PATH = "/$servicebus/websocket";
    private static final String PROTOCOL = "AMQPWSB10";

    public WebSocketsConnectionHandler(String connectionId, String hostname) {
        super(connectionId, hostname, new ClientLogger(WebSocketsConnectionHandler.class));
    }

    @Override
    protected void addTransportLayers(Event event, TransportInternal transport) {
        String hostName = event.getConnection().getHostname();
        WebSocketImpl webSocket = new WebSocketImpl();
        webSocket.configure(hostName, SOCKET_PATH, "", 0, PROTOCOL, null, null);
        transport.addTransportLayer((TransportLayer)webSocket);
        this.logger.verbose("Adding web sockets transport layer for hostname[{}]", new Object[]{hostName});
        super.addTransportLayers(event, transport);
    }

    @Override
    public int getProtocolPort() {
        return 443;
    }

    @Override
    public int getMaxFrameSize() {
        return 4096;
    }
}

