/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.exception;

import java.util.HashMap;
import java.util.Map;

public enum AmqpResponseCode {
    ACCEPTED(202),
    OK(200),
    BAD_REQUEST(400),
    NOT_FOUND(404),
    FORBIDDEN(403),
    INTERNAL_SERVER_ERROR(500),
    UNAUTHORIZED(401);

    private static Map<Integer, AmqpResponseCode> valueMap;
    private final int value;

    private AmqpResponseCode(int value) {
        this.value = value;
    }

    public static AmqpResponseCode fromValue(int value) {
        return valueMap.get(value);
    }

    public int getValue() {
        return this.value;
    }

    static {
        valueMap = new HashMap<Integer, AmqpResponseCode>();
        for (AmqpResponseCode code : AmqpResponseCode.values()) {
            valueMap.put(code.value, code);
        }
    }
}

