/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import com.azure.core.amqp.implementation.handler.LinkHandler;
import com.azure.core.util.logging.ClientLogger;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class ReceiveLinkHandler
extends LinkHandler {
    private final String receiverName;
    private AtomicBoolean isFirstResponse = new AtomicBoolean(true);
    private final Flux<Delivery> deliveries = Flux.create(sink -> {
        this.deliverySink = sink;
    });
    private FluxSink<Delivery> deliverySink;

    public ReceiveLinkHandler(String connectionId, String hostname, String receiverName, String entityPath) {
        super(connectionId, hostname, entityPath, new ClientLogger(ReceiveLinkHandler.class));
        this.receiverName = receiverName;
    }

    public Flux<Delivery> getDeliveredMessages() {
        return this.deliveries;
    }

    @Override
    public void close() {
        this.deliverySink.complete();
        super.close();
    }

    public void onLinkLocalOpen(Event event) {
        Link link = event.getLink();
        if (link instanceof Receiver) {
            this.logger.info("onLinkLocalOpen connectionId[{}], linkName[{}], localSource[{}]", new Object[]{this.getConnectionId(), link.getName(), link.getSource()});
        }
    }

    public void onLinkRemoteOpen(Event event) {
        Link link = event.getLink();
        if (link instanceof Receiver) {
            if (link.getRemoteSource() != null) {
                this.logger.info("onLinkRemoteOpen connectionId[{}], linkName[{}], remoteSource[{}]", new Object[]{this.getConnectionId(), link.getName(), link.getRemoteSource()});
                if (this.isFirstResponse.getAndSet(false)) {
                    this.onNext(EndpointState.ACTIVE);
                }
            } else {
                this.logger.info("onLinkRemoteOpen connectionId[{}], linkName[{}], action[waitingForError]", new Object[]{this.getConnectionId(), link.getName()});
            }
        }
    }

    public void onDelivery(Event event) {
        if (this.isFirstResponse.getAndSet(false)) {
            this.onNext(EndpointState.ACTIVE);
        }
        Delivery delivery = event.getDelivery();
        Receiver link = (Receiver)delivery.getLink();
        if (!delivery.isPartial()) {
            if (delivery.isSettled()) {
                if (link != null) {
                    this.logger.verbose("onDelivery connectionId[{}], linkName[{}], updatedLinkCredit[{}], remoteCredit[{}], remoteCondition[{}], delivery.isSettled[{}]", new Object[]{this.getConnectionId(), link.getName(), link.getCredit(), link.getRemoteCredit(), link.getRemoteCondition(), delivery.isSettled()});
                } else {
                    this.logger.warning("connectionId[{}], delivery.isSettled[{}]", new Object[]{this.getConnectionId(), delivery.isSettled()});
                }
            } else {
                this.deliverySink.next((Object)delivery);
            }
        }
        if (link != null) {
            this.logger.verbose("onDelivery connectionId[{}], linkName[{}], updatedLinkCredit[{}], remoteCredit[{}], remoteCondition[{}], delivery.isPartial[{}]", new Object[]{this.getConnectionId(), link.getName(), link.getCredit(), link.getRemoteCredit(), link.getRemoteCondition(), delivery.isPartial()});
        }
    }
}

