/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import java.io.Closeable;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.EndpointState;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.ReplayProcessor;
import reactor.core.publisher.UnicastProcessor;

public abstract class Handler
extends BaseHandler
implements Closeable {
    private final ReplayProcessor<EndpointState> endpointStateProcessor = ReplayProcessor.cacheLastOrDefault((Object)EndpointState.UNINITIALIZED);
    private final UnicastProcessor<Throwable> errorContextProcessor = UnicastProcessor.create();
    private final FluxSink<EndpointState> endpointSink = this.endpointStateProcessor.sink();
    private final FluxSink<Throwable> errorSink = this.errorContextProcessor.sink();
    private final String connectionId;
    private final String hostname;

    Handler(String connectionId, String hostname) {
        this.connectionId = connectionId;
        this.hostname = hostname;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Flux<EndpointState> getEndpointStates() {
        return this.endpointStateProcessor.distinct();
    }

    public Flux<Throwable> getErrors() {
        return this.errorContextProcessor;
    }

    void onNext(EndpointState state) {
        this.endpointSink.next((Object)state);
        if (state == EndpointState.CLOSED) {
            this.endpointSink.complete();
        }
    }

    void onNext(Throwable context) {
        this.errorSink.next((Object)context);
    }

    @Override
    public void close() {
        this.endpointSink.complete();
        this.errorSink.complete();
    }
}

