/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.models;

import com.azure.core.amqp.models.AmqpMessageBody;
import com.azure.core.amqp.models.AmqpMessageHeader;
import com.azure.core.amqp.models.AmqpMessageProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class AmqpAnnotatedMessage {
    private final AmqpMessageBody amqpMessageBody;
    private final Map<String, Object> applicationProperties;
    private final Map<String, Object> deliveryAnnotations;
    private final Map<String, Object> messageAnnotations;
    private final Map<String, Object> footer;
    private final AmqpMessageHeader header;
    private final AmqpMessageProperties properties;

    public AmqpAnnotatedMessage(AmqpMessageBody body) {
        this.amqpMessageBody = Objects.requireNonNull(body, "'body' cannot be null.");
        this.applicationProperties = new HashMap<String, Object>();
        this.deliveryAnnotations = new HashMap<String, Object>();
        this.messageAnnotations = new HashMap<String, Object>();
        this.footer = new HashMap<String, Object>();
        this.header = new AmqpMessageHeader();
        this.properties = new AmqpMessageProperties();
    }

    public AmqpAnnotatedMessage(AmqpAnnotatedMessage message) {
        Objects.requireNonNull(message, "'message' cannot be null.");
        this.amqpMessageBody = Objects.requireNonNull(message.getBody(), "'message.body' cannot be null.");
        this.applicationProperties = new HashMap<String, Object>(message.getApplicationProperties());
        this.deliveryAnnotations = new HashMap<String, Object>(message.getDeliveryAnnotations());
        this.messageAnnotations = new HashMap<String, Object>(message.getMessageAnnotations());
        this.footer = new HashMap<String, Object>(message.getFooter());
        this.header = new AmqpMessageHeader(message.getHeader());
        this.properties = new AmqpMessageProperties(message.getProperties());
    }

    public Map<String, Object> getApplicationProperties() {
        return this.applicationProperties;
    }

    public AmqpMessageBody getBody() {
        return this.amqpMessageBody;
    }

    public Map<String, Object> getDeliveryAnnotations() {
        return this.deliveryAnnotations;
    }

    public Map<String, Object> getFooter() {
        return this.footer;
    }

    public AmqpMessageHeader getHeader() {
        return this.header;
    }

    public Map<String, Object> getMessageAnnotations() {
        return this.messageAnnotations;
    }

    public AmqpMessageProperties getProperties() {
        return this.properties;
    }
}

