/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.EndpointState;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.ReplayProcessor;

public abstract class Handler
extends BaseHandler
implements Closeable {
    private final AtomicBoolean isTerminal = new AtomicBoolean();
    private final ReplayProcessor<EndpointState> endpointStateProcessor = ReplayProcessor.cacheLastOrDefault((Object)EndpointState.UNINITIALIZED);
    private final FluxSink<EndpointState> endpointSink = this.endpointStateProcessor.sink();
    private final String connectionId;
    private final String hostname;

    Handler(String connectionId, String hostname) {
        this.connectionId = connectionId;
        this.hostname = hostname;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Flux<EndpointState> getEndpointStates() {
        return this.endpointStateProcessor.distinct();
    }

    void onNext(EndpointState state) {
        this.endpointSink.next((Object)state);
    }

    void onError(Throwable error) {
        if (this.isTerminal.getAndSet(true)) {
            return;
        }
        this.endpointSink.next((Object)EndpointState.CLOSED);
        this.endpointSink.error(error);
    }

    @Override
    public void close() {
        if (this.isTerminal.getAndSet(true)) {
            return;
        }
        this.endpointSink.next((Object)EndpointState.CLOSED);
        this.endpointSink.complete();
    }
}

