/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.AmqpConnection;
import com.azure.core.amqp.AmqpEndpointState;
import com.azure.core.amqp.AmqpRetryPolicy;
import com.azure.core.amqp.AmqpSession;
import com.azure.core.amqp.AmqpShutdownSignal;
import com.azure.core.amqp.ClaimsBasedSecurityNode;
import com.azure.core.amqp.implementation.AmqpChannelProcessor;
import com.azure.core.amqp.implementation.AmqpEndpointStateUtil;
import com.azure.core.amqp.implementation.AmqpExceptionHandler;
import com.azure.core.amqp.implementation.ClaimsBasedSecurityChannel;
import com.azure.core.amqp.implementation.ConnectionOptions;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.implementation.ReactorExecutor;
import com.azure.core.amqp.implementation.ReactorHandlerProvider;
import com.azure.core.amqp.implementation.ReactorProvider;
import com.azure.core.amqp.implementation.ReactorSession;
import com.azure.core.amqp.implementation.RequestResponseChannel;
import com.azure.core.amqp.implementation.RetryUtil;
import com.azure.core.amqp.implementation.TokenManagerProvider;
import com.azure.core.amqp.implementation.handler.ConnectionHandler;
import com.azure.core.amqp.implementation.handler.SessionHandler;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Extendable;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.reactor.Reactor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Disposable;
import reactor.core.publisher.DirectProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.ReplayProcessor;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class ReactorConnection
implements AmqpConnection {
    private static final String CBS_SESSION_NAME = "cbs-session";
    private static final String CBS_ADDRESS = "$cbs";
    private static final String CBS_LINK_NAME = "cbs";
    private final ClientLogger logger = new ClientLogger(ReactorConnection.class);
    private final ConcurrentMap<String, SessionSubscription> sessionMap = new ConcurrentHashMap<String, SessionSubscription>();
    private final AtomicBoolean isDisposed = new AtomicBoolean();
    private final DirectProcessor<AmqpShutdownSignal> shutdownSignals = DirectProcessor.create();
    private final FluxSink<AmqpShutdownSignal> shutdownSignalsSink = this.shutdownSignals.sink();
    private final ReplayProcessor<AmqpEndpointState> endpointStates;
    private final String connectionId;
    private final Mono<Connection> connectionMono;
    private final ConnectionHandler handler;
    private final ReactorHandlerProvider handlerProvider;
    private final TokenManagerProvider tokenManagerProvider;
    private final MessageSerializer messageSerializer;
    private final ConnectionOptions connectionOptions;
    private final ReactorProvider reactorProvider;
    private final AmqpRetryPolicy retryPolicy;
    private final SenderSettleMode senderSettleMode;
    private final ReceiverSettleMode receiverSettleMode;
    private ReactorExecutor executor;
    private ReactorExceptionHandler reactorExceptionHandler;
    private volatile ClaimsBasedSecurityChannel cbsChannel;
    private volatile Connection connection;

    public ReactorConnection(String connectionId, ConnectionOptions connectionOptions, ReactorProvider reactorProvider, ReactorHandlerProvider handlerProvider, TokenManagerProvider tokenManagerProvider, MessageSerializer messageSerializer, String product, String clientVersion, SenderSettleMode senderSettleMode, ReceiverSettleMode receiverSettleMode) {
        this.connectionOptions = connectionOptions;
        this.reactorProvider = reactorProvider;
        this.connectionId = connectionId;
        this.handlerProvider = handlerProvider;
        this.tokenManagerProvider = Objects.requireNonNull(tokenManagerProvider, "'tokenManagerProvider' cannot be null.");
        this.messageSerializer = messageSerializer;
        this.handler = handlerProvider.createConnectionHandler(connectionId, product, clientVersion, connectionOptions);
        this.retryPolicy = RetryUtil.getRetryPolicy(connectionOptions.getRetry());
        this.senderSettleMode = senderSettleMode;
        this.receiverSettleMode = receiverSettleMode;
        this.connectionMono = Mono.fromCallable(this::getOrCreateConnection);
        this.endpointStates = (ReplayProcessor)this.handler.getEndpointStates().takeUntilOther(this.shutdownSignals).map(state -> {
            this.logger.verbose("connectionId[{}]: State {}", new Object[]{connectionId, state});
            return AmqpEndpointStateUtil.getConnectionState(state);
        }).subscribeWith((Subscriber)ReplayProcessor.cacheLastOrDefault((Object)((Object)AmqpEndpointState.UNINITIALIZED)));
    }

    @Override
    public Flux<AmqpEndpointState> getEndpointStates() {
        return this.endpointStates;
    }

    @Override
    public Flux<AmqpShutdownSignal> getShutdownSignals() {
        return this.shutdownSignals;
    }

    @Override
    public Mono<ClaimsBasedSecurityNode> getClaimsBasedSecurityNode() {
        if (this.isDisposed()) {
            return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("connectionId[%s]: Connection is disposed. Cannot get CBS node.", this.connectionId))));
        }
        Flux activeEndpointState = RetryUtil.withRetry(this.getEndpointStates().takeUntil(x -> x == AmqpEndpointState.ACTIVE), this.connectionOptions.getRetry(), "ReactorConnection: Retries exhausted waiting for ACTIVE endpoint state on CBS node.");
        return Mono.when((Publisher[])new Publisher[]{this.connectionMono, activeEndpointState}).then(Mono.fromCallable(() -> this.getOrCreateCBSNode()));
    }

    @Override
    public String getId() {
        return this.connectionId;
    }

    @Override
    public String getFullyQualifiedNamespace() {
        return this.handler.getHostname();
    }

    @Override
    public int getMaxFrameSize() {
        return this.handler.getMaxFrameSize();
    }

    @Override
    public Map<String, Object> getConnectionProperties() {
        return this.handler.getConnectionProperties();
    }

    @Override
    public Mono<AmqpSession> createSession(String sessionName) {
        if (this.isDisposed()) {
            return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("connectionId[%s]: Connection is disposed. Cannot create session '%s'.", this.connectionId, sessionName))));
        }
        SessionSubscription existing = (SessionSubscription)this.sessionMap.get(sessionName);
        if (existing != null) {
            return Mono.just((Object)existing.getSession());
        }
        return this.connectionMono.map(connection -> {
            SessionSubscription sessionSubscription = this.sessionMap.computeIfAbsent(sessionName, key -> {
                SessionHandler handler = this.handlerProvider.createSessionHandler(this.connectionId, this.getFullyQualifiedNamespace(), (String)key, this.connectionOptions.getRetry().getTryTimeout());
                Session session = connection.session();
                BaseHandler.setHandler((Extendable)session, (Handler)handler);
                AmqpSession amqpSession = this.createSession((String)key, session, handler);
                Disposable subscription = amqpSession.getEndpointStates().subscribe(state -> {}, error -> {
                    this.logger.info("connectionId[{}] sessionName[{}]: Error occurred. Removing and disposing session.", new Object[]{this.connectionId, sessionName, error});
                    this.removeSession((String)key);
                }, () -> {
                    this.logger.info("connectionId[{}] sessionName[{}]: Complete. Removing and disposing session.", new Object[]{this.connectionId, sessionName});
                    this.removeSession((String)key);
                });
                return new SessionSubscription(amqpSession, subscription);
            });
            return sessionSubscription.getSession();
        });
    }

    protected AmqpSession createSession(String sessionName, Session session, SessionHandler handler) {
        return new ReactorSession(session, handler, sessionName, this.reactorProvider, this.handlerProvider, this.getClaimsBasedSecurityNode(), this.tokenManagerProvider, this.messageSerializer, this.connectionOptions.getRetry());
    }

    @Override
    public boolean removeSession(String sessionName) {
        return this.removeSession(sessionName, null);
    }

    public boolean isDisposed() {
        return this.isDisposed.get();
    }

    public void dispose() {
        this.dispose(null);
        this.shutdownSignalsSink.next((Object)new AmqpShutdownSignal(false, true, "Disposed by client."));
    }

    void dispose(ErrorCondition errorCondition) {
        String[] keys;
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        this.logger.info("connectionId[{}], errorCondition[{}]: Disposing of ReactorConnection.", new Object[]{this.connectionId, errorCondition != null ? errorCondition : "n/a"});
        for (String key : keys = this.sessionMap.keySet().toArray(new String[0])) {
            this.logger.info("connectionId[{}]: Removing session '{}'", new Object[]{this.connectionId, key});
            this.removeSession(key, errorCondition);
        }
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.executor != null) {
            this.executor.close();
        }
    }

    protected Mono<Connection> getReactorConnection() {
        return this.connectionMono;
    }

    protected Mono<RequestResponseChannel> createRequestResponseChannel(String sessionName, String linkName, String entityPath) {
        Flux createChannel = this.createSession(sessionName).cast(ReactorSession.class).map(reactorSession -> new RequestResponseChannel(this.getId(), this.getFullyQualifiedNamespace(), linkName, entityPath, reactorSession.session(), this.connectionOptions.getRetry(), this.handlerProvider, this.reactorProvider, this.messageSerializer, this.senderSettleMode, this.receiverSettleMode)).doOnNext(e -> this.logger.info("Emitting new response channel. connectionId: {}. entityPath: {}. linkName: {}.", new Object[]{this.getId(), entityPath, linkName})).repeat();
        return (Mono)createChannel.subscribeWith(new AmqpChannelProcessor<RequestResponseChannel>(this.connectionId, entityPath, channel -> channel.getEndpointStates(), this.retryPolicy, new ClientLogger(RequestResponseChannel.class)));
    }

    private boolean removeSession(String sessionName, ErrorCondition errorCondition) {
        if (sessionName == null) {
            return false;
        }
        SessionSubscription removed = (SessionSubscription)this.sessionMap.remove(sessionName);
        if (removed != null) {
            removed.dispose(errorCondition);
        }
        return removed != null;
    }

    private synchronized ClaimsBasedSecurityNode getOrCreateCBSNode() {
        if (this.cbsChannel == null) {
            this.logger.info("Setting CBS channel.");
            this.cbsChannel = new ClaimsBasedSecurityChannel(this.createRequestResponseChannel(CBS_SESSION_NAME, CBS_LINK_NAME, CBS_ADDRESS), this.connectionOptions.getTokenCredential(), this.connectionOptions.getAuthorizationType(), this.connectionOptions.getRetry());
        }
        return this.cbsChannel;
    }

    private synchronized Connection getOrCreateConnection() throws IOException {
        if (this.connection == null) {
            this.logger.info("connectionId[{}]: Creating and starting connection to {}:{}", new Object[]{this.connectionId, this.handler.getHostname(), this.handler.getProtocolPort()});
            Reactor reactor = this.reactorProvider.createReactor(this.connectionId, this.handler.getMaxFrameSize());
            this.connection = reactor.connectionToHost(this.handler.getHostname(), this.handler.getProtocolPort(), (Handler)this.handler);
            this.reactorExceptionHandler = new ReactorExceptionHandler();
            Scheduler scheduler = Schedulers.newSingle((String)"reactor-executor");
            this.executor = new ReactorExecutor(reactor, scheduler, this.connectionId, this.reactorExceptionHandler, this.connectionOptions.getRetry().getTryTimeout(), this.connectionOptions.getFullyQualifiedNamespace());
            this.executor.start();
        }
        return this.connection;
    }

    private static final class SessionSubscription {
        private final AtomicBoolean isDisposed = new AtomicBoolean();
        private final AmqpSession session;
        private final Disposable subscription;

        private SessionSubscription(AmqpSession session, Disposable subscription) {
            this.session = session;
            this.subscription = subscription;
        }

        public AmqpSession getSession() {
            return this.session;
        }

        void dispose(ErrorCondition errorCondition) {
            if (this.isDisposed.getAndSet(true)) {
                return;
            }
            if (this.session instanceof ReactorSession) {
                ReactorSession reactorSession = (ReactorSession)this.session;
                reactorSession.dispose(errorCondition);
            } else {
                this.session.dispose();
            }
            this.subscription.dispose();
        }
    }

    private final class ReactorExceptionHandler
    extends AmqpExceptionHandler {
        private ReactorExceptionHandler() {
        }

        @Override
        public void onConnectionError(Throwable exception) {
            if (ReactorConnection.this.isDisposed.get()) {
                super.onConnectionError(exception);
                return;
            }
            ReactorConnection.this.logger.warning("onReactorError connectionId[{}], hostName[{}], message[Starting new reactor], error[{}]", new Object[]{ReactorConnection.this.getId(), ReactorConnection.this.getFullyQualifiedNamespace(), exception.getMessage()});
            ReactorConnection.this.endpointStates.onError(exception);
            ReactorConnection.this.dispose();
        }

        @Override
        void onConnectionShutdown(AmqpShutdownSignal shutdownSignal) {
            if (ReactorConnection.this.isDisposed()) {
                super.onConnectionShutdown(shutdownSignal);
                return;
            }
            ReactorConnection.this.logger.warning("onReactorError connectionId[{}], hostName[{}], message[Shutting down], shutdown signal[{}]", new Object[]{ReactorConnection.this.getId(), ReactorConnection.this.getFullyQualifiedNamespace(), shutdownSignal.isInitiatedByClient(), shutdownSignal});
            ReactorConnection.this.dispose(new ErrorCondition(Symbol.getSymbol((String)"onReactorError"), shutdownSignal.toString()));
            ReactorConnection.this.shutdownSignalsSink.next((Object)shutdownSignal);
        }
    }
}

