/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.amqp.implementation.ConnectionOptions;
import com.azure.core.amqp.implementation.ReactorProvider;
import com.azure.core.amqp.implementation.handler.ConnectionHandler;
import com.azure.core.amqp.implementation.handler.ReceiveLinkHandler;
import com.azure.core.amqp.implementation.handler.SendLinkHandler;
import com.azure.core.amqp.implementation.handler.SessionHandler;
import com.azure.core.amqp.implementation.handler.WebSocketsConnectionHandler;
import com.azure.core.amqp.implementation.handler.WebSocketsProxyConnectionHandler;
import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.util.Locale;
import java.util.Objects;

public class ReactorHandlerProvider {
    private final ClientLogger logger = new ClientLogger(ReactorHandlerProvider.class);
    private final ReactorProvider provider;

    public ReactorHandlerProvider(ReactorProvider provider) {
        this.provider = Objects.requireNonNull(provider, "'provider' cannot be null.");
    }

    public ConnectionHandler createConnectionHandler(String connectionId, String productName, String clientVersion, ConnectionOptions options) {
        Objects.requireNonNull(connectionId, "'connectionId' cannot be null.");
        Objects.requireNonNull(options, "'options' cannot be null.");
        Objects.requireNonNull(productName, "'productName' cannot be null.");
        Objects.requireNonNull(clientVersion, "'clientVersion' cannot be null.");
        if (options.getTransportType() == AmqpTransportType.AMQP) {
            return new ConnectionHandler(connectionId, productName, clientVersion, options);
        }
        if (options.getTransportType() != AmqpTransportType.AMQP_WEB_SOCKETS) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException(String.format(Locale.US, "This transport type '%s' is not supported.", new Object[]{options.getTransportType()})));
        }
        boolean isCustomEndpointConfigured = !options.getFullyQualifiedNamespace().equals(options.getHostname());
        boolean isUserProxyConfigured = options.getProxyOptions() != null && options.getProxyOptions().isProxyAddressConfigured();
        boolean isSystemProxyConfigured = WebSocketsProxyConnectionHandler.shouldUseProxy(options.getFullyQualifiedNamespace(), options.getPort());
        if (isCustomEndpointConfigured && (isUserProxyConfigured || isSystemProxyConfigured)) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Unable to proxy connection to custom endpoint. Custom endpoint: %s. Proxy settings: %s. Namespace: %s", options.getHostname(), options.getProxyOptions().getProxyAddress(), options.getFullyQualifiedNamespace())));
        }
        if (isUserProxyConfigured) {
            this.logger.info("Using user configured proxy to connect to: '{}:{}'. Proxy: {}", new Object[]{options.getFullyQualifiedNamespace(), options.getPort(), options.getProxyOptions().getProxyAddress()});
            return new WebSocketsProxyConnectionHandler(connectionId, productName, clientVersion, options, options.getProxyOptions());
        }
        if (isSystemProxyConfigured) {
            this.logger.info("System default proxy configured for hostname:port '{}:{}'. Using proxy.", new Object[]{options.getFullyQualifiedNamespace(), options.getPort()});
            return new WebSocketsProxyConnectionHandler(connectionId, productName, clientVersion, options, ProxyOptions.SYSTEM_DEFAULTS);
        }
        return new WebSocketsConnectionHandler(connectionId, productName, clientVersion, options);
    }

    public SessionHandler createSessionHandler(String connectionId, String hostname, String sessionName, Duration openTimeout) {
        return new SessionHandler(connectionId, hostname, sessionName, this.provider.getReactorDispatcher(), openTimeout);
    }

    public SendLinkHandler createSendLinkHandler(String connectionId, String hostname, String senderName, String entityPath) {
        return new SendLinkHandler(connectionId, hostname, senderName, entityPath);
    }

    public ReceiveLinkHandler createReceiveLinkHandler(String connectionId, String hostname, String receiverName, String entityPath) {
        return new ReceiveLinkHandler(connectionId, hostname, receiverName, entityPath);
    }
}

