/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import com.azure.core.amqp.exception.AmqpErrorContext;
import com.azure.core.amqp.implementation.ClientConstants;
import com.azure.core.amqp.implementation.ConnectionOptions;
import com.azure.core.amqp.implementation.ExceptionUtil;
import com.azure.core.amqp.implementation.handler.Handler;
import com.azure.core.amqp.implementation.handler.StrictTlsContext;
import com.azure.core.amqp.implementation.handler.StrictTlsContextSpi;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.UserAgentUtil;
import com.azure.core.util.logging.ClientLogger;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.engine.SslPeerDetails;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.apache.qpid.proton.reactor.Handshaker;

public class ConnectionHandler
extends Handler {
    public static final int AMQPS_PORT = 5671;
    static final Symbol PRODUCT = Symbol.valueOf((String)"product");
    static final Symbol VERSION = Symbol.valueOf((String)"version");
    static final Symbol PLATFORM = Symbol.valueOf((String)"platform");
    static final Symbol FRAMEWORK = Symbol.valueOf((String)"framework");
    static final Symbol USER_AGENT = Symbol.valueOf((String)"user-agent");
    static final int MAX_FRAME_SIZE = 65536;
    private final Map<String, Object> connectionProperties;
    private final ClientLogger logger = new ClientLogger(ConnectionHandler.class);
    private final ConnectionOptions connectionOptions;

    public ConnectionHandler(String connectionId, String productName, String clientVersion, ConnectionOptions connectionOptions) {
        super(connectionId, Objects.requireNonNull(connectionOptions, "'connectionOptions' cannot be null.").getHostname());
        this.add((org.apache.qpid.proton.engine.Handler)new Handshaker());
        this.connectionOptions = connectionOptions;
        Objects.requireNonNull(productName, "'product' cannot be null.");
        Objects.requireNonNull(clientVersion, "'clientVersion' cannot be null.");
        this.connectionProperties = new HashMap<String, Object>();
        this.connectionProperties.put(PRODUCT.toString(), productName);
        this.connectionProperties.put(VERSION.toString(), clientVersion);
        this.connectionProperties.put(PLATFORM.toString(), ClientConstants.PLATFORM_INFO);
        this.connectionProperties.put(FRAMEWORK.toString(), ClientConstants.FRAMEWORK_INFO);
        ClientOptions clientOptions = connectionOptions.getClientOptions();
        String applicationId = !CoreUtils.isNullOrEmpty((CharSequence)clientOptions.getApplicationId()) ? clientOptions.getApplicationId() : null;
        String userAgent = UserAgentUtil.toUserAgentString((String)applicationId, (String)productName, (String)clientVersion, null);
        this.connectionProperties.put(USER_AGENT.toString(), userAgent);
    }

    public Map<String, Object> getConnectionProperties() {
        return this.connectionProperties;
    }

    public int getProtocolPort() {
        return this.connectionOptions.getPort();
    }

    public int getMaxFrameSize() {
        return 65536;
    }

    protected void addTransportLayers(Event event, TransportInternal transport) {
        SSLContext defaultSslContext;
        SslDomain sslDomain = Proton.sslDomain();
        sslDomain.init(SslDomain.Mode.CLIENT);
        SslDomain.VerifyMode verifyMode = this.connectionOptions.getSslVerifyMode();
        if (verifyMode == SslDomain.VerifyMode.ANONYMOUS_PEER) {
            defaultSslContext = null;
        } else {
            try {
                defaultSslContext = SSLContext.getDefault();
            }
            catch (NoSuchAlgorithmException e) {
                throw this.logger.logExceptionAsError(new RuntimeException("Default SSL algorithm not found in JRE. Please check your JRE setup.", e));
            }
        }
        if (verifyMode == SslDomain.VerifyMode.VERIFY_PEER_NAME) {
            StrictTlsContextSpi serviceProvider = new StrictTlsContextSpi(defaultSslContext);
            StrictTlsContext context = new StrictTlsContext(serviceProvider, defaultSslContext.getProvider(), defaultSslContext.getProtocol());
            String theHostname = this.getHostname();
            int theProtocol = this.getProtocolPort();
            SslPeerDetails peerDetails = Proton.sslPeerDetails((String)theHostname, (int)theProtocol);
            sslDomain.setSslContext((SSLContext)context);
            transport.ssl(sslDomain, peerDetails);
            return;
        }
        if (verifyMode == SslDomain.VerifyMode.VERIFY_PEER) {
            sslDomain.setSslContext(defaultSslContext);
        } else if (verifyMode == SslDomain.VerifyMode.ANONYMOUS_PEER) {
            this.logger.warning("{} is not secure.", new Object[]{verifyMode});
        } else {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("verifyMode is not supported: " + verifyMode));
        }
        sslDomain.setPeerAuthentication(verifyMode);
        transport.ssl(sslDomain);
    }

    public void onConnectionInit(Event event) {
        this.logger.info("onConnectionInit hostname[{}], connectionId[{}], amqpHostname[{}]", new Object[]{this.getHostname(), this.getConnectionId(), this.connectionOptions.getFullyQualifiedNamespace()});
        Connection connection = event.getConnection();
        connection.setHostname(this.connectionOptions.getFullyQualifiedNamespace());
        connection.setContainer(this.getConnectionId());
        HashMap properties = new HashMap();
        this.connectionProperties.forEach((key, value) -> properties.put(Symbol.getSymbol((String)key), value));
        connection.setProperties(properties);
        connection.open();
    }

    public void onConnectionBound(Event event) {
        this.logger.info("onConnectionBound hostname[{}], connectionId[{}]", new Object[]{this.getHostname(), this.getConnectionId()});
        Transport transport = event.getTransport();
        this.addTransportLayers(event, (TransportInternal)transport);
        Connection connection = event.getConnection();
        if (connection != null) {
            this.onNext(connection.getRemoteState());
        }
    }

    public void onConnectionUnbound(Event event) {
        Connection connection = event.getConnection();
        this.logger.info("onConnectionUnbound hostname[{}], connectionId[{}], state[{}], remoteState[{}]", new Object[]{connection.getHostname(), this.getConnectionId(), connection.getLocalState(), connection.getRemoteState()});
        if (connection.getRemoteState() != EndpointState.UNINITIALIZED) {
            connection.free();
        }
        this.onNext(connection.getRemoteState());
    }

    public void onTransportError(Event event) {
        Connection connection = event.getConnection();
        Transport transport = event.getTransport();
        ErrorCondition condition = transport.getCondition();
        this.logger.warning("onTransportError hostname[{}], connectionId[{}], error[{}]", new Object[]{connection != null ? connection.getHostname() : "n/a", this.getConnectionId(), condition != null ? condition.getDescription() : "n/a"});
        if (connection != null) {
            this.notifyErrorContext(connection, condition);
        }
        transport.unbind();
    }

    public void onTransportClosed(Event event) {
        Connection connection = event.getConnection();
        Transport transport = event.getTransport();
        ErrorCondition condition = transport.getCondition();
        this.logger.info("onTransportClosed hostname[{}], connectionId[{}], error[{}]", new Object[]{connection != null ? connection.getHostname() : "n/a", this.getConnectionId(), condition != null ? condition.getDescription() : "n/a"});
        if (connection != null) {
            this.notifyErrorContext(connection, condition);
        }
    }

    public void onConnectionLocalOpen(Event event) {
        Connection connection = event.getConnection();
        ErrorCondition error = connection.getCondition();
        this.logErrorCondition("onConnectionLocalOpen", connection, error);
    }

    public void onConnectionRemoteOpen(Event event) {
        Connection connection = event.getConnection();
        this.logger.info("onConnectionRemoteOpen hostname[{}], connectionId[{}], remoteContainer[{}]", new Object[]{connection.getHostname(), this.getConnectionId(), connection.getRemoteContainer()});
        this.onNext(connection.getRemoteState());
    }

    public void onConnectionLocalClose(Event event) {
        Transport transport;
        Connection connection = event.getConnection();
        ErrorCondition error = connection.getCondition();
        this.logErrorCondition("onConnectionLocalClose", connection, error);
        if (connection.getRemoteState() == EndpointState.CLOSED && (transport = connection.getTransport()) != null) {
            transport.unbind();
        }
    }

    public void onConnectionRemoteClose(Event event) {
        Connection connection = event.getConnection();
        ErrorCondition error = connection.getRemoteCondition();
        this.logErrorCondition("onConnectionRemoteClose", connection, error);
        if (error == null) {
            this.onNext(connection.getRemoteState());
        } else {
            this.notifyErrorContext(connection, error);
        }
    }

    public void onConnectionFinal(Event event) {
        Connection connection = event.getConnection();
        ErrorCondition error = connection.getCondition();
        this.logErrorCondition("onConnectionFinal", connection, error);
        this.onNext(connection.getRemoteState());
        this.close();
    }

    public AmqpErrorContext getErrorContext() {
        return new AmqpErrorContext(this.getHostname());
    }

    private void notifyErrorContext(Connection connection, ErrorCondition condition) {
        if (connection == null || connection.getRemoteState() == EndpointState.CLOSED) {
            return;
        }
        if (condition == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("connectionId[%s]: notifyErrorContext does not have an ErrorCondition.", this.getConnectionId())));
        }
        Exception exception = ExceptionUtil.toException(condition.getCondition().toString(), condition.getDescription(), this.getErrorContext());
        this.onError(exception);
    }

    private void logErrorCondition(String eventName, Connection connection, ErrorCondition error) {
        this.logger.info("{} hostname[{}], connectionId[{}], errorCondition[{}], errorDescription[{}]", new Object[]{eventName, connection.getHostname(), this.getConnectionId(), error != null ? error.getCondition() : "n/a", error != null ? error.getDescription() : "n/a"});
    }
}

