/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import com.azure.core.amqp.ProxyAuthenticationType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.amqp.implementation.AmqpErrorCode;
import com.azure.core.amqp.implementation.ConnectionOptions;
import com.azure.core.amqp.implementation.handler.WebSocketsConnectionHandler;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.microsoft.azure.proton.transport.proxy.ProxyConfiguration;
import com.microsoft.azure.proton.transport.proxy.ProxyHandler;
import com.microsoft.azure.proton.transport.proxy.impl.ProxyHandlerImpl;
import com.microsoft.azure.proton.transport.proxy.impl.ProxyImpl;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.qpid.proton.amqp.transport.ConnectionError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.apache.qpid.proton.engine.impl.TransportLayer;

public class WebSocketsProxyConnectionHandler
extends WebSocketsConnectionHandler {
    private static final String HTTPS_URI_FORMAT = "https://%s:%s";
    private final ClientLogger logger = new ClientLogger(WebSocketsProxyConnectionHandler.class);
    private final InetSocketAddress connectionHostname;
    private final ProxyOptions proxyOptions;
    private final String fullyQualifiedNamespace;
    private final String amqpBrokerHostname;

    public WebSocketsProxyConnectionHandler(String connectionId, String productName, String clientVersion, ConnectionOptions connectionOptions, ProxyOptions proxyOptions) {
        super(connectionId, productName, clientVersion, connectionOptions);
        this.proxyOptions = Objects.requireNonNull(proxyOptions, "'proxyConfiguration' cannot be null.");
        this.fullyQualifiedNamespace = connectionOptions.getFullyQualifiedNamespace();
        this.amqpBrokerHostname = connectionOptions.getFullyQualifiedNamespace() + ":" + connectionOptions.getPort();
        if (proxyOptions.isProxyAddressConfigured()) {
            this.connectionHostname = (InetSocketAddress)proxyOptions.getProxyAddress().address();
        } else {
            URI serviceUri = WebSocketsProxyConnectionHandler.createURI(connectionOptions.getHostname(), connectionOptions.getPort());
            ProxySelector proxySelector = ProxySelector.getDefault();
            if (proxySelector == null) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("ProxySelector should not be null."));
            }
            List<Proxy> proxies = proxySelector.select(serviceUri);
            if (!WebSocketsProxyConnectionHandler.isProxyAddressLegal(proxies)) {
                String formatted = String.format("No proxy address found for: '%s'. Available: %s.", serviceUri, proxies.stream().map(Proxy::toString).collect(Collectors.joining(", ")));
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(formatted));
            }
            Proxy proxy = proxies.get(0);
            this.connectionHostname = (InetSocketAddress)proxy.address();
        }
    }

    public static boolean shouldUseProxy(String hostname, int port) {
        Objects.requireNonNull(hostname, "'hostname' cannot be null.");
        URI uri = WebSocketsProxyConnectionHandler.createURI(hostname, port);
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (proxySelector == null) {
            return false;
        }
        List<Proxy> proxies = proxySelector.select(uri);
        return WebSocketsProxyConnectionHandler.isProxyAddressLegal(proxies);
    }

    @Override
    public String getHostname() {
        return this.connectionHostname.getHostString();
    }

    @Override
    public int getProtocolPort() {
        return this.connectionHostname.getPort();
    }

    @Override
    public void onTransportError(Event event) {
        int port;
        super.onTransportError(event);
        Transport transport = event.getTransport();
        Connection connection = event.getConnection();
        if (connection == null || transport == null) {
            this.logger.verbose("connectionId[{}] There is no connection or transport associated with error. Event: {}", new Object[]{event});
            return;
        }
        ErrorCondition errorCondition = transport.getCondition();
        if (errorCondition == null || !errorCondition.getCondition().equals(ConnectionError.FRAMING_ERROR) && !errorCondition.getCondition().equals(AmqpErrorCode.PROTON_IO_ERROR)) {
            this.logger.verbose("connectionId[{}] There is no error condition and these are not framing errors. Error: {}", new Object[]{errorCondition});
            return;
        }
        String hostname = event.getReactor().getConnectionAddress(connection);
        if (this.proxyOptions == null || CoreUtils.isNullOrEmpty((CharSequence)hostname)) {
            this.logger.verbose("connectionId[{}] Proxy is not configured and there is no host connected. Error: {}", new Object[]{errorCondition});
            return;
        }
        String[] hostNameParts = hostname.split(":");
        if (hostNameParts.length != 2) {
            this.logger.warning("connectionId[{}] Invalid hostname: {}", new Object[]{this.getConnectionId(), hostname});
            return;
        }
        try {
            port = Integer.parseInt(hostNameParts[1]);
        }
        catch (NumberFormatException ignore) {
            this.logger.warning("connectionId[{}] Invalid port number: {}", new Object[]{this.getConnectionId(), hostNameParts[1]});
            return;
        }
        IOException ioException = new IOException(errorCondition.getDescription());
        URI url = WebSocketsProxyConnectionHandler.createURI(this.fullyQualifiedNamespace, port);
        InetSocketAddress address = new InetSocketAddress(hostNameParts[0], port);
        this.logger.error("connectionId[{}] Failed to connect to url: '{}', proxy host: '{}'", new Object[]{this.getConnectionId(), url, address.getHostString(), ioException});
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (proxySelector != null) {
            proxySelector.connectFailed(url, address, ioException);
        }
    }

    @Override
    protected void addTransportLayers(Event event, TransportInternal transport) {
        super.addTransportLayers(event, transport);
        ProxyImpl proxy = this.proxyOptions != null && this.proxyOptions != ProxyOptions.SYSTEM_DEFAULTS ? new ProxyImpl(this.getProtonConfiguration()) : new ProxyImpl();
        ProxyHandlerImpl proxyHandler = new ProxyHandlerImpl();
        proxy.configure(this.amqpBrokerHostname, null, (ProxyHandler)proxyHandler, (Transport)transport);
        transport.addTransportLayer((TransportLayer)proxy);
        this.logger.info("connectionId[{}] addProxyHandshake: hostname[{}]", new Object[]{this.getConnectionId(), this.amqpBrokerHostname});
    }

    private ProxyConfiguration getProtonConfiguration() {
        com.microsoft.azure.proton.transport.proxy.ProxyAuthenticationType type = this.getProtonAuthType(this.proxyOptions.getAuthentication());
        String username = this.proxyOptions.hasUserDefinedCredentials() ? this.proxyOptions.getCredential().getUserName() : null;
        String password = this.proxyOptions.hasUserDefinedCredentials() ? new String(this.proxyOptions.getCredential().getPassword()) : null;
        return new ProxyConfiguration(type, this.proxyOptions.getProxyAddress(), username, password);
    }

    private com.microsoft.azure.proton.transport.proxy.ProxyAuthenticationType getProtonAuthType(ProxyAuthenticationType type) {
        switch (type) {
            case DIGEST: {
                return com.microsoft.azure.proton.transport.proxy.ProxyAuthenticationType.DIGEST;
            }
            case BASIC: {
                return com.microsoft.azure.proton.transport.proxy.ProxyAuthenticationType.BASIC;
            }
            case NONE: {
                return com.microsoft.azure.proton.transport.proxy.ProxyAuthenticationType.NONE;
            }
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("connectionId[%s]: This authentication type is unknown: %s", this.getConnectionId(), type.name())));
    }

    private static URI createURI(String hostname, int port) {
        return URI.create(String.format(Locale.ROOT, HTTPS_URI_FORMAT, hostname, port));
    }

    private static boolean isProxyAddressLegal(List<Proxy> proxies) {
        return proxies != null && !proxies.isEmpty() && proxies.get(0).type() == Proxy.Type.HTTP && proxies.get(0).address() != null && proxies.get(0).address() instanceof InetSocketAddress;
    }
}

