/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import com.azure.core.util.logging.ClientLogger;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.reactor.impl.IOHandler;

public class CustomIOHandler
extends IOHandler {
    private final ClientLogger logger = new ClientLogger(CustomIOHandler.class);
    private final String connectionId;

    public CustomIOHandler(String connectionId) {
        this.connectionId = connectionId;
    }

    public void onTransportClosed(Event event) {
        Transport transport = event.getTransport();
        Connection connection = event.getConnection();
        this.logger.info("onTransportClosed connectionId[{}], hostname[{}]", new Object[]{this.connectionId, connection != null ? connection.getHostname() : "n/a"});
        if (transport != null && connection != null && connection.getTransport() != null) {
            transport.unbind();
        }
    }

    public void onUnhandled(Event event) {
        try {
            super.onUnhandled(event);
        }
        catch (NullPointerException e) {
            this.logger.error("Exception occurred when handling event in super.", new Object[]{e});
        }
    }
}

