/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.AmqpEndpointState;
import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.exception.AmqpErrorContext;
import com.azure.core.amqp.implementation.AmqpEndpointStateUtil;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.implementation.ReactorHandlerProvider;
import com.azure.core.amqp.implementation.ReactorProvider;
import com.azure.core.amqp.implementation.RetryUtil;
import com.azure.core.amqp.implementation.handler.ReceiveLinkHandler;
import com.azure.core.amqp.implementation.handler.SendLinkHandler;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Extendable;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.message.Message;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.ReplayProcessor;

public class RequestResponseChannel
implements Disposable {
    private final ConcurrentSkipListMap<UnsignedLong, MonoSink<Message>> unconfirmedSends = new ConcurrentSkipListMap();
    private final AtomicBoolean hasError = new AtomicBoolean();
    private final ReplayProcessor<AmqpEndpointState> endpointStates = ReplayProcessor.cacheLastOrDefault((Object)((Object)AmqpEndpointState.UNINITIALIZED));
    private final FluxSink<AmqpEndpointState> endpointStatesSink = this.endpointStates.sink(FluxSink.OverflowStrategy.BUFFER);
    private final ClientLogger logger = new ClientLogger(RequestResponseChannel.class);
    private final Sender sendLink;
    private final Receiver receiveLink;
    private final String replyTo;
    private final MessageSerializer messageSerializer;
    private final AmqpRetryOptions retryOptions;
    private final ReactorProvider provider;
    private final Duration operationTimeout;
    private final AtomicBoolean isDisposed = new AtomicBoolean();
    private final AtomicLong requestId = new AtomicLong(0L);
    private final SendLinkHandler sendLinkHandler;
    private final ReceiveLinkHandler receiveLinkHandler;
    private final Disposable.Composite subscriptions;
    private final SenderSettleMode senderSettleMode;
    private final String linkName;
    private final String connectionId;
    private final String activeEndpointTimeoutMessage;

    protected RequestResponseChannel(String connectionId, String fullyQualifiedNamespace, String linkName, String entityPath, Session session, AmqpRetryOptions retryOptions, ReactorHandlerProvider handlerProvider, ReactorProvider provider, MessageSerializer messageSerializer, SenderSettleMode senderSettleMode, ReceiverSettleMode receiverSettleMode) {
        this.connectionId = connectionId;
        this.linkName = linkName;
        this.retryOptions = retryOptions;
        this.provider = provider;
        this.operationTimeout = retryOptions.getTryTimeout();
        this.senderSettleMode = senderSettleMode;
        this.activeEndpointTimeoutMessage = String.format("RequestResponseChannel connectionId[%s], linkName[%s]: Waiting for send and receive handler to be ACTIVE", connectionId, linkName);
        this.replyTo = entityPath.replace("$", "") + "-client-reply-to";
        this.messageSerializer = messageSerializer;
        this.sendLink = session.sender(linkName + ":sender");
        Target target = new Target();
        target.setAddress(entityPath);
        this.sendLink.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
        this.sendLink.setSource((org.apache.qpid.proton.amqp.transport.Source)new Source());
        this.sendLink.setSenderSettleMode(senderSettleMode);
        this.sendLinkHandler = handlerProvider.createSendLinkHandler(connectionId, fullyQualifiedNamespace, linkName, entityPath);
        BaseHandler.setHandler((Extendable)this.sendLink, (Handler)this.sendLinkHandler);
        this.receiveLink = session.receiver(linkName + ":receiver");
        Source source = new Source();
        source.setAddress(entityPath);
        this.receiveLink.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
        Target receiverTarget = new Target();
        receiverTarget.setAddress(this.replyTo);
        this.receiveLink.setTarget((org.apache.qpid.proton.amqp.transport.Target)receiverTarget);
        this.receiveLink.setSenderSettleMode(senderSettleMode);
        this.receiveLink.setReceiverSettleMode(receiverSettleMode);
        this.receiveLinkHandler = handlerProvider.createReceiveLinkHandler(connectionId, fullyQualifiedNamespace, linkName, entityPath);
        BaseHandler.setHandler((Extendable)this.receiveLink, (Handler)this.receiveLinkHandler);
        this.subscriptions = Disposables.composite((Disposable[])new Disposable[]{this.receiveLinkHandler.getDeliveredMessages().map(this::decodeDelivery).subscribe(message -> {
            this.logger.verbose("connectionId[{}], linkName[{}]: Settling message: {}", new Object[]{connectionId, linkName, message.getCorrelationId()});
            this.settleMessage((Message)message);
        }), this.receiveLinkHandler.getEndpointStates().subscribe(state -> this.endpointStatesSink.next((Object)AmqpEndpointStateUtil.getConnectionState(state)), this::handleError, this::dispose), this.sendLinkHandler.getEndpointStates().subscribe(state -> this.endpointStatesSink.next((Object)AmqpEndpointStateUtil.getConnectionState(state)), this::handleError, this::dispose)});
        try {
            provider.getReactorDispatcher().invoke(() -> {
                this.sendLink.open();
                this.receiveLink.open();
            });
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(String.format("connectionId[%s], linkName[%s]: Unable to open send and receive link.", connectionId, linkName), e));
        }
    }

    public Flux<AmqpEndpointState> getEndpointStates() {
        return this.endpointStates;
    }

    public void dispose() {
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        this.subscriptions.dispose();
        this.sendLink.close();
        this.receiveLink.close();
    }

    public boolean isDisposed() {
        return this.isDisposed.get();
    }

    public Mono<Message> sendWithAck(Message message) {
        return this.sendWithAck(message, null);
    }

    public Mono<Message> sendWithAck(Message message, DeliveryState deliveryState) {
        if (this.isDisposed()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalStateException("Cannot send a message when request response channel is disposed."));
        }
        if (message == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("message cannot be null"));
        }
        if (message.getMessageId() != null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("message.getMessageId() should be null"));
        }
        if (message.getReplyTo() != null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("message.getReplyTo() should be null"));
        }
        UnsignedLong messageId = UnsignedLong.valueOf((long)this.requestId.incrementAndGet());
        message.setMessageId((Object)messageId);
        message.setReplyTo(this.replyTo);
        Mono activeEndpoints = Mono.when((Publisher[])new Publisher[]{this.sendLinkHandler.getEndpointStates().takeUntil(x -> x == EndpointState.ACTIVE), this.receiveLinkHandler.getEndpointStates().takeUntil(x -> x == EndpointState.ACTIVE)});
        return RetryUtil.withRetry(activeEndpoints, this.retryOptions, this.activeEndpointTimeoutMessage).then(Mono.create(sink -> {
            try {
                this.logger.verbose("connectionId[{}], linkName[{}]: Scheduling on dispatcher. MessageId[{}]", new Object[]{this.connectionId, this.linkName, messageId});
                this.unconfirmedSends.putIfAbsent(messageId, (MonoSink<Message>)sink);
                this.provider.getReactorDispatcher().invoke(() -> {
                    Delivery delivery = this.sendLink.delivery(UUID.randomUUID().toString().replace("-", "").getBytes(StandardCharsets.UTF_8));
                    if (deliveryState != null) {
                        this.logger.verbose("connectionId[{}], linkName[{}]: Setting delivery state as [{}].", new Object[]{this.connectionId, this.linkName, deliveryState});
                        delivery.setMessageFormat(0);
                        delivery.disposition(deliveryState);
                    }
                    int payloadSize = this.messageSerializer.getSize(message) + 512;
                    byte[] bytes = new byte[payloadSize];
                    int encodedSize = message.encode(bytes, 0, payloadSize);
                    this.receiveLink.flow(1);
                    this.sendLink.send(bytes, 0, encodedSize);
                    delivery.settle();
                    this.sendLink.advance();
                });
            }
            catch (IOException e) {
                sink.error((Throwable)e);
            }
        }));
    }

    public AmqpErrorContext getErrorContext() {
        return this.receiveLinkHandler.getErrorContext((Link)this.receiveLink);
    }

    protected Message decodeDelivery(Delivery delivery) {
        Message response = Proton.message();
        int msgSize = delivery.pending();
        byte[] buffer = new byte[msgSize];
        int read = this.receiveLink.recv(buffer, 0, msgSize);
        response.decode(buffer, 0, read);
        if (this.senderSettleMode == SenderSettleMode.SETTLED) {
            delivery.disposition((DeliveryState)Accepted.getInstance());
            delivery.settle();
        }
        return response;
    }

    private void settleMessage(Message message) {
        String id = String.valueOf(message.getCorrelationId());
        UnsignedLong correlationId = UnsignedLong.valueOf((String)id);
        MonoSink<Message> sink = this.unconfirmedSends.remove(correlationId);
        if (sink == null) {
            int size = this.unconfirmedSends.size();
            this.logger.warning("{} - Received delivery without pending messageId[{}]. Size[{}]", new Object[]{this.linkName, id, size});
            return;
        }
        sink.success((Object)message);
    }

    private void handleError(Throwable error) {
        if (this.hasError.getAndSet(true)) {
            return;
        }
        this.endpointStatesSink.error(error);
        this.logger.error("{} - Exception in RequestResponse links. Disposing and clearing unconfirmed sends.", new Object[]{this.linkName, error});
        this.dispose();
        this.unconfirmedSends.forEach((key, value) -> value.error(error));
        this.unconfirmedSends.clear();
    }
}

