/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.AmqpShutdownSignal;
import com.azure.core.util.logging.LoggingEventBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.Sinks;

public final class AmqpLoggingUtils {
    private AmqpLoggingUtils() {
    }

    public static Map<String, Object> createContextWithConnectionId(String connectionId) {
        Objects.requireNonNull(connectionId, "'connectionId' cannot be null.");
        HashMap<String, Object> globalLoggingContext = new HashMap<String, Object>(1);
        globalLoggingContext.put("connectionId", connectionId);
        return globalLoggingContext;
    }

    public static LoggingEventBuilder addSignalTypeAndResult(LoggingEventBuilder logBuilder, SignalType signalType, Sinks.EmitResult result) {
        return logBuilder.addKeyValue("signalType", (Object)signalType).addKeyValue("emitResult", (Object)result);
    }

    public static LoggingEventBuilder addErrorCondition(LoggingEventBuilder logBuilder, ErrorCondition errorCondition) {
        if (errorCondition != null) {
            if (errorCondition.getCondition() != null) {
                logBuilder.addKeyValue("errorCondition", (Object)errorCondition.getCondition());
            }
            if (errorCondition.getDescription() != null) {
                logBuilder.addKeyValue("errorDescription", errorCondition.getDescription());
            }
        }
        return logBuilder;
    }

    public static LoggingEventBuilder addKeyValueIfNotNull(LoggingEventBuilder logBuilder, String key, String value) {
        if (value != null) {
            logBuilder.addKeyValue(key, value);
        }
        return logBuilder;
    }

    public static LoggingEventBuilder addShutdownSignal(LoggingEventBuilder logBuilder, AmqpShutdownSignal shutdownSignal) {
        return logBuilder.addKeyValue("isTransient", shutdownSignal.isTransient()).addKeyValue("isInitiatedByClient", shutdownSignal.isInitiatedByClient()).addKeyValue("shutdownMessage", (Object)shutdownSignal);
    }
}

