/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.AmqpConnection;
import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.implementation.AmqpLinkProvider;
import com.azure.core.amqp.implementation.AmqpMetricsProvider;
import com.azure.core.amqp.implementation.AmqpReceiveLink;
import com.azure.core.amqp.implementation.ReactorHandlerProvider;
import com.azure.core.amqp.implementation.ReactorProvider;
import com.azure.core.amqp.implementation.TokenManager;
import com.azure.core.amqp.implementation.handler.DeliverySettleMode;
import com.azure.core.amqp.implementation.handler.ReceiveLinkHandler;
import com.azure.core.amqp.implementation.handler.ReceiveLinkHandler2;
import java.util.Objects;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Extendable;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Receiver;

public final class ConsumerFactory {
    private final boolean isV2;
    private final DeliverySettleMode settleMode;
    private final boolean includeDeliveryTagInMessage;

    public ConsumerFactory() {
        this.isV2 = false;
        this.settleMode = null;
        this.includeDeliveryTagInMessage = false;
    }

    public ConsumerFactory(DeliverySettleMode settlingMode, boolean includeDeliveryTagInMessage) {
        this.isV2 = true;
        this.settleMode = Objects.requireNonNull(settlingMode);
        this.includeDeliveryTagInMessage = includeDeliveryTagInMessage;
    }

    AmqpReceiveLink createConsumer(AmqpConnection amqpConnection, String linkName, String entityPath, Receiver receiver, TokenManager tokenManager, ReactorProvider reactorProvider, ReactorHandlerProvider handlerProvider, AmqpLinkProvider linkProvider, AmqpRetryOptions retryOptions) {
        String connectionId = amqpConnection.getId();
        String hostname = amqpConnection.getFullyQualifiedNamespace();
        AmqpMetricsProvider metricsProvider = handlerProvider.getMetricProvider(amqpConnection.getFullyQualifiedNamespace(), entityPath);
        if (this.isV2) {
            ReceiveLinkHandler2 handler = handlerProvider.createReceiveLinkHandler(connectionId, hostname, linkName, entityPath, this.settleMode, this.includeDeliveryTagInMessage, reactorProvider.getReactorDispatcher(), retryOptions);
            BaseHandler.setHandler((Extendable)receiver, (Handler)handler);
            receiver.open();
            return linkProvider.createReceiveLink(amqpConnection, entityPath, receiver, handler, tokenManager, reactorProvider.getReactorDispatcher(), retryOptions, metricsProvider);
        }
        ReceiveLinkHandler handler = handlerProvider.createReceiveLinkHandler(connectionId, hostname, linkName, entityPath);
        BaseHandler.setHandler((Extendable)receiver, (Handler)handler);
        receiver.open();
        return linkProvider.createReceiveLink(amqpConnection, entityPath, receiver, handler, tokenManager, reactorProvider.getReactorDispatcher(), retryOptions, metricsProvider);
    }
}

