/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.implementation.RequestResponseChannel;
import com.azure.core.amqp.implementation.RequestResponseChannelCache;
import java.util.Objects;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;

public final class ChannelCacheWrapper {
    private final Mono<RequestResponseChannel> channelProcessor;
    private final RequestResponseChannelCache channelCache;

    public ChannelCacheWrapper(Mono<RequestResponseChannel> channelProcessor) {
        this.channelProcessor = Objects.requireNonNull(channelProcessor, "'channelProcessor' cannot be null.");
        this.channelCache = null;
    }

    public ChannelCacheWrapper(RequestResponseChannelCache channelCache) {
        this.channelCache = Objects.requireNonNull(channelCache, "'channelCache' cannot be null.");
        this.channelProcessor = null;
    }

    public Mono<RequestResponseChannel> get() {
        if (this.channelCache != null) {
            return this.channelCache.get();
        }
        return this.channelProcessor;
    }

    public Mono<Void> closeAsync() {
        if (this.channelCache != null) {
            return this.channelCache.closeAsync();
        }
        return this.channelProcessor.flatMap(RequestResponseChannel::closeAsync);
    }

    public void dispose() {
        if (this.channelCache != null) {
            this.channelCache.dispose();
        } else if (this.channelProcessor instanceof Disposable) {
            ((Disposable)this.channelProcessor).dispose();
        }
    }
}

