/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.AmqpConnection;
import com.azure.core.amqp.AmqpEndpointState;
import com.azure.core.amqp.AmqpManagementNode;
import com.azure.core.amqp.AmqpRetryPolicy;
import com.azure.core.amqp.AmqpSession;
import com.azure.core.amqp.AmqpShutdownSignal;
import com.azure.core.amqp.ClaimsBasedSecurityNode;
import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.amqp.implementation.AmqpChannelProcessor;
import com.azure.core.amqp.implementation.AmqpEndpointStateUtil;
import com.azure.core.amqp.implementation.AmqpExceptionHandler;
import com.azure.core.amqp.implementation.AzureTokenManagerProvider;
import com.azure.core.amqp.implementation.ClaimsBasedSecurityChannel;
import com.azure.core.amqp.implementation.ClientConstants;
import com.azure.core.amqp.implementation.ConnectionOptions;
import com.azure.core.amqp.implementation.ManagementChannel;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.implementation.ReactorDispatcher;
import com.azure.core.amqp.implementation.ReactorExecutor;
import com.azure.core.amqp.implementation.ReactorHandlerProvider;
import com.azure.core.amqp.implementation.ReactorProvider;
import com.azure.core.amqp.implementation.ReactorSession;
import com.azure.core.amqp.implementation.RequestResponseChannel;
import com.azure.core.amqp.implementation.RetryUtil;
import com.azure.core.amqp.implementation.TokenManager;
import com.azure.core.amqp.implementation.TokenManagerProvider;
import com.azure.core.amqp.implementation.handler.ConnectionHandler;
import com.azure.core.amqp.implementation.handler.SessionHandler;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Extendable;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.reactor.Reactor;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class ReactorConnection
implements AmqpConnection {
    private static final String CBS_SESSION_NAME = "cbs-session";
    private static final String CBS_ADDRESS = "$cbs";
    private static final String CBS_LINK_NAME = "cbs";
    private static final String MANAGEMENT_SESSION_NAME = "mgmt-session";
    private static final String MANAGEMENT_ADDRESS = "$management";
    private static final String MANAGEMENT_LINK_NAME = "mgmt";
    private final ClientLogger logger = new ClientLogger(ReactorConnection.class);
    private final ConcurrentMap<String, SessionSubscription> sessionMap = new ConcurrentHashMap<String, SessionSubscription>();
    private final ConcurrentHashMap<String, AmqpManagementNode> managementNodes = new ConcurrentHashMap();
    private final AtomicBoolean isDisposed = new AtomicBoolean();
    private final Sinks.One<AmqpShutdownSignal> shutdownSignalSink = Sinks.one();
    private final Flux<AmqpEndpointState> endpointStates;
    private final Sinks.Empty<Void> isClosedMono = Sinks.empty();
    private final String connectionId;
    private final Mono<Connection> connectionMono;
    private final ConnectionHandler handler;
    private final ReactorHandlerProvider handlerProvider;
    private final TokenManagerProvider tokenManagerProvider;
    private final MessageSerializer messageSerializer;
    private final ConnectionOptions connectionOptions;
    private final ReactorProvider reactorProvider;
    private final AmqpRetryPolicy retryPolicy;
    private final SenderSettleMode senderSettleMode;
    private final ReceiverSettleMode receiverSettleMode;
    private final Duration operationTimeout;
    private final Disposable.Composite subscriptions;
    private ReactorExecutor executor;
    private volatile ClaimsBasedSecurityChannel cbsChannel;
    private volatile AmqpChannelProcessor<RequestResponseChannel> cbsChannelProcessor;
    private volatile Connection connection;

    public ReactorConnection(String connectionId, ConnectionOptions connectionOptions, ReactorProvider reactorProvider, ReactorHandlerProvider handlerProvider, TokenManagerProvider tokenManagerProvider, MessageSerializer messageSerializer, SenderSettleMode senderSettleMode, ReceiverSettleMode receiverSettleMode) {
        this.connectionOptions = connectionOptions;
        this.reactorProvider = reactorProvider;
        this.connectionId = connectionId;
        this.handlerProvider = handlerProvider;
        this.tokenManagerProvider = Objects.requireNonNull(tokenManagerProvider, "'tokenManagerProvider' cannot be null.");
        this.messageSerializer = messageSerializer;
        this.handler = handlerProvider.createConnectionHandler(connectionId, connectionOptions);
        this.retryPolicy = RetryUtil.getRetryPolicy(connectionOptions.getRetry());
        this.operationTimeout = connectionOptions.getRetry().getTryTimeout();
        this.senderSettleMode = senderSettleMode;
        this.receiverSettleMode = receiverSettleMode;
        this.connectionMono = Mono.fromCallable(this::getOrCreateConnection).flatMap(reactorConnection -> {
            Mono activeEndpoint = this.getEndpointStates().filter(state -> state == AmqpEndpointState.ACTIVE).next().timeout(this.operationTimeout, Mono.error((Throwable)((Object)new AmqpException(true, String.format("Connection '%s' not opened within AmqpRetryOptions.tryTimeout(): %s", connectionId, this.operationTimeout), this.handler.getErrorContext()))));
            return activeEndpoint.thenReturn(reactorConnection);
        }).doOnError(error -> {
            String message = String.format("connectionId[%s] Error occurred while connection was starting. Error: %s", connectionId, error);
            if (this.isDisposed.getAndSet(true)) {
                this.logger.verbose("connectionId[{}] was already disposed. {}", new Object[]{connectionId, message});
            } else {
                this.closeAsync(new AmqpShutdownSignal(false, false, message)).subscribe();
            }
        });
        this.endpointStates = this.handler.getEndpointStates().takeUntilOther((Publisher)this.shutdownSignalSink.asMono()).map(state -> {
            this.logger.verbose("connectionId[{}]: State {}", new Object[]{connectionId, state});
            return AmqpEndpointStateUtil.getConnectionState(state);
        }).onErrorResume(error -> {
            if (!this.isDisposed.getAndSet(true)) {
                this.logger.verbose("connectionId[{}]: Disposing of active sessions due to error.", new Object[]{connectionId});
                return this.closeAsync(new AmqpShutdownSignal(false, false, error.getMessage())).then(Mono.error((Throwable)error));
            }
            return Mono.error((Throwable)error);
        }).doOnComplete(() -> {
            if (!this.isDisposed.getAndSet(true)) {
                this.logger.verbose("connectionId[{}]: Disposing of active sessions due to connection close.", new Object[]{connectionId});
                this.closeAsync(new AmqpShutdownSignal(false, false, "Connection handler closed.")).subscribe();
            }
        }).cache(1);
        this.subscriptions = Disposables.composite((Disposable[])new Disposable[]{this.endpointStates.subscribe()});
    }

    @Override
    public Flux<AmqpEndpointState> getEndpointStates() {
        return this.endpointStates;
    }

    @Override
    public Flux<AmqpShutdownSignal> getShutdownSignals() {
        return this.shutdownSignalSink.asMono().cache().flux();
    }

    @Override
    public Mono<AmqpManagementNode> getManagementNode(String entityPath) {
        return Mono.defer(() -> {
            if (this.isDisposed()) {
                return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("connectionId[%s]: Connection is disposed. Cannot get management instance for '%s'", this.connectionId, entityPath))));
            }
            AmqpManagementNode existing = this.managementNodes.get(entityPath);
            if (existing != null) {
                return Mono.just((Object)existing);
            }
            TokenManager tokenManager = new AzureTokenManagerProvider(this.connectionOptions.getAuthorizationType(), this.connectionOptions.getFullyQualifiedNamespace(), this.connectionOptions.getAuthorizationScope()).getTokenManager(this.getClaimsBasedSecurityNode(), entityPath);
            return tokenManager.authorize().thenReturn((Object)this.managementNodes.compute(entityPath, (key, current) -> {
                if (current != null) {
                    this.logger.info("A management node exists already, returning it.");
                    tokenManager.close();
                    return current;
                }
                String sessionName = entityPath + "-" + MANAGEMENT_SESSION_NAME;
                String linkName = entityPath + "-" + MANAGEMENT_LINK_NAME;
                String address = entityPath + "/" + MANAGEMENT_ADDRESS;
                this.logger.info("Creating management node. entityPath[{}], address[{}], linkName[{}]", new Object[]{entityPath, address, linkName});
                AmqpChannelProcessor<RequestResponseChannel> requestResponseChannel = this.createRequestResponseChannel(sessionName, linkName, address);
                return new ManagementChannel(requestResponseChannel, this.getFullyQualifiedNamespace(), entityPath, tokenManager);
            }));
        });
    }

    @Override
    public Mono<ClaimsBasedSecurityNode> getClaimsBasedSecurityNode() {
        return this.connectionMono.then(Mono.fromCallable(() -> this.getOrCreateCBSNode()));
    }

    @Override
    public String getId() {
        return this.connectionId;
    }

    @Override
    public String getFullyQualifiedNamespace() {
        return this.handler.getHostname();
    }

    @Override
    public int getMaxFrameSize() {
        return this.handler.getMaxFrameSize();
    }

    @Override
    public Map<String, Object> getConnectionProperties() {
        return this.handler.getConnectionProperties();
    }

    @Override
    public Mono<AmqpSession> createSession(String sessionName) {
        return this.connectionMono.map(connection -> {
            SessionSubscription sessionSubscription = this.sessionMap.computeIfAbsent(sessionName, key -> {
                SessionHandler sessionHandler = this.handlerProvider.createSessionHandler(this.connectionId, this.getFullyQualifiedNamespace(), (String)key, this.connectionOptions.getRetry().getTryTimeout());
                Session session = connection.session();
                BaseHandler.setHandler((Extendable)session, (Handler)sessionHandler);
                AmqpSession amqpSession = this.createSession((String)key, session, sessionHandler);
                Disposable subscription = amqpSession.getEndpointStates().subscribe(state -> {}, error -> {
                    if (this.isDisposed.get()) {
                        return;
                    }
                    this.logger.info("connectionId[{}] sessionName[{}]: Error occurred. Removing and disposing session.", new Object[]{this.connectionId, sessionName, error});
                    this.removeSession((String)key);
                }, () -> {
                    if (this.isDisposed.get()) {
                        return;
                    }
                    this.logger.verbose("connectionId[{}] sessionName[{}]: Complete. Removing and disposing session.", new Object[]{this.connectionId, sessionName});
                    this.removeSession((String)key);
                });
                return new SessionSubscription(amqpSession, subscription);
            });
            return sessionSubscription;
        }).flatMap(sessionSubscription -> {
            Mono activeSession = ((SessionSubscription)sessionSubscription).getSession().getEndpointStates().filter(state -> state == AmqpEndpointState.ACTIVE).next().timeout(this.retryPolicy.getRetryOptions().getTryTimeout(), Mono.error((Throwable)((Object)new AmqpException(true, String.format("connectionId[%s] sessionName[%s] Timeout waiting for session to be active.", this.connectionId, sessionName), this.handler.getErrorContext()))));
            return activeSession.thenReturn((Object)((SessionSubscription)sessionSubscription).getSession());
        });
    }

    protected AmqpSession createSession(String sessionName, Session session, SessionHandler handler) {
        return new ReactorSession(this, session, handler, sessionName, this.reactorProvider, this.handlerProvider, this.getClaimsBasedSecurityNode(), this.tokenManagerProvider, this.messageSerializer, this.connectionOptions.getRetry());
    }

    @Override
    public boolean removeSession(String sessionName) {
        if (sessionName == null) {
            return false;
        }
        SessionSubscription removed = (SessionSubscription)this.sessionMap.remove(sessionName);
        if (removed != null) {
            removed.dispose();
        }
        return removed != null;
    }

    public boolean isDisposed() {
        return this.isDisposed.get();
    }

    public void dispose() {
        Duration timeout = this.operationTimeout.plus(this.operationTimeout);
        this.closeAsync().block(timeout);
    }

    protected Mono<Connection> getReactorConnection() {
        return this.connectionMono;
    }

    protected AmqpChannelProcessor<RequestResponseChannel> createRequestResponseChannel(String sessionName, String linkName, String entityPath) {
        Flux createChannel = this.createSession(sessionName).cast(ReactorSession.class).map(reactorSession -> new RequestResponseChannel(this, this.getId(), this.getFullyQualifiedNamespace(), linkName, entityPath, reactorSession.session(), this.connectionOptions.getRetry(), this.handlerProvider, this.reactorProvider, this.messageSerializer, this.senderSettleMode, this.receiverSettleMode)).doOnNext(e -> this.logger.info("connectionId[{}] entityPath[{}] linkName[{}] Emitting new response channel.", new Object[]{this.getId(), entityPath, linkName})).repeat();
        return (AmqpChannelProcessor)createChannel.subscribeWith(new AmqpChannelProcessor<RequestResponseChannel>(this.connectionId, entityPath, channel -> channel.getEndpointStates(), this.retryPolicy, new ClientLogger(RequestResponseChannel.class.getName() + ":" + entityPath)));
    }

    @Override
    public Mono<Void> closeAsync() {
        if (this.isDisposed.getAndSet(true)) {
            this.logger.verbose("connectionId[{}] Was already closed. Not disposing again.", new Object[]{this.connectionId});
            return this.isClosedMono.asMono();
        }
        return this.closeAsync(new AmqpShutdownSignal(false, true, "Disposed by client."));
    }

    Mono<Void> closeAsync(AmqpShutdownSignal shutdownSignal) {
        this.logger.info("connectionId[{}] signal[{}]: Disposing of ReactorConnection.", new Object[]{this.connectionId, shutdownSignal});
        Sinks.EmitResult result = this.shutdownSignalSink.tryEmitValue((Object)shutdownSignal);
        if (result.isFailure()) {
            this.logger.info("connectionId[{}] signal[{}] result[{}] Unable to emit shutdown signal.", new Object[]{this.connectionId, result});
        }
        Mono cbsCloseOperation = this.cbsChannelProcessor != null ? this.cbsChannelProcessor.flatMap(channel -> channel.closeAsync()) : Mono.empty();
        Mono managementNodeCloseOperations = Mono.when((Publisher[])new Publisher[]{Flux.fromStream(this.managementNodes.values().stream()).flatMap(node -> node.closeAsync())});
        Mono closeReactor = Mono.fromRunnable(() -> {
            this.logger.verbose("connectionId[{}] Scheduling closeConnection work.", new Object[]{this.connectionId});
            ReactorDispatcher dispatcher = this.reactorProvider.getReactorDispatcher();
            if (dispatcher != null) {
                try {
                    dispatcher.invoke(() -> this.closeConnectionWork());
                }
                catch (IOException | RejectedExecutionException e) {
                    this.logger.warning("connectionId[{}] Error while scheduling closeConnection work. Manually disposing.", new Object[]{this.connectionId, e});
                    this.closeConnectionWork();
                }
            } else {
                this.closeConnectionWork();
            }
        });
        return Mono.whenDelayError((Publisher[])new Publisher[]{cbsCloseOperation.doFinally(signalType -> this.logger.verbose("connectionId[{}] signalType[{}] Closed CBS node.", new Object[]{this.connectionId, signalType})), managementNodeCloseOperations.doFinally(signalType -> this.logger.verbose("connectionId[{}] signalType[{}] Closed management nodes.", new Object[]{this.connectionId, signalType}))}).then(closeReactor.doFinally(signalType -> this.logger.verbose("connectionId[{}] signalType[{}] Closed reactor dispatcher.", new Object[]{this.connectionId, signalType}))).then(this.isClosedMono.asMono());
    }

    private synchronized void closeConnectionWork() {
        if (this.connection == null) {
            this.isClosedMono.emitEmpty((signalType, emitResult) -> {
                this.logger.info("connectionId[{}] signal[{}] result[{}] Unable to complete closeMono.", new Object[]{this.connectionId, signalType, emitResult});
                return false;
            });
            return;
        }
        this.connection.close();
        this.handler.close();
        ArrayList closingSessions = new ArrayList();
        this.sessionMap.values().forEach(link -> closingSessions.add(((SessionSubscription)link).isClosed()));
        Mono closedExecutor = this.executor != null ? Mono.defer(() -> {
            ReactorConnection reactorConnection = this;
            synchronized (reactorConnection) {
                this.logger.info("connectionId[{}] Closing executor.", new Object[]{this.connectionId});
                return this.executor.closeAsync();
            }
        }) : Mono.empty();
        Mono closeSessionsMono = Mono.when(closingSessions).timeout(this.operationTimeout).onErrorResume(error -> {
            this.logger.warning("connectionId[{}]: Timed out waiting for all sessions to close.", new Object[]{this.connectionId});
            return Mono.empty();
        }).then(closedExecutor).then(Mono.fromRunnable(() -> {
            this.isClosedMono.emitEmpty((signalType, result) -> {
                this.logger.warning("connectionId[{}] signal[{}] result[{}]: Unable to emit connection closed signal", new Object[]{this.connectionId, signalType, result});
                return false;
            });
            this.subscriptions.dispose();
        }));
        this.subscriptions.add(closeSessionsMono.subscribe());
    }

    private synchronized ClaimsBasedSecurityNode getOrCreateCBSNode() {
        if (this.cbsChannel == null) {
            this.logger.info("Setting CBS channel.");
            this.cbsChannelProcessor = this.createRequestResponseChannel(CBS_SESSION_NAME, CBS_LINK_NAME, CBS_ADDRESS);
            this.cbsChannel = new ClaimsBasedSecurityChannel(this.cbsChannelProcessor, this.connectionOptions.getTokenCredential(), this.connectionOptions.getAuthorizationType(), this.connectionOptions.getRetry());
        }
        return this.cbsChannel;
    }

    private synchronized Connection getOrCreateConnection() throws IOException {
        if (this.connection == null) {
            this.logger.info("connectionId[{}]: Creating and starting connection to {}:{}", new Object[]{this.connectionId, this.handler.getHostname(), this.handler.getProtocolPort()});
            Reactor reactor = this.reactorProvider.createReactor(this.connectionId, this.handler.getMaxFrameSize());
            this.connection = reactor.connectionToHost(this.handler.getHostname(), this.handler.getProtocolPort(), (Handler)this.handler);
            ReactorExceptionHandler reactorExceptionHandler = new ReactorExceptionHandler();
            Duration timeoutDivided = this.connectionOptions.getRetry().getTryTimeout().dividedBy(2L);
            Duration pendingTasksDuration = ClientConstants.SERVER_BUSY_WAIT_TIME.compareTo(timeoutDivided) < 0 ? ClientConstants.SERVER_BUSY_WAIT_TIME : timeoutDivided;
            Scheduler scheduler = Schedulers.newSingle((String)"reactor-executor");
            this.executor = new ReactorExecutor(reactor, scheduler, this.connectionId, reactorExceptionHandler, pendingTasksDuration, this.connectionOptions.getFullyQualifiedNamespace());
            Mono executorCloseMono = Mono.defer(() -> {
                ReactorConnection reactorConnection = this;
                synchronized (reactorConnection) {
                    return this.executor.closeAsync();
                }
            });
            this.reactorProvider.getReactorDispatcher().getShutdownSignal().flatMap(signal -> {
                this.logger.info("Shutdown signal received from reactor provider.");
                reactorExceptionHandler.onConnectionShutdown((AmqpShutdownSignal)signal);
                return executorCloseMono;
            }).onErrorResume(error -> {
                this.logger.info("Error received from reactor provider.", new Object[]{error});
                reactorExceptionHandler.onConnectionError((Throwable)error);
                return executorCloseMono;
            }).subscribe();
            this.executor.start();
        }
        return this.connection;
    }

    private static final class SessionSubscription {
        private final AtomicBoolean isDisposed = new AtomicBoolean();
        private final AmqpSession session;
        private final Disposable subscription;

        private SessionSubscription(AmqpSession session, Disposable subscription) {
            this.session = session;
            this.subscription = subscription;
        }

        private AmqpSession getSession() {
            return this.session;
        }

        private void dispose() {
            if (this.isDisposed.getAndSet(true)) {
                return;
            }
            if (this.session instanceof ReactorSession) {
                ((ReactorSession)this.session).closeAsync("Closing session.", null, true).subscribe();
            } else {
                this.session.dispose();
            }
            this.subscription.dispose();
        }

        private Mono<Void> isClosed() {
            if (this.session instanceof ReactorSession) {
                return ((ReactorSession)this.session).isClosed();
            }
            return Mono.empty();
        }
    }

    private final class ReactorExceptionHandler
    extends AmqpExceptionHandler {
        private ReactorExceptionHandler() {
        }

        @Override
        public void onConnectionError(Throwable exception) {
            ReactorConnection.this.logger.info("onConnectionError connectionId[{}], hostName[{}], message[Starting new reactor], error[{}]", new Object[]{ReactorConnection.this.getId(), ReactorConnection.this.getFullyQualifiedNamespace(), exception.getMessage(), exception});
            if (!ReactorConnection.this.isDisposed.getAndSet(true)) {
                ReactorConnection.this.logger.verbose("onReactorError connectionId[{}], hostName[{}]: Disposing.", new Object[]{ReactorConnection.this.connectionId, ReactorConnection.this.getFullyQualifiedNamespace()});
                ReactorConnection.this.closeAsync(new AmqpShutdownSignal(false, false, "onReactorError: " + exception.toString())).subscribe();
            }
        }

        @Override
        void onConnectionShutdown(AmqpShutdownSignal shutdownSignal) {
            ReactorConnection.this.logger.info("onConnectionShutdown connectionId[{}], hostName[{}], message[Shutting down], shutdown signal[{}]", new Object[]{ReactorConnection.this.getId(), ReactorConnection.this.getFullyQualifiedNamespace(), shutdownSignal.isInitiatedByClient(), shutdownSignal});
            if (!ReactorConnection.this.isDisposed.getAndSet(true)) {
                ReactorConnection.this.logger.verbose("onConnectionShutdown connectionId[{}], hostName[{}]: disposing.");
                ReactorConnection.this.closeAsync(shutdownSignal).subscribe();
            }
        }
    }
}

