/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import com.azure.core.amqp.implementation.AmqpLoggingUtils;
import com.azure.core.util.logging.ClientLogger;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.reactor.impl.IOHandler;

public class CustomIOHandler
extends IOHandler {
    private final ClientLogger logger;

    public CustomIOHandler(String connectionId) {
        this.logger = new ClientLogger(CustomIOHandler.class, AmqpLoggingUtils.createContextWithConnectionId(connectionId));
    }

    public void onTransportClosed(Event event) {
        Transport transport = event.getTransport();
        Connection connection = event.getConnection();
        this.logger.atInfo().addKeyValue("hostName", connection != null ? connection.getHostname() : "n/a").log("onTransportClosed");
        if (transport != null && connection != null && connection.getTransport() != null) {
            transport.unbind();
        }
    }

    public void onUnhandled(Event event) {
        try {
            super.onUnhandled(event);
        }
        catch (NullPointerException e) {
            this.logger.error("Exception occurred when handling event in super.", new Object[]{e});
        }
    }
}

