/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp;

import com.azure.core.amqp.ProxyAuthenticationType;
import com.azure.core.util.logging.ClientLogger;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Objects;

public class ProxyOptions
implements AutoCloseable {
    public static final String PROXY_USERNAME = "PROXY_USERNAME";
    public static final String PROXY_PASSWORD = "PROXY_PASSWORD";
    private static final ClientLogger LOGGER = new ClientLogger(ProxyOptions.class);
    private final PasswordAuthentication credentials;
    private final Proxy proxyAddress;
    private final ProxyAuthenticationType authentication;
    public static final ProxyOptions SYSTEM_DEFAULTS = new ProxyOptions();

    private ProxyOptions() {
        this.credentials = null;
        this.proxyAddress = null;
        this.authentication = null;
    }

    public ProxyOptions(ProxyAuthenticationType authentication, Proxy proxyAddress, String username, String password) {
        this.authentication = Objects.requireNonNull(authentication, "'authentication' cannot be null.");
        this.proxyAddress = proxyAddress;
        if (username != null && password != null) {
            this.credentials = new PasswordAuthentication(username, password.toCharArray());
        } else {
            LOGGER.info("Username or password is null. Using system-wide authentication.");
            this.credentials = null;
        }
    }

    public ProxyAuthenticationType getAuthentication() {
        return this.authentication;
    }

    public Proxy getProxyAddress() {
        return this.proxyAddress;
    }

    public PasswordAuthentication getCredential() {
        return this.credentials;
    }

    public boolean hasUserDefinedCredentials() {
        return this.credentials != null;
    }

    public boolean isProxyAddressConfigured() {
        return this.proxyAddress != null && this.proxyAddress.address() != null;
    }

    @Override
    public void close() {
        if (this.credentials != null) {
            Arrays.fill(this.credentials.getPassword(), '\u0000');
        }
    }
}

