/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import java.time.Duration;
import java.time.Instant;

class TimeoutTracker {
    private final Duration originalTimeout;
    private boolean isTimerStarted;
    private Instant startTime;

    TimeoutTracker(Duration timeout, boolean startTrackingTimeout) {
        if (timeout.compareTo(Duration.ZERO) < 0) {
            throw new IllegalArgumentException("timeout should be non-negative");
        }
        this.originalTimeout = timeout;
        if (startTrackingTimeout) {
            this.startTime = Instant.now();
        }
        this.isTimerStarted = startTrackingTimeout;
    }

    Duration remaining() {
        return this.originalTimeout.minus(this.elapsed());
    }

    Duration elapsed() {
        if (!this.isTimerStarted) {
            this.startTime = Instant.now();
            this.isTimerStarted = true;
        }
        return Duration.between(this.startTime, Instant.now());
    }
}

