/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.exception.AmqpResponseCode;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.MetricsOptions;
import com.azure.core.util.TelemetryAttributes;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.metrics.DoubleHistogram;
import com.azure.core.util.metrics.LongCounter;
import com.azure.core.util.metrics.LongGauge;
import com.azure.core.util.metrics.Meter;
import com.azure.core.util.metrics.MeterProvider;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;

public class AmqpMetricsProvider {
    public static final String STATUS_CODE_KEY = "amqpStatusCode";
    public static final String MANAGEMENT_OPERATION_KEY = "amqpOperation";
    private static final ClientLogger LOGGER = new ClientLogger(AmqpMetricsProvider.class);
    private static final String AZURE_CORE_AMQP_PROPERTIES_NAME = "azure-core.properties";
    private static final String AZURE_CORE_AMQP_PROPERTIES_VERSION_KEY = "version";
    private static final String AZURE_CORE_VERSION = CoreUtils.getProperties((String)"azure-core.properties").getOrDefault("version", null);
    private static final AutoCloseable NOOP_CLOSEABLE = () -> {};
    private static final int DELIVERY_STATES_COUNT = DeliveryState.DeliveryStateType.values().length + 1;
    private static final int RESPONSE_CODES_COUNT = AmqpResponseCode.values().length + 1;
    private static final Meter DEFAULT_METER = MeterProvider.getDefaultProvider().createMeter("azure-core-amqp", AZURE_CORE_VERSION, new MetricsOptions());
    private static final AmqpMetricsProvider NOOP = new AmqpMetricsProvider();
    private final boolean isEnabled;
    private final Meter meter;
    private Map<String, Object> commonAttributesMap;
    private DoubleHistogram sendDuration = null;
    private DoubleHistogram requestResponseDuration = null;
    private LongCounter closedConnections = null;
    private LongCounter sessionErrors = null;
    private LongCounter linkErrors = null;
    private LongCounter transportErrors = null;
    private LongGauge prefetchedSequenceNumber = null;
    private LongCounter addCredits = null;
    private TelemetryAttributes[] sendAttributeCache = null;
    private AttributeCache[] requestResponseAttributeCache = null;
    private AttributeCache amqpErrorAttributeCache = null;
    private TelemetryAttributes commonAttributes = null;

    private AmqpMetricsProvider() {
        this.isEnabled = false;
        this.meter = DEFAULT_METER;
    }

    public AmqpMetricsProvider(Meter meter, String namespace, String entityPath) {
        this.meter = meter != null ? meter : DEFAULT_METER;
        this.isEnabled = this.meter.isEnabled();
        if (this.isEnabled) {
            this.commonAttributesMap = new HashMap<String, Object>();
            this.commonAttributesMap.put("hostName", namespace);
            if (entityPath != null) {
                int entityNameEnd = entityPath.indexOf(47);
                if (entityNameEnd > 0) {
                    this.commonAttributesMap.put("entityName", entityPath.substring(0, entityNameEnd));
                    this.commonAttributesMap.put("entityPath", entityPath);
                } else {
                    this.commonAttributesMap.put("entityName", entityPath);
                }
            }
            this.commonAttributes = this.meter.createAttributes(this.commonAttributesMap);
            this.requestResponseAttributeCache = new AttributeCache[RESPONSE_CODES_COUNT];
            this.sendAttributeCache = new TelemetryAttributes[DELIVERY_STATES_COUNT];
            this.amqpErrorAttributeCache = new AttributeCache("errorCondition", this.commonAttributesMap);
            this.sendDuration = this.meter.createDoubleHistogram("messaging.az.amqp.producer.send.duration", "Duration of AMQP-level send call.", "ms");
            this.requestResponseDuration = this.meter.createDoubleHistogram("messaging.az.amqp.management.request.duration", "Duration of AMQP request-response operation.", "ms");
            this.closedConnections = this.meter.createLongCounter("messaging.az.amqp.client.connections.closed", "Closed connections", "connections");
            this.sessionErrors = this.meter.createLongCounter("messaging.az.amqp.client.session.errors", "AMQP session errors", "errors");
            this.linkErrors = this.meter.createLongCounter("messaging.az.amqp.client.link.errors", "AMQP link errors", "errors");
            this.transportErrors = this.meter.createLongCounter("messaging.az.amqp.client.transport.errors", "AMQP session errors", "errors");
            this.addCredits = this.meter.createLongCounter("messaging.az.amqp.consumer.credits.requested", "Number of requested credits", "credits");
            this.prefetchedSequenceNumber = this.meter.createLongGauge("messaging.az.amqp.prefetch.sequence_number", "Last prefetched sequence number", "seqNo");
        }
    }

    public static AmqpMetricsProvider noop() {
        return NOOP;
    }

    public boolean isSendDeliveryEnabled() {
        return this.isEnabled && this.sendDuration.isEnabled();
    }

    public boolean isPrefetchedSequenceNumberEnabled() {
        return this.isEnabled && this.prefetchedSequenceNumber.isEnabled();
    }

    public void recordSend(long start, DeliveryState.DeliveryStateType deliveryState) {
        if (this.isEnabled && this.sendDuration.isEnabled()) {
            this.sendDuration.record((double)(Instant.now().toEpochMilli() - start), this.getDeliveryStateAttribute(deliveryState), Context.NONE);
        }
    }

    public void recordRequestResponseDuration(long start, String operationName, AmqpResponseCode responseCode) {
        if (this.isEnabled && this.requestResponseDuration.isEnabled()) {
            this.requestResponseDuration.record((double)(Instant.now().toEpochMilli() - start), this.getResponseCodeAttributes(responseCode, operationName), Context.NONE);
        }
    }

    public void recordConnectionClosed(ErrorCondition condition) {
        if (this.isEnabled && this.closedConnections.isEnabled()) {
            Symbol conditionSymbol = condition != null ? condition.getCondition() : null;
            String conditionStr = conditionSymbol != null ? conditionSymbol.toString() : "ok";
            this.closedConnections.add(1L, this.amqpErrorAttributeCache.getOrCreate(conditionStr), Context.NONE);
        }
    }

    public AutoCloseable trackPrefetchSequenceNumber(Supplier<Long> valueSupplier) {
        if (!this.isEnabled || !this.prefetchedSequenceNumber.isEnabled()) {
            return NOOP_CLOSEABLE;
        }
        return this.prefetchedSequenceNumber.registerCallback(valueSupplier, this.commonAttributes);
    }

    public void recordAddCredits(int credits) {
        if (this.isEnabled && this.addCredits.isEnabled()) {
            this.addCredits.add((long)credits, this.commonAttributes, Context.NONE);
        }
    }

    public void recordHandlerError(ErrorSource source, ErrorCondition condition) {
        if (this.isEnabled && condition != null && condition.getCondition() != null) {
            TelemetryAttributes attributes = this.amqpErrorAttributeCache.getOrCreate(condition.getCondition().toString());
            switch (source) {
                case LINK: {
                    if (!this.linkErrors.isEnabled()) break;
                    this.linkErrors.add(1L, attributes, Context.NONE);
                    break;
                }
                case SESSION: {
                    if (!this.sessionErrors.isEnabled()) break;
                    this.sessionErrors.add(1L, attributes, Context.NONE);
                    break;
                }
                case TRANSPORT: {
                    if (!this.transportErrors.isEnabled()) break;
                    this.transportErrors.add(1L, attributes, Context.NONE);
                    break;
                }
                default: {
                    LOGGER.verbose("Unexpected error source: {}", new Object[]{source});
                }
            }
        }
    }

    private TelemetryAttributes getDeliveryStateAttribute(DeliveryState.DeliveryStateType state) {
        int ind = state == null ? DELIVERY_STATES_COUNT - 1 : state.ordinal();
        TelemetryAttributes attrs = this.sendAttributeCache[ind];
        if (attrs != null) {
            return attrs;
        }
        return this.createDeliveryStateAttribute(state, ind);
    }

    private TelemetryAttributes getResponseCodeAttributes(AmqpResponseCode code, String operation) {
        int ind = code == null ? RESPONSE_CODES_COUNT - 1 : code.ordinal();
        AttributeCache codeAttributes = this.requestResponseAttributeCache[ind];
        if (codeAttributes == null) {
            codeAttributes = this.createResponseCodeAttribute(code, ind);
        }
        return codeAttributes.getOrCreate(operation);
    }

    private synchronized AttributeCache createResponseCodeAttribute(AmqpResponseCode code, int ind) {
        HashMap<String, Object> attrs = new HashMap<String, Object>(this.commonAttributesMap);
        attrs.put(STATUS_CODE_KEY, AmqpMetricsProvider.responseCodeToLowerCaseString(code));
        this.requestResponseAttributeCache[ind] = new AttributeCache(MANAGEMENT_OPERATION_KEY, attrs);
        return this.requestResponseAttributeCache[ind];
    }

    private synchronized TelemetryAttributes createDeliveryStateAttribute(DeliveryState.DeliveryStateType state, int ind) {
        HashMap<String, Object> attrs = new HashMap<String, Object>(this.commonAttributesMap);
        attrs.put("deliveryState", AmqpMetricsProvider.deliveryStateToLowerCaseString(state));
        this.sendAttributeCache[ind] = this.meter.createAttributes(attrs);
        return this.sendAttributeCache[ind];
    }

    private static String deliveryStateToLowerCaseString(DeliveryState.DeliveryStateType state) {
        if (state == null) {
            return "error";
        }
        switch (state) {
            case Accepted: {
                return "accepted";
            }
            case Declared: {
                return "declared";
            }
            case Modified: {
                return "modified";
            }
            case Received: {
                return "received";
            }
            case Rejected: {
                return "rejected";
            }
            case Released: {
                return "released";
            }
            case Transactional: {
                return "transactional";
            }
        }
        return "unknown";
    }

    private static String responseCodeToLowerCaseString(AmqpResponseCode response) {
        if (response == null) {
            return "error";
        }
        switch (response) {
            case OK: {
                return "ok";
            }
            case ACCEPTED: {
                return "accepted";
            }
            case BAD_REQUEST: {
                return "bad_request";
            }
            case NOT_FOUND: {
                return "not_found";
            }
            case FORBIDDEN: {
                return "forbidden";
            }
            case INTERNAL_SERVER_ERROR: {
                return "internal_server_error";
            }
            case UNAUTHORIZED: {
                return "unauthorized";
            }
            case CONTINUE: {
                return "continue";
            }
            case SWITCHING_PROTOCOLS: {
                return "switching_protocols";
            }
            case CREATED: {
                return "created";
            }
            case NON_AUTHORITATIVE_INFORMATION: {
                return "not_authoritative_information";
            }
            case NO_CONTENT: {
                return "no_content";
            }
            case RESET_CONTENT: {
                return "reset_content";
            }
            case PARTIAL_CONTENT: {
                return "partial_content";
            }
            case AMBIGUOUS: {
                return "ambiguous";
            }
            case MULTIPLE_CHOICES: {
                return "multiple_choices";
            }
            case MOVED: {
                return "moved";
            }
            case MOVED_PERMANENTLY: {
                return "moved_permanently";
            }
            case FOUND: {
                return "found";
            }
            case REDIRECT: {
                return "redirect";
            }
            case REDIRECT_METHOD: {
                return "redirect_method";
            }
            case SEE_OTHER: {
                return "see_other";
            }
            case NOT_MODIFIED: {
                return "not_modified";
            }
            case USE_PROXY: {
                return "use_proxy";
            }
            case UNUSED: {
                return "unused";
            }
            case REDIRECT_KEEP_VERB: {
                return "redirect_keep_verb";
            }
            case TEMPORARY_REDIRECT: {
                return "temporary_redirect";
            }
            case PAYMENT_REQUIRED: {
                return "payment_required";
            }
            case METHOD_NOT_ALLOWED: {
                return "method_no_allowed";
            }
            case NOT_ACCEPTABLE: {
                return "not_acceptable";
            }
            case PROXY_AUTHENTICATION_REQUIRED: {
                return "proxy_authentication_required";
            }
            case REQUEST_TIMEOUT: {
                return "request_timeout";
            }
            case CONFLICT: {
                return "conflict";
            }
            case GONE: {
                return "gone";
            }
            case LENGTH_REQUIRED: {
                return "length_required";
            }
            case PRECONDITION_FAILED: {
                return "precondition_failed";
            }
            case REQUEST_ENTITY_TOO_LARGE: {
                return "request_entity_is_too_large";
            }
            case REQUEST_URI_TOO_LONG: {
                return "request_uri_too_long";
            }
            case UNSUPPORTED_MEDIA_TYPE: {
                return "unsupported_media_type";
            }
            case REQUESTED_RANGE_NOT_SATISFIABLE: {
                return "requested_range_not_satisfiable";
            }
            case EXPECTATION_FAILED: {
                return "expectation_failed";
            }
            case UPGRADE_REQUIRED: {
                return "upgrade_required";
            }
            case NOT_IMPLEMENTED: {
                return "no_implemented";
            }
            case BAD_GATEWAY: {
                return "bad_gateway";
            }
            case SERVICE_UNAVAILABLE: {
                return "service_unavailable";
            }
            case GATEWAY_TIMEOUT: {
                return "gateway_timeout";
            }
            case HTTP_VERSION_NOT_SUPPORTED: {
                return "http_version_not_supported";
            }
        }
        return "error";
    }

    private class AttributeCache {
        private final Map<String, TelemetryAttributes> attr = new ConcurrentHashMap<String, TelemetryAttributes>();
        private final Map<String, Object> common;
        private final String dimensionName;

        AttributeCache(String dimensionName, Map<String, Object> common) {
            this.dimensionName = dimensionName;
            this.common = common;
        }

        public TelemetryAttributes getOrCreate(String value) {
            return this.attr.computeIfAbsent(value, this::create);
        }

        private TelemetryAttributes create(String value) {
            HashMap<String, Object> attributes = new HashMap<String, Object>(this.common);
            attributes.put(this.dimensionName, value);
            return AmqpMetricsProvider.this.meter.createAttributes(attributes);
        }
    }

    public static enum ErrorSource {
        LINK,
        SESSION,
        TRANSPORT;

    }
}

