/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.implementation.ClientConstants;
import com.azure.core.amqp.implementation.ReactorConnection;
import com.azure.core.amqp.implementation.ReactorDispatcher;
import com.azure.core.amqp.implementation.ReactorExecutor;
import com.azure.core.amqp.implementation.handler.ReactorHandler;
import com.azure.core.amqp.implementation.handler.TransportHandler;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.nio.channels.Pipe;
import java.time.Duration;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.reactor.Reactor;
import org.apache.qpid.proton.reactor.ReactorOptions;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class ReactorProvider {
    private static final ClientLogger LOGGER = new ClientLogger(ReactorProvider.class);
    private final Object lock = new Object();
    private Reactor reactor;
    private ReactorDispatcher reactorDispatcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reactor getReactor() {
        Object object = this.lock;
        synchronized (object) {
            return this.reactor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReactorDispatcher getReactorDispatcher() {
        Object object = this.lock;
        synchronized (object) {
            return this.reactorDispatcher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reactor createReactor(String connectionId, int maxFrameSize) throws IOException {
        TransportHandler transportHandler = new TransportHandler(connectionId);
        ReactorHandler reactorHandler = new ReactorHandler(connectionId);
        Object object = this.lock;
        synchronized (object) {
            if (this.reactor != null) {
                return this.reactor;
            }
            if (maxFrameSize <= 0) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'maxFrameSize' must be a positive number."));
            }
            ReactorOptions reactorOptions = new ReactorOptions();
            reactorOptions.setMaxFrameSize(maxFrameSize);
            reactorOptions.setEnableSaslByDefault(true);
            Reactor reactor = Proton.reactor((ReactorOptions)reactorOptions, (Handler[])new Handler[]{reactorHandler});
            reactor.getGlobalHandler().add((Handler)transportHandler);
            Pipe ioSignal = Pipe.open();
            ReactorDispatcher dispatcher = new ReactorDispatcher(connectionId, reactor, ioSignal);
            this.reactor = reactor;
            this.reactorDispatcher = dispatcher;
        }
        return this.reactor;
    }

    public ReactorExecutor createExecutor(Reactor reactor, String connectionId, String fullyQualifiedNamespace, ReactorConnection.ReactorExceptionHandler reactorExceptionHandler, AmqpRetryOptions retryOptions) {
        Duration timeoutDivided = retryOptions.getTryTimeout().dividedBy(2L);
        Duration pendingTasksDuration = ClientConstants.SERVER_BUSY_WAIT_TIME.compareTo(timeoutDivided) < 0 ? ClientConstants.SERVER_BUSY_WAIT_TIME : timeoutDivided;
        Scheduler scheduler = Schedulers.newSingle((String)"reactor-executor");
        return new ReactorExecutor(reactor, scheduler, connectionId, reactorExceptionHandler, pendingTasksDuration, fullyQualifiedNamespace);
    }
}

