/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.implementation.AmqpReceiveLink;
import com.azure.core.amqp.implementation.CreditAccountingStrategy;
import com.azure.core.util.logging.ClientLogger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscription;

final class RequestDrivenCreditAccountingStrategy
extends CreditAccountingStrategy {
    private static final int MAX_INT_PREFETCH_BOUND = 100;
    private static final long MAX_LONG_REQUEST_BOUND = 1L;
    private long pendingMessageCount;
    private boolean unbounded;
    private final AtomicLong requestAccumulated = new AtomicLong(0L);

    RequestDrivenCreditAccountingStrategy(AmqpReceiveLink receiver, Subscription subscription, int prefetch, ClientLogger logger) {
        super(receiver, subscription, RequestDrivenCreditAccountingStrategy.validateAndGet(prefetch, logger), logger);
    }

    @Override
    void update(long request, long emitted) {
        if (request == Long.MAX_VALUE) {
            this.unbounded = true;
        }
        long r = this.unbounded ? 1L : request;
        this.pendingMessageCount -= emitted;
        long c = r - this.pendingMessageCount + (long)this.prefetch;
        if (c > 0L) {
            this.pendingMessageCount += c;
            this.subscription.request(c);
            if (this.requestAccumulated.addAndGet(c) >= (long)this.prefetch) {
                this.scheduleCredit(() -> this.requestAccumulated.getAndSet(0L));
            }
        }
    }

    private static int validateAndGet(int prefetch, ClientLogger logger) {
        if (prefetch < 0) {
            throw logger.atInfo().log((RuntimeException)new IllegalArgumentException("prefetch >= 0 required but it was " + prefetch));
        }
        return prefetch == Integer.MAX_VALUE ? 100 : prefetch;
    }
}

