/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.AmqpShutdownSignal;
import com.azure.core.amqp.implementation.AmqpLoggingUtils;
import com.azure.core.util.logging.ClientLogger;

abstract class AmqpExceptionHandler {
    private static final ClientLogger LOGGER = new ClientLogger(AmqpExceptionHandler.class);

    AmqpExceptionHandler() {
    }

    void onConnectionError(Throwable exception) {
        LOGGER.warning("Connection exception encountered.", new Object[]{exception});
    }

    void onConnectionShutdown(AmqpShutdownSignal shutdownSignal) {
        AmqpLoggingUtils.addShutdownSignal(LOGGER.atInfo(), shutdownSignal).log("Shutdown received");
    }
}

