/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.implementation.AmqpMetricsProvider;
import com.azure.core.amqp.implementation.ReactorDispatcher;
import com.azure.core.amqp.implementation.handler.DeliverySettleMode;
import com.azure.core.amqp.implementation.handler.LinkHandler;
import com.azure.core.amqp.implementation.handler.ReceiverDeliveryHandler;
import com.azure.core.amqp.implementation.handler.ReceiverUnsettledDeliveries;
import com.azure.core.util.logging.LoggingEventBuilder;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.message.Message;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReceiveLinkHandler2
extends LinkHandler {
    private final String linkName;
    private final AtomicBoolean isRemoteActive = new AtomicBoolean();
    private final AtomicBoolean isTerminated = new AtomicBoolean();
    private final String entityPath;
    private final ReceiverUnsettledDeliveries unsettledDeliveries;
    private final ReceiverDeliveryHandler deliveryHandler;

    public ReceiveLinkHandler2(String connectionId, String hostname, String linkName, String entityPath, DeliverySettleMode settlingMode, ReactorDispatcher dispatcher, AmqpRetryOptions retryOptions, boolean includeDeliveryTagInMessage, AmqpMetricsProvider metricsProvider) {
        super(connectionId, hostname, entityPath, metricsProvider);
        this.linkName = Objects.requireNonNull(linkName, "'linkName' cannot be null.");
        this.entityPath = Objects.requireNonNull(entityPath, "'entityPath' cannot be null.");
        this.unsettledDeliveries = new ReceiverUnsettledDeliveries(hostname, entityPath, linkName, dispatcher, retryOptions, this.logger);
        this.deliveryHandler = new ReceiverDeliveryHandler(entityPath, linkName, settlingMode, this.unsettledDeliveries, includeDeliveryTagInMessage, this.logger);
    }

    public String getLinkName() {
        return this.linkName;
    }

    public Flux<Message> getMessages() {
        return this.deliveryHandler.getMessages();
    }

    @Override
    public void close() {
        if (this.isTerminated.getAndSet(true)) {
            return;
        }
        this.deliveryHandler.close("Could not emit messages.close when closing handler.");
        this.unsettledDeliveries.close();
        this.onNext(EndpointState.CLOSED);
    }

    public void onLinkLocalOpen(Event event) {
        Link link = event.getLink();
        if (link instanceof Receiver) {
            this.logger.atVerbose().addKeyValue("entityPath", this.entityPath).addKeyValue("linkName", link.getName()).addKeyValue("localSource", (Object)link.getSource()).log("onLinkLocalOpen");
        }
    }

    public void onLinkRemoteOpen(Event event) {
        Link link = event.getLink();
        if (!(link instanceof Receiver)) {
            return;
        }
        LoggingEventBuilder logBuilder = this.logger.atInfo().addKeyValue("entityPath", this.entityPath).addKeyValue("linkName", link.getName());
        if (link.getRemoteSource() != null) {
            logBuilder.addKeyValue("remoteSource", (Object)link.getRemoteSource());
            if (!this.isRemoteActive.getAndSet(true)) {
                this.onNext(EndpointState.ACTIVE);
            }
        } else {
            logBuilder.addKeyValue("action", "waitingForError");
        }
        logBuilder.log("onLinkRemoteOpen");
    }

    public void onDelivery(Event event) {
        if (!this.isRemoteActive.getAndSet(true)) {
            this.onNext(EndpointState.ACTIVE);
        }
        this.deliveryHandler.onDelivery(event.getDelivery());
    }

    @Override
    public void onLinkLocalClose(Event event) {
        super.onLinkLocalClose(event);
        if (!this.isRemoteActive.get()) {
            this.logger.atInfo().addKeyValue("entityPath", this.entityPath).addKeyValue("linkName", this.linkName).log("Receiver link was never active. Closing endpoint states");
            super.close();
        }
    }

    @Override
    public void onLinkRemoteClose(Event event) {
        this.deliveryHandler.close("Could not complete 'messages' when remotely closed.");
        this.unsettledDeliveries.close();
        super.onLinkRemoteClose(event);
    }

    @Override
    public void onLinkFinal(Event event) {
        this.close();
        super.onLinkFinal(event);
    }

    public Mono<Void> sendDisposition(String deliveryTag, DeliveryState desiredState) {
        return this.unsettledDeliveries.sendDisposition(deliveryTag, desiredState);
    }

    public Mono<Void> preClose() {
        this.deliveryHandler.preClose();
        return this.unsettledDeliveries.terminateAndAwaitForDispositionsInProgressToComplete();
    }

    @Override
    public void onError(Throwable e) {
        this.deliveryHandler.onLinkError();
        super.onError(e);
    }
}

