/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.geojson;

import com.azure.core.experimental.geojson.GeoLineStringCollection;
import com.azure.core.experimental.geojson.GeoPointCollection;
import com.azure.core.experimental.geojson.GeoPolygon;
import com.azure.core.experimental.geojson.GeoPolygonCollection;
import com.azure.core.util.logging.ClientLogger;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

final class GeoArray<T>
extends AbstractList<T> {
    private static final String NO_MUTATION_MESSAGE = "GeoArray cannot be mutated.";
    private final ClientLogger logger = new ClientLogger(GeoArray.class);
    private final Object container;

    GeoArray(Object container) {
        this.container = container;
    }

    @Override
    public T get(int index) {
        if (this.container instanceof List) {
            return (T)((List)this.container).get(index);
        }
        if (this.container instanceof GeoPointCollection) {
            return (T)((GeoPointCollection)this.container).getPoints().get(index).getCoordinates();
        }
        if (this.container instanceof GeoLineStringCollection) {
            return (T)((GeoLineStringCollection)this.container).getLines().get(index).getCoordinates();
        }
        if (this.container instanceof GeoPolygon) {
            return (T)((GeoPolygon)this.container).getRings().get(index).getCoordinates();
        }
        if (this.container instanceof GeoPolygonCollection) {
            return (T)((GeoPolygonCollection)this.container).getPolygons().get(index).getCoordinates();
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException());
    }

    @Override
    public int size() {
        if (this.container instanceof List) {
            return ((List)this.container).size();
        }
        if (this.container instanceof GeoPointCollection) {
            return ((GeoPointCollection)this.container).getPoints().size();
        }
        if (this.container instanceof GeoLineStringCollection) {
            return ((GeoLineStringCollection)this.container).getLines().size();
        }
        if (this.container instanceof GeoPolygon) {
            return ((GeoPolygon)this.container).getRings().size();
        }
        if (this.container instanceof GeoPolygonCollection) {
            return ((GeoPolygonCollection)this.container).getPolygons().size();
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException());
    }

    @Override
    public boolean remove(Object o) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(NO_MUTATION_MESSAGE));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(NO_MUTATION_MESSAGE));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(NO_MUTATION_MESSAGE));
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(NO_MUTATION_MESSAGE));
    }

    @Override
    public void sort(Comparator<? super T> c) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(NO_MUTATION_MESSAGE));
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(NO_MUTATION_MESSAGE));
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("GeoArray does not support sub lists."));
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoArray)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        GeoArray other = (GeoArray)o;
        return Objects.equals(this.container, other.container);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.container);
    }
}

