/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.geojson;

import com.azure.core.experimental.geojson.GeoArray;
import com.azure.core.experimental.geojson.GeoBoundingBox;
import com.azure.core.experimental.geojson.GeoObject;
import com.azure.core.experimental.geojson.GeoObjectType;
import com.azure.core.experimental.geojson.GeoPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class GeoLineString
extends GeoObject {
    private final GeoArray<GeoPosition> coordinates;

    public GeoLineString(List<GeoPosition> positions) {
        this(positions, null, null);
    }

    public GeoLineString(List<GeoPosition> positions, GeoBoundingBox boundingBox, Map<String, Object> customProperties) {
        super(boundingBox, customProperties);
        Objects.requireNonNull(positions, "'positions' cannot be null.");
        this.coordinates = new GeoArray(new ArrayList<GeoPosition>(positions));
    }

    public List<GeoPosition> getCoordinates() {
        return this.coordinates;
    }

    @Override
    public GeoObjectType getType() {
        return GeoObjectType.LINE_STRING;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.coordinates, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GeoLineString)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoLineString other = (GeoLineString)obj;
        return super.equals(other) && Objects.equals(this.coordinates, other.coordinates);
    }
}

