/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.geojson;

import com.azure.core.experimental.geojson.GeoArray;
import com.azure.core.experimental.geojson.GeoBoundingBox;
import com.azure.core.experimental.geojson.GeoLineString;
import com.azure.core.experimental.geojson.GeoObject;
import com.azure.core.experimental.geojson.GeoObjectType;
import com.azure.core.experimental.geojson.GeoPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class GeoLineStringCollection
extends GeoObject {
    private final List<GeoLineString> lines;

    public GeoLineStringCollection(List<GeoLineString> lines) {
        this(lines, null, null);
    }

    public GeoLineStringCollection(List<GeoLineString> lines, GeoBoundingBox boundingBox, Map<String, Object> customProperties) {
        super(boundingBox, customProperties);
        Objects.requireNonNull(lines, "'lines' cannot be null.");
        this.lines = Collections.unmodifiableList(new ArrayList<GeoLineString>(lines));
    }

    public List<GeoLineString> getLines() {
        return this.lines;
    }

    GeoArray<GeoArray<GeoPosition>> getCoordinates() {
        return new GeoArray<GeoArray<GeoPosition>>(this);
    }

    @Override
    public GeoObjectType getType() {
        return GeoObjectType.MULTI_LINE_STRING;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.lines, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GeoLineStringCollection)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoLineStringCollection other = (GeoLineStringCollection)obj;
        return super.equals(obj) && Objects.equals(this.lines, other.lines);
    }
}

