/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.geojson;

import com.azure.core.experimental.geojson.GeoArray;
import com.azure.core.experimental.geojson.GeoPosition;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class GeoLinearRing {
    private final GeoArray<GeoPosition> coordinates;

    public GeoLinearRing(List<GeoPosition> coordinates) {
        Objects.requireNonNull(coordinates, "'coordinates' cannot be null.");
        ClientLogger logger = new ClientLogger(GeoLinearRing.class);
        int size = coordinates.size();
        if (size < 4) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("A linear ring requires at least 4 coordinates."));
        }
        if (!Objects.equals(coordinates.get(0), coordinates.get(size - 1))) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The first and last coordinates of a linear ring must be equivalent."));
        }
        this.coordinates = new GeoArray(new ArrayList<GeoPosition>(coordinates));
    }

    public List<GeoPosition> getCoordinates() {
        return this.coordinates;
    }

    public int hashCode() {
        return this.coordinates.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GeoLinearRing)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoLinearRing other = (GeoLinearRing)obj;
        return Objects.equals(this.coordinates, other.coordinates);
    }
}

