/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.geojson;

import com.azure.core.experimental.geojson.GeoArray;
import com.azure.core.experimental.geojson.GeoBoundingBox;
import com.azure.core.experimental.geojson.GeoObject;
import com.azure.core.experimental.geojson.GeoObjectType;
import com.azure.core.experimental.geojson.GeoPolygon;
import com.azure.core.experimental.geojson.GeoPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class GeoPolygonCollection
extends GeoObject {
    private final List<GeoPolygon> polygons;

    public GeoPolygonCollection(List<GeoPolygon> polygons) {
        this(polygons, null, null);
    }

    public GeoPolygonCollection(List<GeoPolygon> polygons, GeoBoundingBox boundingBox, Map<String, Object> customProperties) {
        super(boundingBox, customProperties);
        Objects.requireNonNull(polygons, "'polygons' cannot be null.");
        this.polygons = Collections.unmodifiableList(new ArrayList<GeoPolygon>(polygons));
    }

    public List<GeoPolygon> getPolygons() {
        return this.polygons;
    }

    GeoArray<GeoArray<GeoArray<GeoPosition>>> getCoordinates() {
        return new GeoArray<GeoArray<GeoArray<GeoPosition>>>(this);
    }

    @Override
    public GeoObjectType getType() {
        return GeoObjectType.MULTI_POLYGON;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.polygons, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GeoPolygonCollection)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoPolygonCollection other = (GeoPolygonCollection)obj;
        return super.equals(obj) && Objects.equals(this.polygons, other.polygons);
    }
}

