/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.geojson;

import com.azure.core.util.logging.ClientLogger;
import java.util.Objects;

public final class GeoPosition {
    private final ClientLogger logger = new ClientLogger(GeoPosition.class);
    private final double longitude;
    private final double latitude;
    private final Double altitude;

    public GeoPosition(double longitude, double latitude) {
        this(longitude, latitude, null);
    }

    public GeoPosition(double longitude, double latitude, Double altitude) {
        this.longitude = longitude;
        this.latitude = latitude;
        this.altitude = altitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public Double getAltitude() {
        return this.altitude;
    }

    public int count() {
        return this.altitude == null ? 2 : 3;
    }

    public double get(int index) {
        switch (index) {
            case 0: {
                return this.longitude;
            }
            case 1: {
                return this.latitude;
            }
            case 2: {
                if (this.altitude == null) {
                    throw this.logger.logExceptionAsError((RuntimeException)new IndexOutOfBoundsException("Index out of range: " + index));
                }
                return this.altitude;
            }
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IndexOutOfBoundsException("Index out of range: " + index));
    }

    public int hashCode() {
        return Objects.hash(this.longitude, this.latitude, this.altitude);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GeoPosition)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        GeoPosition other = (GeoPosition)obj;
        return Double.compare(this.longitude, other.longitude) == 0 && Double.compare(this.latitude, other.latitude) == 0 && Objects.equals(this.altitude, other.altitude);
    }

    public String toString() {
        return this.altitude != null ? String.format("[%s, %s, %s]", this.longitude, this.latitude, this.altitude) : String.format("[%s, %s]", this.longitude, this.latitude);
    }
}

